# 帳票設計書 2-ReDoc HTML

## 概要

本ドキュメントは、FastAPIフレームワークにおけるReDoc HTML帳票の設計仕様を定義する。ReDocは、OpenAPI仕様書に基づいて代替的なAPIドキュメントを生成するためのHTMLページである。

### 本帳票の処理概要

ReDoc HTMLは、FastAPIアプリケーションのAPIドキュメントを読みやすく整理された形式で表示する帳票である。Swagger UIとは異なり、対話的なAPI実行機能は持たないが、ドキュメントとしての可読性に優れた表示を提供する。この帳票は、`/redoc`エンドポイントにアクセスした際に動的に生成される。

**業務上の目的・背景**：Swagger UIは対話的な操作に優れるが、純粋なドキュメント閲覧目的では情報量が多く読みにくい場合がある。ReDocは、API仕様を「読む」ことに特化したビューアとして、Swagger UIの代替または補完として機能する。特に、外部開発者や非技術者に対してAPIドキュメントを提供する際に、より見やすいインターフェースを提供する。

**帳票の利用シーン**：API仕様の閲覧・確認、外部パートナーへのAPI仕様共有、技術ドキュメントの印刷・PDF化、社内でのAPI仕様レビュー時に利用される。

**主要な出力内容**：
1. APIエンドポイントの階層的な一覧表示
2. リクエスト/レスポンススキーマの詳細表示
3. 認証方式の説明
4. APIの概要説明とメタデータ
5. 三分割レイアウト（左：ナビゲーション、中：コンテンツ、右：コード例）

**帳票の出力タイミング**：FastAPIアプリケーション起動後、`/redoc`（デフォルト）エンドポイントへのHTTPリクエスト時に動的生成される。

**帳票の利用者**：API開発者、外部開発者、プロダクトマネージャー、テクニカルライター、API利用者

## 帳票種別

静的APIドキュメント（HTMLページ）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 1 | ReDoc | /redoc（デフォルト、変更可能） | ブラウザでURLにアクセス |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML |
| 用紙サイズ | N/A（Webページ） |
| 向き | N/A |
| ファイル名 | N/A（動的生成） |
| 出力方法 | HTTPレスポンス（ブラウザ表示） |
| 文字コード | UTF-8 |

### HTML固有設定

| 項目 | 内容 |
|-----|------|
| Content-Type | text/html; charset=utf-8 |
| JavaScript依存 | redoc.standalone.js（CDN） |
| CSS依存 | インライン（bodyのmargin/padding） |
| Favicon | FastAPI公式アイコン |
| Google Fonts | Montserrat, Roboto（オプション） |

## 帳票レイアウト

### レイアウト概要

ReDocは、三分割レイアウトを採用し、ナビゲーション・コンテンツ・コードサンプルを同時に表示する構成である。

```
┌─────────────────────────────────────────────────┐
│                  ヘッダー部                      │
│   ・ページタイトル（ブラウザタブ）                 │
├──────────┬────────────────────┬─────────────────┤
│ 左サイド   │     メインコンテンツ  │   右サイド      │
│ バー      │                    │                 │
│          │  ・API概要          │  ・リクエスト例  │
│ ・目次    │  ・エンドポイント詳細 │  ・レスポンス例  │
│ ・検索    │  ・スキーマ定義      │                 │
│          │                    │                 │
└──────────┴────────────────────┴─────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | ページタイトル | ブラウザタブに表示されるタイトル | FastAPI.title + " - ReDoc" | テキスト |
| 2 | Favicon | ブラウザタブのアイコン | redoc_favicon_url パラメータ | 画像 |
| 3 | ビューポート | レスポンシブ対応設定 | meta viewport | meta タグ |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | API情報 | タイトル、バージョン、説明 | OpenAPI info | テキスト | 自動 |
| 2 | サーバー情報 | 接続先サーバー一覧 | OpenAPI servers | リスト | 自動 |
| 3 | 認証情報 | 認証方式の説明 | OpenAPI securitySchemes | セクション | 自動 |
| 4 | エンドポイント | API操作の詳細 | OpenAPI paths | 展開可能セクション | 自動 |
| 5 | スキーマ | データモデル定義 | OpenAPI components/schemas | 展開可能セクション | 自動 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | N/A | フッター部なし | - | - |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| openapi_url設定 | OpenAPI JSONのURLが設定されていること | Yes |
| redoc_url設定 | ReDocのURLが設定されていること（Noneでない） | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | タグ順 | OpenAPI tags定義順 |
| 2 | エンドポイントパス | 定義順 |

### 改ページ条件

N/A（Webページのためスクロール表示）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | データベースへの直接参照なし | - |

### OpenAPIスキーマからの参照

ReDocはOpenAPI JSONスキーマを参照して表示を行う。OpenAPI JSONは`get_openapi()`関数により、アプリケーションに登録されたルート情報から動的に生成される。

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| openapi_url | root_path + self.openapi_url | N/A | ルートパスの結合 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[/redoc へのHTTPリクエスト] --> B[redoc_html関数呼び出し]
    B --> C[root_path取得]
    C --> D[openapi_url計算]
    D --> E[get_redoc_html呼び出し]
    E --> F{with_google_fonts?}
    F -->|Yes| G[Google Fontsリンク追加]
    F -->|No| H[フォントリンクなし]
    G --> I[HTML文字列生成]
    H --> I
    I --> J[HTMLResponse返却]
    J --> K[ブラウザ表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 404 Not Found | redoc_urlがNoneに設定されている場合 | ページが見つかりません | redoc_urlを設定する |
| JavaScript無効 | ブラウザでJavaScriptが無効 | "ReDoc requires Javascript to function..." | JavaScriptを有効化 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1リクエストにつき1HTML生成 |
| 目標出力時間 | 50ms以下（Swagger UIより軽量） |
| 同時出力数上限 | Webサーバーの同時接続数に依存 |

## セキュリティ考慮事項

- 本番環境ではredoc_urlをNoneに設定してReDocを無効化することを推奨
- 外部CDNへの依存があるため、CSP（Content Security Policy）の設定に注意
- Google Fontsを使用する場合、外部サーバーへの接続が発生する

## 備考

- ReDocのJavaScriptはデフォルトでCDN（jsDelivr）から読み込まれる
- セルフホスティング環境では、redoc_js_urlをカスタマイズ可能
- with_google_fontsパラメータでGoogle Fontsの読み込みを制御可能
- ReDocはSwagger UIと比較してシンプルなHTMLを生成するため、軽量

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ReDoc HTMLは比較的シンプルな構造で、主要なパラメータを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | docs.py | `fastapi/openapi/docs.py` | get_redoc_html関数のパラメータ定義（行161-207）を確認 |

**読解のコツ**: ReDocはSwagger UIよりパラメータが少なく、シンプルな構造である。主要なパラメータはopenapi_url、title、redoc_js_url、redoc_favicon_url、with_google_fontsの5つ。

#### Step 2: エントリーポイントを理解する

処理の起点となるFastAPIアプリケーションのsetup()メソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | applications.py | `fastapi/applications.py` | setup()メソッド（行1121-1130）でReDocルートの登録を確認 |

**主要処理フロー**:
1. **行1121**: openapi_urlとredoc_urlの両方が設定されているかチェック
2. **行1123-1128**: redoc_html内部関数でroot_pathを取得しget_redoc_html()を呼び出し
3. **行1130**: add_route()でReDocのルートを登録

#### Step 3: HTML生成処理を理解する

get_redoc_html()関数の詳細を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | docs.py | `fastapi/openapi/docs.py` | get_redoc_html関数（行161-253）でHTML生成ロジックを確認 |

**主要処理フロー**:
- **行219-227**: HTML文字列の構築開始（DOCTYPE、head、title、meta）
- **行228-231**: with_google_fontsがTrueの場合、Google Fontsリンクを追加
- **行232-243**: favicon、スタイル設定
- **行244-248**: noscript要素とredocカスタム要素
- **行249**: ReDoc JavaScriptの読み込み
- **行252-253**: HTML文字列の完成とHTMLResponseの返却

### プログラム呼び出し階層図

```
FastAPI.__init__()
    │
    └─ setup()
           │
           └─ redoc_html() [内部関数]
                  │
                  └─ get_redoc_html()
                         └─ HTMLResponse
```

### データフロー図

```
[入力]                    [処理]                         [出力]

HTTPリクエスト ──────▶ redoc_html() ──────────────────▶ HTMLResponse
  └ /redoc                  │
                            ├─ root_path取得
                            ├─ openapi_url計算
                            │
                            └─ get_redoc_html()
                                   │
                                   ├─ Google Fonts判定
                                   ├─ HTML文字列構築
                                   └─ HTMLResponse生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| docs.py | `fastapi/openapi/docs.py` | ソース | ReDoc HTML生成の主要ロジック |
| applications.py | `fastapi/applications.py` | ソース | FastAPIアプリケーションのセットアップとルート登録 |
| utils.py | `fastapi/openapi/utils.py` | ソース | OpenAPIスキーマ生成（ReDocが参照） |
| responses.py | `fastapi/responses.py` | ソース | レスポンスクラスの定義（HTMLResponse等） |
