# 帳票設計書 3-OAuth2リダイレクトHTML

## 概要

本ドキュメントは、FastAPIフレームワークにおけるOAuth2リダイレクトHTML帳票の設計仕様を定義する。OAuth2リダイレクトHTMLは、Swagger UI上でOAuth2認証フローを完了するために必要なリダイレクト処理を行うHTMLページである。

### 本帳票の処理概要

OAuth2リダイレクトHTMLは、Swagger UIでOAuth2認証を使用する際のコールバックページとして機能する帳票である。OAuth2認証プロバイダーからの認証レスポンスを受け取り、認証コードまたはアクセストークンをSwagger UIに渡す役割を担う。この帳票は、`/docs/oauth2-redirect`（デフォルト）エンドポイントにアクセスした際に提供される。

**業務上の目的・背景**：OAuth2認証を使用するAPIでは、認証プロバイダーからのリダイレクトを適切に処理する必要がある。このHTMLページは、OAuth2認証フローにおいてブラウザベースのリダイレクトを処理し、Swagger UIが認証状態を取得できるようにする。これにより、開発者はSwagger UI上で認証が必要なAPIエンドポイントをテストできる。

**帳票の利用シーン**：Swagger UIでOAuth2認証が必要なAPIをテストする際、認証プロバイダー（Auth0、Keycloak、Azure AD等）からのリダイレクト時に自動的に表示される。

**主要な出力内容**：
1. OAuth2認証レスポンスのパース処理（JavaScript）
2. 認証コード/トークンの抽出
3. state検証によるセキュリティチェック
4. 親ウィンドウ（Swagger UI）へのコールバック
5. エラー処理とエラーメッセージの表示

**帳票の出力タイミング**：OAuth2認証プロバイダーからのリダイレクト時に自動的に表示される。直接アクセスされることは通常ない。

**帳票の利用者**：API開発者（Swagger UIでのOAuth2認証テスト時）

## 帳票種別

認証リダイレクトページ（HTMLページ）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 1 | OAuth2 Redirect | /docs/oauth2-redirect（デフォルト、変更可能） | OAuth2認証プロバイダーからのリダイレクト |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML |
| 用紙サイズ | N/A（Webページ） |
| 向き | N/A |
| ファイル名 | N/A（動的生成） |
| 出力方法 | HTTPレスポンス（ブラウザ表示、即座にクローズ） |
| 文字コード | UTF-8 |

### HTML固有設定

| 項目 | 内容 |
|-----|------|
| Content-Type | text/html; charset=utf-8 |
| JavaScript依存 | インライン（外部依存なし） |
| CSS依存 | なし |
| 動作 | 処理完了後に自動でウィンドウクローズ |

## 帳票レイアウト

### レイアウト概要

OAuth2リダイレクトHTMLは、実質的にはUIを持たない処理専用のページである。

```
┌─────────────────────────────────────┐
│          ヘッダー部                  │
│   ・タイトル（ブラウザタブ）          │
├─────────────────────────────────────┤
│          ボディ部                    │
│   （空：表示要素なし）               │
├─────────────────────────────────────┤
│          スクリプト部                │
│   ・OAuth2レスポンス処理             │
│   ・コールバック実行                  │
│   ・ウィンドウクローズ               │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | ページタイトル | ブラウザタブに表示されるタイトル | 固定値 "Swagger UI: OAuth2 Redirect" | テキスト |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | N/A | 表示要素なし | - | - | - |

### スクリプト部

| No | 処理名 | 説明 | トリガー |
|----|-------|------|---------|
| 1 | run() | メイン処理関数 | DOMContentLoaded または即時実行 |
| 2 | URLパラメータ解析 | hash または search からパラメータ取得 | run()内 |
| 3 | state検証 | CSRF対策のstate値検証 | run()内 |
| 4 | コールバック実行 | 親ウィンドウへ結果通知 | run()内 |
| 5 | ウィンドウクローズ | window.close() | コールバック後 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| openapi_url設定 | OpenAPI JSONのURLが設定されていること | Yes |
| docs_url設定 | Swagger UIのURLが設定されていること | Yes |
| swagger_ui_oauth2_redirect_url設定 | リダイレクトURLが設定されていること | Yes |

### ソート順

N/A（単一ページ）

### 改ページ条件

N/A（処理専用ページ）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | データベースへの直接参照なし | - |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| qp（クエリパラメータ） | window.location.hash または location.search からパース | N/A | JSON形式に変換 |
| isValid | qp.state === sentState | N/A | boolean |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[OAuth2プロバイダーからリダイレクト] --> B[ページ読み込み]
    B --> C[run関数実行]
    C --> D{hash/searchにcode/token/error?}
    D -->|hash| E[hashからパラメータ抽出]
    D -->|search| F[searchからパラメータ抽出]
    E --> G[パラメータをJSON化]
    F --> G
    G --> H[state検証]
    H --> I{認証フロー種別?}
    I -->|accessCode/authorizationCode| J[認証コード処理]
    I -->|その他| K[トークン処理]
    J --> L{コードあり?}
    L -->|Yes| M[oauth2.callback実行]
    L -->|No| N[oauth2.errCb実行]
    K --> M
    M --> O[window.close]
    N --> O
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| State不一致 | stateパラメータがリクエスト時と異なる | "Authorization may be unsafe..." | CSRF攻撃の可能性、再認証 |
| 認証コードなし | codeパラメータが含まれていない | "[Authorization failed]: no accessCode received from the server." | 認証プロバイダーの設定確認 |
| OAuth2エラー | errorパラメータが含まれている | "[error]: error_description" | 認証プロバイダーの設定確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1リクエストにつき1HTML生成 |
| 目標出力時間 | 10ms以下（軽量静的HTML） |
| 同時出力数上限 | 認証フローごとに1回のみ使用 |

## セキュリティ考慮事項

- stateパラメータによるCSRF対策を実施
- 親ウィンドウ（Swagger UI）との通信はwindow.openerを使用
- 処理完了後は即座にウィンドウをクローズ
- エラー情報は必要最小限のみ表示

## 備考

- このHTMLはSwagger UI v4.14.0のoauth2-redirect.htmlをベースにしている
- 直接ブラウザでアクセスしても機能しない（親ウィンドウからのoauth2オブジェクトが必要）
- OAuth2の各種フロー（authorization_code, implicit等）に対応

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 関数の概要を理解する

OAuth2リダイレクトHTML生成関数の全体像を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | docs.py | `fastapi/openapi/docs.py` | get_swagger_ui_oauth2_redirect_html関数（行256-344）を確認 |

**読解のコツ**: この関数は引数を持たず、固定のHTMLを返す非常にシンプルな構造である。HTMLに埋め込まれたJavaScriptがOAuth2処理の核心部分。

#### Step 2: エントリーポイントを理解する

処理の起点となるFastAPIアプリケーションのsetup()メソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | applications.py | `fastapi/applications.py` | setup()メソッド（行1111-1120）でOAuth2リダイレクトルートの登録を確認 |

**主要処理フロー**:
1. **行1111**: swagger_ui_oauth2_redirect_urlが設定されているかチェック
2. **行1113-1114**: swagger_ui_redirect内部関数でget_swagger_ui_oauth2_redirect_html()を呼び出し
3. **行1116-1120**: add_route()でOAuth2リダイレクトのルートを登録

#### Step 3: JavaScript処理を理解する

埋め込まれたJavaScriptの処理フローを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | docs.py | `fastapi/openapi/docs.py` | run関数内のJavaScript処理（行272-330）を確認 |

**主要処理フロー**:
- **行273-275**: oauth2オブジェクトを親ウィンドウから取得
- **行278-282**: URLからcode/token/errorを含むパラメータを抽出
- **行284-290**: パラメータをJSON形式に変換
- **行292**: state検証
- **行294-311**: authorization_codeフローの処理（コード取得とエラー処理）
- **行327-329**: 暗黙フロー等の処理（トークンを直接コールバック）
- **行330**: ウィンドウをクローズ

### プログラム呼び出し階層図

```
FastAPI.__init__()
    │
    └─ setup()
           │
           └─ swagger_ui_redirect() [内部関数]
                  │
                  └─ get_swagger_ui_oauth2_redirect_html()
                         │
                         └─ HTMLResponse
                                │
                                └─ [ブラウザ側] run() JavaScript実行
                                       │
                                       ├─ oauth2オブジェクト取得
                                       ├─ URLパラメータ解析
                                       ├─ state検証
                                       ├─ callback/errCb実行
                                       └─ window.close()
```

### データフロー図

```
[入力]                        [処理]                         [出力]

OAuth2プロバイダー ────────▶ ブラウザリダイレクト ──────▶ OAuth2リダイレクトHTML
  └ code/token/state            │                              │
                                │                              ▼
                                │                      run() JavaScript
                                │                              │
                                │                              ├─ パラメータ解析
                                │                              ├─ state検証
                                │                              │
                                ▼                              ▼
                        Swagger UI (親ウィンドウ) ◀────── oauth2.callback()
                                                              │
                                                              ▼
                                                       window.close()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| docs.py | `fastapi/openapi/docs.py` | ソース | OAuth2リダイレクトHTML生成の主要ロジック |
| applications.py | `fastapi/applications.py` | ソース | FastAPIアプリケーションのセットアップとルート登録 |
| responses.py | `fastapi/responses.py` | ソース | レスポンスクラスの定義（HTMLResponse等） |
