# 帳票設計書 4-OpenAPI JSON

## 概要

本ドキュメントは、FastAPIフレームワークにおけるOpenAPI JSON帳票の設計仕様を定義する。OpenAPI JSONは、APIの完全な仕様をJSON形式で出力するドキュメントであり、Swagger UIやReDoc、その他のAPI開発ツールの基盤となる。

### 本帳票の処理概要

OpenAPI JSONは、FastAPIアプリケーションに登録された全てのルート、パラメータ、レスポンス、セキュリティ設定等をOpenAPI 3.1.0仕様に準拠したJSON形式で出力する帳票である。この帳票は、`/openapi.json`（デフォルト）エンドポイントにアクセスした際に動的に生成される。Swagger UIやReDocはこのJSONを読み込んでドキュメントを表示する。

**業務上の目的・背景**：API仕様を機械可読な形式で提供することは、API開発エコシステムにおいて極めて重要である。OpenAPI JSONにより、クライアントSDKの自動生成、APIテストツールとの連携、ドキュメント自動生成、APIゲートウェイとの統合が可能になる。FastAPIはルート定義から自動的にOpenAPIスキーマを生成することで、開発者の作業負荷を軽減し、仕様とコードの乖離を防止する。

**帳票の利用シーン**：Swagger UI/ReDocでのドキュメント表示、APIクライアント自動生成、APIテストツール（Postman等）へのインポート、CI/CDパイプラインでのAPI仕様検証、APIゲートウェイ設定時に利用される。

**主要な出力内容**：
1. API基本情報（title, version, description等）
2. サーバー情報（接続先URL一覧）
3. パス定義（エンドポイント、メソッド、パラメータ、レスポンス）
4. コンポーネント定義（スキーマ、セキュリティスキーム）
5. タグ定義とWebhook定義

**帳票の出力タイミング**：FastAPIアプリケーション起動後、`/openapi.json`（デフォルト）エンドポイントへのHTTPリクエスト時に動的生成される。初回生成後はキャッシュされる。

**帳票の利用者**：Swagger UI/ReDoc、API開発者、DevOpsエンジニア、外部開発ツール

## 帳票種別

API仕様書（JSON形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 1 | OpenAPI JSON | /openapi.json（デフォルト、変更可能） | HTTPリクエスト（GET） |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（動的生成） |
| 出力方法 | HTTPレスポンス（JSONResponse） |
| 文字コード | UTF-8 |

### JSON固有設定

| 項目 | 内容 |
|-----|------|
| Content-Type | application/json |
| OpenAPIバージョン | 3.1.0（デフォルト、変更可能） |
| JSONエンコーディング | jsonable_encoder使用 |

## 帳票レイアウト

### レイアウト概要

OpenAPI JSONは、OpenAPI 3.1.0仕様に準拠した階層構造を持つ。

```json
{
  "openapi": "3.1.0",
  "info": { ... },
  "servers": [ ... ],
  "paths": { ... },
  "webhooks": { ... },
  "components": { ... },
  "tags": [ ... ],
  "externalDocs": { ... }
}
```

### トップレベル構造

| No | 項目名 | 説明 | データ取得元 | 必須 |
|----|-------|------|-------------|-----|
| 1 | openapi | OpenAPIバージョン | self.openapi_version | Yes |
| 2 | info | API基本情報 | title, version, description等 | Yes |
| 3 | servers | サーバー情報 | self.servers | No |
| 4 | paths | エンドポイント定義 | self.routes | Yes |
| 5 | webhooks | Webhook定義 | self.webhooks.routes | No |
| 6 | components | 再利用可能コンポーネント | スキーマ、セキュリティ定義 | No |
| 7 | tags | タグ定義 | self.openapi_tags | No |
| 8 | externalDocs | 外部ドキュメント | self.openapi_external_docs | No |

### infoオブジェクト

| No | 項目名 | 説明 | データ取得元 | 必須 |
|----|-------|------|-------------|-----|
| 1 | title | APIタイトル | FastAPI.title | Yes |
| 2 | version | APIバージョン | FastAPI.version | Yes |
| 3 | summary | API概要 | FastAPI.summary | No |
| 4 | description | API詳細説明 | FastAPI.description | No |
| 5 | termsOfService | 利用規約URL | FastAPI.terms_of_service | No |
| 6 | contact | 連絡先情報 | FastAPI.contact | No |
| 7 | license | ライセンス情報 | FastAPI.license_info | No |

### pathsオブジェクト

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | パスキー | エンドポイントパス | route.path_format | "/users/{id}" |
| 2 | メソッドキー | HTTPメソッド | route.methods | "get", "post"等 |
| 3 | operationId | 操作ID | route.operation_id / unique_id | 文字列 |
| 4 | summary | 操作概要 | route.summary | 文字列 |
| 5 | description | 操作詳細 | route.description | 文字列 |
| 6 | parameters | パラメータ一覧 | route.dependant | 配列 |
| 7 | requestBody | リクエストボディ | route.body_field | オブジェクト |
| 8 | responses | レスポンス定義 | route.responses | オブジェクト |
| 9 | security | セキュリティ要件 | security_dependencies | 配列 |
| 10 | tags | タグ | route.tags | 配列 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| openapi_url設定 | OpenAPI JSONのURLが設定されていること（Noneでない） | Yes |
| title設定 | APIタイトルが設定されていること | Yes |
| version設定 | APIバージョンが設定されていること | Yes |
| include_in_schema | ルートがスキーマに含まれる設定であること | Yes（各ルート） |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | componentsのschemas | キー名でソート（昇順） |

### 改ページ条件

N/A（JSON形式）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | データベースへの直接参照なし | - |

### アプリケーション情報の参照

OpenAPI JSONは、FastAPIアプリケーションインスタンスに登録された情報から生成される。

| 参照元 | 取得情報 |
|--------|---------|
| FastAPI.__init__ | title, version, description, servers等 |
| self.routes | 全登録ルートのパス情報 |
| self.webhooks.routes | Webhook定義 |
| route.dependant | パラメータ、ボディ、セキュリティ情報 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| operation_id | route.operation_id or route.unique_id | N/A | 一意性チェック付き |
| summary | route.summary or route.name.replace("_", " ").title() | N/A | 自動生成 |
| status_code | route.status_code or response_class default | N/A | 数値→文字列変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[/openapi.json へのHTTPリクエスト] --> B{openapi_schemaキャッシュあり?}
    B -->|Yes| C[キャッシュ返却]
    B -->|No| D[get_openapi関数呼び出し]
    D --> E[info構築]
    E --> F[get_fields_from_routes]
    F --> G[model_name_map生成]
    G --> H[field_mapping, definitions生成]
    H --> I[各ルートをget_openapi_pathで処理]
    I --> J[paths構築]
    J --> K[webhooks構築]
    K --> L[components構築]
    L --> M[OpenAPIモデル検証]
    M --> N[jsonable_encoderでJSON化]
    N --> O[openapi_schemaにキャッシュ]
    O --> C
    C --> P[JSONResponse返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| AssertionError | titleが未設定 | "A title must be provided for OpenAPI" | titleを設定 |
| AssertionError | versionが未設定 | "A version must be provided for OpenAPI" | versionを設定 |
| 重複operation_id | 同一operation_idが複数存在 | Warning出力 | operation_idを一意に設定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | ルート数×パラメータ数に依存 |
| 目標出力時間 | 初回: ルート数に依存、2回目以降: 10ms以下（キャッシュ） |
| 同時出力数上限 | Webサーバーの同時接続数に依存 |

## セキュリティ考慮事項

- 本番環境ではopenapi_urlをNoneに設定して無効化することを推奨
- 内部APIの場合、外部からのアクセスを制限
- セキュリティスキーム情報が含まれるため、公開範囲に注意
- include_in_schema=Falseで特定ルートを除外可能

## 備考

- OpenAPI JSONは初回リクエスト時に生成され、以降はキャッシュされる
- openapi_versionプロパティでバージョンを変更可能（互換性ハック用）
- separate_input_output_schemasで入出力スキーマの分離が可能
- root_path_in_serversでサーバー情報に自動追加が可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

OpenAPIスキーマの基本構造とモデル定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | utils.py | `fastapi/openapi/utils.py` | validation_error_definition等の定義（行41-75）を確認 |

**読解のコツ**: OpenAPIスキーマはPydanticモデル（OpenAPI）を使用して検証される。REF_PREFIXは"#/components/schemas/"を指す。

#### Step 2: エントリーポイントを理解する

処理の起点となるFastAPIアプリケーションのopenapi()メソッドとsetup()を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | applications.py | `fastapi/applications.py` | openapi()メソッド（行1046-1077）でスキーマ生成・キャッシュを確認 |
| 2-2 | applications.py | `fastapi/applications.py` | setup()メソッド（行1080-1092）でルート登録を確認 |

**主要処理フロー**:
1. **行1060-1077**: openapi_schemaがNoneの場合、get_openapi()を呼び出して生成
2. **行1084-1092**: setup()内でopenapi関数を定義し、ルートとして登録
3. **行1090**: JSONResponseでself.openapi()の結果を返却

#### Step 3: スキーマ生成処理を理解する

get_openapi()関数の詳細を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | utils.py | `fastapi/openapi/utils.py` | get_openapi関数（行476-567）でスキーマ生成ロジックを確認 |

**主要処理フロー**:
- **行493-504**: info辞書の構築
- **行507-510**: 初期output辞書の構築（openapi, info）
- **行511**: get_fields_from_routesで全フィールド取得
- **行512-517**: model_name_mapとdefinitionsの生成
- **行518-536**: 各ルートをget_openapi_pathで処理
- **行556-557**: schemasをソートしてcomponentsに追加
- **行567**: OpenAPIモデルで検証後、jsonable_encoderで返却

#### Step 4: パス情報生成を理解する

get_openapi_path()関数で個別ルートの処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | utils.py | `fastapi/openapi/utils.py` | get_openapi_path関数（行259-442）でパス情報生成を確認 |

**主要処理フロー**:
- **行280-283**: メタデータ取得（tags, summary, operationId等）
- **行285-292**: セキュリティ定義の抽出
- **行293-312**: パラメータの処理
- **行313-321**: リクエストボディの処理
- **行339-373**: レスポンスの処理
- **行418-438**: 422バリデーションエラーの追加

### プログラム呼び出し階層図

```
FastAPI.__init__()
    │
    └─ setup()
           │
           └─ openapi() [内部関数]
                  │
                  └─ self.openapi()
                         │
                         └─ get_openapi()
                                │
                                ├─ get_fields_from_routes()
                                ├─ get_compat_model_name_map()
                                ├─ get_definitions()
                                │
                                └─ get_openapi_path() [各ルート]
                                       │
                                       ├─ get_openapi_operation_metadata()
                                       ├─ get_openapi_security_definitions()
                                       ├─ _get_openapi_operation_parameters()
                                       └─ get_openapi_operation_request_body()
```

### データフロー図

```
[入力]                        [処理]                              [出力]

FastAPI設定 ─────────────▶ get_openapi() ─────────────────────▶ JSONResponse
  ├ title                      │                                    │
  ├ version                    ├─ info構築                          │
  ├ description                ├─ servers追加                       │
  └ routes ──────────────▶     │                                    │
      │                        ├─ paths構築 ◀─── get_openapi_path() │
      │                        ├─ webhooks構築                      │
      │                        ├─ components構築                    │
      │                        │                                    │
      │                        └─ OpenAPI検証                       │
      │                              │                              │
      ▼                              ▼                              ▼
  route.dependant ────▶ パラメータ/ボディ/セキュリティ抽出 ──▶ JSON出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| utils.py | `fastapi/openapi/utils.py` | ソース | OpenAPIスキーマ生成の主要ロジック |
| applications.py | `fastapi/applications.py` | ソース | FastAPIアプリケーションとルート登録 |
| models.py | `fastapi/openapi/models.py` | ソース | OpenAPIスキーマのPydanticモデル定義 |
| encoders.py | `fastapi/encoders.py` | ソース | JSONエンコーディング処理 |
| routing.py | `fastapi/routing.py` | ソース | APIRouteクラス定義 |
| _compat.py | `fastapi/_compat.py` | ソース | Pydantic互換性ヘルパー |
| constants.py | `fastapi/openapi/constants.py` | ソース | 定数定義（REF_PREFIX等） |
