# 帳票設計書 5-FileResponse

## 概要

本ドキュメントは、FastAPIフレームワークにおけるFileResponse帳票の設計仕様を定義する。FileResponseは、静的ファイルをダウンロード可能な形式でクライアントに返却するためのレスポンスクラスである。

### 本帳票の処理概要

FileResponseは、サーバー上に存在するファイルをHTTPレスポンスとして返却する帳票である。ファイルのContent-Typeを自動検出し、ファイル名を指定してダウンロードを促すことも可能である。FastAPIはStarletteのFileResponseをそのまま再エクスポートしており、FastAPI独自の実装は持たない。

**業務上の目的・背景**：Webアプリケーションにおいて、ユーザーがファイルをダウンロードする機能は一般的な要件である。FileResponseは、PDFレポート、Excel帳票、画像ファイル、CSVエクスポートなど、様々なファイル形式をクライアントに効率的に配信するための標準的な手段を提供する。非同期I/Oを活用することで、大量の同時リクエストにも対応できる。

**帳票の利用シーン**：PDFレポートのダウンロード、Excelファイルのエクスポート、画像ファイルの配信、CSVデータのダウンロード、ドキュメントファイルの提供時に利用される。

**主要な出力内容**：
1. ファイルのバイナリコンテンツ
2. 適切なContent-Typeヘッダー
3. Content-Dispositionヘッダー（ファイル名指定時）
4. Content-Lengthヘッダー
5. ETag/Last-Modifiedヘッダー（条件付きリクエスト対応）

**帳票の出力タイミング**：エンドポイント関数がFileResponseを返却した際に、指定されたファイルがレスポンスとして送信される。

**帳票の利用者**：APIエンドポイントを呼び出すクライアントアプリケーション、Webブラウザ

## 帳票種別

ファイルダウンロードレスポンス

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 1 | 任意のエンドポイント | 開発者が定義 | FileResponseを返却するエンドポイントへのHTTPリクエスト |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | 任意（ファイルに依存） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | パラメータで指定可能 |
| 出力方法 | HTTPレスポンス（ストリーミング） |
| 文字コード | ファイルに依存 |

### HTTP固有設定

| 項目 | 内容 |
|-----|------|
| Content-Type | ファイル拡張子から自動検出、または明示的に指定 |
| Content-Disposition | attachment（ダウンロード）またはinline（表示） |
| Content-Length | ファイルサイズ |
| ETag | ファイルのハッシュ値（条件付きリクエスト用） |
| Last-Modified | ファイルの最終更新日時 |

## 帳票レイアウト

### レイアウト概要

FileResponseは、ファイルのバイナリデータをそのままHTTPレスポンスボディとして送信する。

```
HTTPレスポンス
├── ステータスライン: HTTP/1.1 200 OK
├── ヘッダー
│   ├── Content-Type: application/pdf
│   ├── Content-Disposition: attachment; filename="report.pdf"
│   ├── Content-Length: 12345
│   ├── ETag: "abc123..."
│   └── Last-Modified: Wed, 21 Oct 2015 07:28:00 GMT
└── ボディ
    └── [ファイルのバイナリデータ]
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Content-Type | メディアタイプ | media_typeパラメータまたは自動検出 | MIME形式 |
| 2 | Content-Disposition | ダウンロード動作 | filenameパラメータ | attachment/inline |
| 3 | Content-Length | ファイルサイズ | ファイルのstat情報 | バイト数 |
| 4 | ETag | エンティティタグ | ファイルのハッシュ | 文字列 |
| 5 | Last-Modified | 最終更新日時 | ファイルのmtime | RFC 7231形式 |

### ボディ部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | ファイルデータ | ファイルの内容 | 指定されたファイルパス | バイナリ |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| path | ファイルパスが指定されていること | Yes |
| ファイル存在 | 指定されたパスにファイルが存在すること | Yes |
| 読み取り権限 | ファイルに読み取り権限があること | Yes |

### ソート順

N/A（単一ファイル）

### 改ページ条件

N/A（バイナリデータ）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | データベースへの直接参照なし | - |

### ファイルシステム参照

FileResponseはファイルシステム上のファイルを参照する。

| 参照元 | 取得情報 |
|--------|---------|
| ファイルパス | ファイルのバイナリデータ |
| ファイルstat | サイズ、更新日時 |
| ファイル拡張子 | MIMEタイプ（自動検出時） |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Content-Type | mimetypes.guess_type(path) | N/A | 拡張子から推測 |
| ETag | ファイル内容のハッシュ | N/A | MD5またはSHA |
| Content-Length | os.stat(path).st_size | N/A | バイト単位 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[エンドポイント呼び出し] --> B[FileResponse生成]
    B --> C{pathパラメータ}
    C -->|指定あり| D[ファイル存在確認]
    D --> E{ファイル存在?}
    E -->|Yes| F[ファイルstat取得]
    E -->|No| G[404エラー]
    F --> H{media_type指定?}
    H -->|Yes| I[指定のContent-Type使用]
    H -->|No| J[拡張子から自動検出]
    I --> K[ヘッダー構築]
    J --> K
    K --> L{filename指定?}
    L -->|Yes| M[Content-Disposition追加]
    L -->|No| N[ヘッダー完了]
    M --> N
    N --> O[ファイルストリーミング]
    O --> P[レスポンス完了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| FileNotFoundError | ファイルが存在しない | 404 Not Found | ファイルパスを確認 |
| PermissionError | 読み取り権限がない | 403 Forbidden | ファイル権限を確認 |
| IsADirectoryError | ディレクトリを指定 | 400 Bad Request | ファイルパスを指定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1リクエストにつき1ファイル |
| 目標出力時間 | ファイルサイズとネットワーク帯域に依存 |
| 同時出力数上限 | サーバーリソースとファイルディスクリプタ上限に依存 |

## セキュリティ考慮事項

- パストラバーサル攻撃対策：ユーザー入力をファイルパスに直接使用しない
- アクセス制御：認証・認可を適切に実装
- 機密ファイルの保護：公開すべきでないファイルへのアクセス制限
- ファイルタイプ検証：アップロードされたファイルの種類を確認

## 備考

- FileResponseはStarletteからの再エクスポートであり、FastAPI独自の実装はない
- 非同期I/Oを使用してファイルを読み込むため、大量の同時リクエストに対応可能
- 条件付きリクエスト（If-None-Match, If-Modified-Since）に対応
- Rangeリクエスト（部分取得）にも対応

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: FastAPIでのインポートを理解する

FileResponseがどのようにFastAPIで提供されているかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | responses.py | `fastapi/responses.py` | FileResponseの再エクスポート（行3）を確認 |

**読解のコツ**: FastAPIはStarletteのFileResponseをそのまま再エクスポートしている。`from starlette.responses import FileResponse as FileResponse`というパターンは、名前空間を維持しつつ再エクスポートする一般的な手法。

#### Step 2: Starletteの実装を理解する（参考）

実際の実装はStarletteにあるため、詳細な動作を理解するにはStarletteのソースを参照する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | responses.py | `starlette/responses.py` | FileResponseクラスの実装（Starlette側） |

**主要処理フロー（Starlette）**:
1. コンストラクタでpath, filename, media_type等を受け取る
2. set_stat_headers()でContent-Length, Last-Modified, ETag設定
3. filename指定時にContent-Dispositionヘッダー追加
4. __call__()でASGI応答として非同期にファイル送信

### プログラム呼び出し階層図

```
エンドポイント関数
    │
    └─ return FileResponse(path="...")
           │
           └─ Starlette FileResponse.__init__()
                  │
                  ├─ stat()でファイル情報取得
                  ├─ set_stat_headers()
                  │      ├─ Content-Length設定
                  │      ├─ Last-Modified設定
                  │      └─ ETag設定
                  │
                  └─ Content-Disposition設定（filename指定時）

ASGIサーバー
    │
    └─ FileResponse.__call__()
           │
           └─ 非同期ファイル読み込み＆送信
```

### データフロー図

```
[入力]                    [処理]                         [出力]

HTTPリクエスト ──────▶ エンドポイント関数 ──────────────▶ HTTPレスポンス
                            │                              │
                            ▼                              │
                    FileResponse生成                       │
                            │                              │
                            ├─ ファイルパス指定             │
                            ├─ stat()でメタ情報取得        │
                            ├─ ヘッダー構築                │
                            │                              │
                            ▼                              ▼
                    ファイル読み込み ─────────────▶ バイナリレスポンス
                    (非同期ストリーミング)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| responses.py | `fastapi/responses.py` | ソース | FileResponseの再エクスポート |
| responses.py | `starlette/responses.py` | 外部依存 | FileResponseの実装（Starlette） |
