# 帳票設計書 6-StreamingResponse

## 概要

本ドキュメントは、FastAPIフレームワークにおけるStreamingResponse帳票の設計仕様を定義する。StreamingResponseは、大容量データをストリーミング形式でクライアントに配信するためのレスポンスクラスである。

### 本帳票の処理概要

StreamingResponseは、データをチャンク単位で逐次的にクライアントに送信する帳票である。メモリに全データを保持せずに大容量ファイルや動的生成コンテンツを配信でき、リアルタイムデータストリーミングにも対応する。FastAPIはStarletteのStreamingResponseをそのまま再エクスポートしており、FastAPI独自の実装は持たない。

**業務上の目的・背景**：大容量ファイル（動画、大規模CSVエクスポート等）を配信する場合、ファイル全体をメモリに読み込むとサーバーリソースを圧迫する。StreamingResponseは、データを小さなチャンクに分割して送信することで、メモリ効率を大幅に改善する。また、Server-Sent Events（SSE）やリアルタイムログ配信など、継続的なデータストリーミングにも使用される。

**帳票の利用シーン**：大容量ファイルのダウンロード、動画/音声ストリーミング、リアルタイムログ配信、Server-Sent Events、大規模データエクスポート、プログレスレポート時に利用される。

**主要な出力内容**：
1. ストリーミングデータ（チャンク単位）
2. 適切なContent-Typeヘッダー
3. Transfer-Encoding: chunked（チャンク転送）
4. カスタムヘッダー（必要に応じて）

**帳票の出力タイミング**：エンドポイント関数がStreamingResponseを返却した際に、ジェネレータまたはイテレータから逐次的にデータが送信される。

**帳票の利用者**：APIエンドポイントを呼び出すクライアントアプリケーション、Webブラウザ、ストリーミングクライアント

## 帳票種別

ストリーミングレスポンス

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 1 | 任意のエンドポイント | 開発者が定義 | StreamingResponseを返却するエンドポイントへのHTTPリクエスト |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | 任意（content/iteratorに依存） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | headersで指定可能 |
| 出力方法 | HTTPレスポンス（チャンクストリーミング） |
| 文字コード | content依存 |

### HTTP固有設定

| 項目 | 内容 |
|-----|------|
| Content-Type | media_typeパラメータで指定 |
| Transfer-Encoding | chunked（自動） |
| Content-Length | 通常は設定しない（ストリーミングのため不明） |

## 帳票レイアウト

### レイアウト概要

StreamingResponseは、データをチャンク単位で送信するため、従来のレスポンスとは異なる構造を持つ。

```
HTTPレスポンス（チャンク転送）
├── ステータスライン: HTTP/1.1 200 OK
├── ヘッダー
│   ├── Content-Type: application/octet-stream
│   └── Transfer-Encoding: chunked
└── ボディ（チャンク形式）
    ├── [チャンク1サイズ]\r\n[チャンク1データ]\r\n
    ├── [チャンク2サイズ]\r\n[チャンク2データ]\r\n
    ├── ...
    └── 0\r\n\r\n（終端）
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Content-Type | メディアタイプ | media_typeパラメータ | MIME形式 |
| 2 | Transfer-Encoding | 転送エンコーディング | 自動設定 | "chunked" |
| 3 | カスタムヘッダー | 追加ヘッダー | headersパラメータ | 任意 |

### ボディ部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | チャンクデータ | 分割されたデータ | content（iterator/generator） | チャンク形式 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| content | イテレータまたはジェネレータが指定されていること | Yes |
| media_type | Content-Typeが指定されていること | No（デフォルトあり） |

### ソート順

N/A（ストリーミング順序はcontentに依存）

### 改ページ条件

N/A（ストリーミングデータ）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | データベースへの直接参照なし（contentで外部から渡される） | - |

### データソース

StreamingResponseはcontentパラメータで渡されるイテレータ/ジェネレータからデータを取得する。

| データソース種別 | 説明 |
|-----------------|------|
| ファイルイテレータ | ファイルをチャンク単位で読み込むイテレータ |
| ジェネレータ関数 | 動的にデータを生成するジェネレータ |
| 非同期ジェネレータ | async defで定義された非同期ジェネレータ |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| チャンクサイズ | contentのイテレーション単位 | N/A | 開発者が制御 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[エンドポイント呼び出し] --> B[StreamingResponse生成]
    B --> C[ヘッダー構築]
    C --> D[ASGIレスポンス開始]
    D --> E[contentイテレート開始]
    E --> F{次のチャンクあり?}
    F -->|Yes| G[チャンク送信]
    G --> F
    F -->|No| H[ストリーム終了]
    H --> I[レスポンス完了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ジェネレータエラー | content内で例外発生 | 接続切断 | ジェネレータ内でエラーハンドリング |
| 接続切断 | クライアントが切断 | N/A | 適切なクリーンアップ処理 |
| タイムアウト | 送信が遅すぎる | 接続切断 | チャンクサイズ調整 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 制限なし（ストリーミング） |
| 目標出力時間 | 最初のチャンク送信まで100ms以下 |
| 同時出力数上限 | サーバーリソースと接続数に依存 |

## セキュリティ考慮事項

- ストリーミング中のエラー情報漏洩に注意
- 長時間接続のタイムアウト設定
- DoS攻撃対策：同時接続数の制限
- 認証トークンの有効期限管理

## 備考

- StreamingResponseはStarletteからの再エクスポートであり、FastAPI独自の実装はない
- 非同期ジェネレータ（async def）と同期ジェネレータの両方に対応
- Server-Sent Events（SSE）の実装に使用可能
- background引数でバックグラウンドタスクを設定可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: FastAPIでのインポートを理解する

StreamingResponseがどのようにFastAPIで提供されているかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | responses.py | `fastapi/responses.py` | StreamingResponseの再エクスポート（行9）を確認 |

**読解のコツ**: FastAPIはStarletteのStreamingResponseをそのまま再エクスポートしている。実装詳細はStarlette側にある。

#### Step 2: 使用例を理解する

StreamingResponseの典型的な使用パターンを把握する。

```python
# 同期ジェネレータの例
def generate():
    for i in range(10):
        yield f"data: {i}\n"

return StreamingResponse(generate(), media_type="text/event-stream")

# 非同期ジェネレータの例
async def async_generate():
    for i in range(10):
        await asyncio.sleep(1)
        yield f"data: {i}\n"

return StreamingResponse(async_generate(), media_type="text/event-stream")
```

### プログラム呼び出し階層図

```
エンドポイント関数
    │
    └─ return StreamingResponse(content=generator, ...)
           │
           └─ Starlette StreamingResponse.__init__()
                  │
                  └─ Response.__init__()（ヘッダー設定）

ASGIサーバー
    │
    └─ StreamingResponse.__call__()
           │
           ├─ send({"type": "http.response.start", ...})
           │
           └─ body_iterator
                  │
                  ├─ iterate_in_threadpool() [同期イテレータ]
                  │      └─ 各チャンクをsend()
                  │
                  └─ 非同期イテレート [非同期イテレータ]
                         └─ 各チャンクをsend()
```

### データフロー図

```
[入力]                        [処理]                         [出力]

HTTPリクエスト ──────────▶ エンドポイント関数 ─────────────▶ HTTPレスポンス
                                │                              │
                                ▼                              │
                        StreamingResponse生成                  │
                                │                              │
                                ├─ ヘッダー構築                │
                                │                              │
                                ▼                              ▼
ジェネレータ ─────────▶ チャンク単位イテレート ─────────▶ チャンク送信
  │                            │                              │
  ├─ yield chunk1             ├─ send(chunk1)                │
  ├─ yield chunk2             ├─ send(chunk2)                │
  └─ ...                      └─ ...                         │
                                                              ▼
                                                       ストリーム完了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| responses.py | `fastapi/responses.py` | ソース | StreamingResponseの再エクスポート |
| responses.py | `starlette/responses.py` | 外部依存 | StreamingResponseの実装（Starlette） |
