# 帳票設計書 8-UJSONResponse

## 概要

本ドキュメントは、FastAPIフレームワークにおけるUJSONResponse帳票の設計仕様を定義する。UJSONResponseは、ujsonライブラリを使用して高速にJSONレスポンスを生成するためのレスポンスクラスである。

### 本帳票の処理概要

UJSONResponseは、Pythonオブジェクトを高速にJSON形式にシリアライズしてHTTPレスポンスとして返却する帳票である。標準のJSONResponseよりも高速なujsonライブラリを使用することで、大量のJSONデータを扱うAPIのパフォーマンスを向上させる。FastAPIはUJSONResponseを独自に実装している。

**業務上の目的・背景**：高トラフィックAPIにおいて、JSONシリアライゼーションはボトルネックになりうる。ujsonは標準ライブラリのjsonよりも数倍高速であり、レスポンス生成時間を短縮できる。特に大量のレコードを返すAPI、リアルタイム性が求められるAPI、高頻度で呼び出されるAPIにおいて効果を発揮する。

**帳票の利用シーン**：高トラフィックAPIエンドポイント、大量データを返すAPI、レスポンス速度が重要なリアルタイムAPI、マイクロサービス間通信時に利用される。

**主要な出力内容**：
1. PythonオブジェクトをujsonでシリアライズしたJSON
2. 適切なContent-Typeヘッダー（application/json）
3. UTF-8エンコードされたバイナリデータ

**帳票の出力タイミング**：エンドポイント関数がUJSONResponseを返却した際、またはresponse_classとして指定された場合に使用される。

**帳票の利用者**：APIクライアント、フロントエンドアプリケーション、他のマイクロサービス

## 帳票種別

高速JSONレスポンス

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 1 | 任意のエンドポイント | 開発者が定義 | UJSONResponseを返却するエンドポイントへのHTTPリクエスト |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（動的生成） |
| 出力方法 | HTTPレスポンス |
| 文字コード | UTF-8 |

### JSON固有設定

| 項目 | 内容 |
|-----|------|
| Content-Type | application/json |
| シリアライザ | ujson |
| ensure_ascii | False（非ASCIIも直接出力） |

## 帳票レイアウト

### レイアウト概要

UJSONResponseは、PythonオブジェクトをJSON形式でシリアライズして出力する。

```
HTTPレスポンス
├── ステータスライン: HTTP/1.1 200 OK
├── ヘッダー
│   ├── Content-Type: application/json
│   └── Content-Length: xxx
└── ボディ
    └── {"key": "value", ...}
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Content-Type | メディアタイプ | JSONResponseから継承 | application/json |
| 2 | Content-Length | ボディサイズ | シリアライズ後のバイト数 | 数値 |

### ボディ部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | JSONデータ | シリアライズされたJSON | contentパラメータ | JSON文字列 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ujsonインストール | ujsonライブラリがインストールされていること | Yes |
| contentパラメータ | シリアライズ対象のデータが指定されていること | Yes |

### ソート順

N/A（JSONオブジェクトの構造に依存）

### 改ページ条件

N/A（JSON形式）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | データベースへの直接参照なし（contentで外部から渡される） | - |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| JSONバイト列 | ujson.dumps(content, ensure_ascii=False).encode("utf-8") | N/A | シリアライズ |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[エンドポイント呼び出し] --> B[UJSONResponse生成]
    B --> C{ujsonインストール?}
    C -->|Yes| D[ujson.dumps呼び出し]
    C -->|No| E[AssertionError]
    D --> F[ensure_ascii=False設定]
    F --> G[UTF-8エンコード]
    G --> H[HTTPレスポンス返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| AssertionError | ujsonがインストールされていない | "ujson must be installed to use UJSONResponse" | ujsonをインストール |
| シリアライズエラー | JSONにできないオブジェクト | ujsonのエラーメッセージ | シリアライズ可能なオブジェクトに変換 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 制限なし |
| 目標出力時間 | 標準JSONResponseの2-5倍高速 |
| 同時出力数上限 | サーバーリソースに依存 |

## セキュリティ考慮事項

- ユーザー入力データのサニタイズは呼び出し側の責任
- 機密情報の漏洩防止
- JSONインジェクション対策

## 備考

- UJSONResponseはFastAPI独自の実装
- ujsonライブラリは別途インストールが必要（`pip install ujson`）
- ensure_ascii=Falseにより日本語等の非ASCII文字も直接出力
- 一部の浮動小数点の精度が標準jsonと異なる場合がある
- datetimeオブジェクト等のシリアライズには別途対応が必要

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: UJSONResponseクラスを理解する

UJSONResponseクラスの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | responses.py | `fastapi/responses.py` | UJSONResponseクラス（行23-33）を確認 |

**読解のコツ**: UJSONResponseはJSONResponseを継承し、render()メソッドのみをオーバーライドしている。JSONResponseはStarletteから継承されている。

#### Step 2: ujsonインポートを理解する

ujsonの条件付きインポートを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | responses.py | `fastapi/responses.py` | ujsonのインポート（行11-14）を確認 |

**主要処理フロー**:
1. **行11-14**: try-exceptでujsonをインポート。インストールされていない場合はNoneを設定
2. **行32**: render()内でujsonがNoneでないことをassert
3. **行33**: ujson.dumps()でシリアライズし、UTF-8でエンコード

### プログラム呼び出し階層図

```
エンドポイント関数
    │
    └─ return UJSONResponse(content={...})
           │
           └─ UJSONResponse.__init__() [JSONResponse継承]
                  │
                  └─ Response.__init__()

ASGIサーバー
    │
    └─ UJSONResponse.render(content)
           │
           ├─ assert ujson is not None
           │
           └─ ujson.dumps(content, ensure_ascii=False).encode("utf-8")
                  │
                  └─ bytes
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Pythonオブジェクト ────▶ UJSONResponse ─────────────────▶ HTTPレスポンス
  └ dict/list等             │                              │
                            ▼                              │
                    render(content)                        │
                            │                              │
                            ├─ ujson.dumps()               │
                            ├─   ensure_ascii=False        │
                            ├─ .encode("utf-8")            │
                            │                              │
                            ▼                              ▼
                    bytes ────────────────────────▶ JSON HTTPレスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| responses.py | `fastapi/responses.py` | ソース | UJSONResponseクラスの実装 |
| responses.py | `starlette/responses.py` | 外部依存 | JSONResponse基底クラス（Starlette） |
