# 帳票設計書 9-ORJSONResponse

## 概要

本ドキュメントは、FastAPIフレームワークにおけるORJSONResponse帳票の設計仕様を定義する。ORJSONResponseは、orjsonライブラリを使用して高速にJSONレスポンスを生成するためのレスポンスクラスである。

### 本帳票の処理概要

ORJSONResponseは、Pythonオブジェクトを非常に高速にJSON形式にシリアライズしてHTTPレスポンスとして返却する帳票である。orjsonはRustで実装された高性能JSONライブラリであり、標準ライブラリやujsonよりも高速なシリアライズを実現する。FastAPIはORJSONResponseを独自に実装している。

**業務上の目的・背景**：超高トラフィックAPIやレイテンシが重要なシステムにおいて、JSONシリアライゼーションの最適化は重要な課題である。orjsonはPython向けJSONライブラリの中で最速クラスであり、特に大規模なJSONデータや複雑なネスト構造を持つデータの処理において優れたパフォーマンスを発揮する。また、datetime、UUID、numpyなどのPythonオブジェクトのネイティブシリアライズにも対応している。

**帳票の利用シーン**：超高トラフィックAPIエンドポイント、低レイテンシが必須のリアルタイムシステム、大量のネストされたJSONを返すAPI、NumPy配列を含むデータサイエンス系API時に利用される。

**主要な出力内容**：
1. PythonオブジェクトをorjsonでシリアライズしたJSON
2. 適切なContent-Typeヘッダー（application/json）
3. UTF-8エンコードされたバイナリデータ

**帳票の出力タイミング**：エンドポイント関数がORJSONResponseを返却した際、またはresponse_classとして指定された場合に使用される。

**帳票の利用者**：APIクライアント、フロントエンドアプリケーション、他のマイクロサービス、データ分析システム

## 帳票種別

超高速JSONレスポンス

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 1 | 任意のエンドポイント | 開発者が定義 | ORJSONResponseを返却するエンドポイントへのHTTPリクエスト |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（動的生成） |
| 出力方法 | HTTPレスポンス |
| 文字コード | UTF-8 |

### JSON固有設定

| 項目 | 内容 |
|-----|------|
| Content-Type | application/json |
| シリアライザ | orjson |
| オプション | OPT_NON_STR_KEYS, OPT_SERIALIZE_NUMPY |

## 帳票レイアウト

### レイアウト概要

ORJSONResponseは、PythonオブジェクトをJSON形式でシリアライズして出力する。

```
HTTPレスポンス
├── ステータスライン: HTTP/1.1 200 OK
├── ヘッダー
│   ├── Content-Type: application/json
│   └── Content-Length: xxx
└── ボディ
    └── {"key": "value", ...}
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Content-Type | メディアタイプ | JSONResponseから継承 | application/json |
| 2 | Content-Length | ボディサイズ | シリアライズ後のバイト数 | 数値 |

### ボディ部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | JSONデータ | シリアライズされたJSON | contentパラメータ | JSON文字列 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| orjsonインストール | orjsonライブラリがインストールされていること | Yes |
| contentパラメータ | シリアライズ対象のデータが指定されていること | Yes |

### ソート順

N/A（JSONオブジェクトの構造に依存）

### 改ページ条件

N/A（JSON形式）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | データベースへの直接参照なし（contentで外部から渡される） | - |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| JSONバイト列 | orjson.dumps(content, option=OPT_NON_STR_KEYS \| OPT_SERIALIZE_NUMPY) | N/A | シリアライズ |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[エンドポイント呼び出し] --> B[ORJSONResponse生成]
    B --> C{orjsonインストール?}
    C -->|Yes| D[orjson.dumps呼び出し]
    C -->|No| E[AssertionError]
    D --> F[OPT_NON_STR_KEYSオプション設定]
    F --> G[OPT_SERIALIZE_NUMPYオプション設定]
    G --> H[HTTPレスポンス返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| AssertionError | orjsonがインストールされていない | "orjson must be installed to use ORJSONResponse" | orjsonをインストール |
| シリアライズエラー | JSONにできないオブジェクト | orjsonのエラーメッセージ | シリアライズ可能なオブジェクトに変換 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 制限なし |
| 目標出力時間 | 標準JSONResponseの5-10倍高速 |
| 同時出力数上限 | サーバーリソースに依存 |

## セキュリティ考慮事項

- ユーザー入力データのサニタイズは呼び出し側の責任
- 機密情報の漏洩防止
- JSONインジェクション対策

## 備考

- ORJSONResponseはFastAPI独自の実装
- orjsonライブラリは別途インストールが必要（`pip install orjson`）
- OPT_NON_STR_KEYSにより辞書の非文字列キーも処理可能
- OPT_SERIALIZE_NUMPYによりNumPy配列を直接シリアライズ可能
- datetime、date、time、UUIDオブジェクトをネイティブでサポート
- orjsonはbytesを直接返すため、エンコード処理が不要

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: ORJSONResponseクラスを理解する

ORJSONResponseクラスの実装を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | responses.py | `fastapi/responses.py` | ORJSONResponseクラス（行36-48）を確認 |

**読解のコツ**: ORJSONResponseはJSONResponseを継承し、render()メソッドのみをオーバーライドしている。UJSONResponseと同様の構造だが、orjsonはbytesを直接返すため.encode()が不要。

#### Step 2: orjsonインポートを理解する

orjsonの条件付きインポートを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | responses.py | `fastapi/responses.py` | orjsonのインポート（行17-20）を確認 |

**主要処理フロー**:
1. **行17-20**: try-exceptでorjsonをインポート。インストールされていない場合はNoneを設定
2. **行45**: render()内でorjsonがNoneでないことをassert
3. **行46-48**: orjson.dumps()でシリアライズ。オプションフラグを指定

#### Step 3: オプションフラグを理解する

orjsonのオプションフラグの意味を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | responses.py | `fastapi/responses.py` | オプションフラグ（行47）を確認 |

**オプションフラグの説明**:
- **OPT_NON_STR_KEYS**: 辞書のキーが文字列以外（int等）でもシリアライズ可能
- **OPT_SERIALIZE_NUMPY**: NumPy配列、numpy.float64等をネイティブにシリアライズ

### プログラム呼び出し階層図

```
エンドポイント関数
    │
    └─ return ORJSONResponse(content={...})
           │
           └─ ORJSONResponse.__init__() [JSONResponse継承]
                  │
                  └─ Response.__init__()

ASGIサーバー
    │
    └─ ORJSONResponse.render(content)
           │
           ├─ assert orjson is not None
           │
           └─ orjson.dumps(content, option=...)
                  │
                  └─ bytes（直接返却、encode不要）
```

### データフロー図

```
[入力]                    [処理]                         [出力]

Pythonオブジェクト ────▶ ORJSONResponse ────────────────▶ HTTPレスポンス
  └ dict/list/numpy等       │                              │
                            ▼                              │
                    render(content)                        │
                            │                              │
                            ├─ orjson.dumps()              │
                            ├─   OPT_NON_STR_KEYS          │
                            ├─   OPT_SERIALIZE_NUMPY       │
                            │                              │
                            ▼                              ▼
                    bytes ────────────────────────▶ JSON HTTPレスポンス
                    (直接返却)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| responses.py | `fastapi/responses.py` | ソース | ORJSONResponseクラスの実装 |
| responses.py | `starlette/responses.py` | 外部依存 | JSONResponse基底クラス（Starlette） |
