---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-Swagger_UI_HTML.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **目標出力時間100ms以下**：パフォーマンス要件の具体値に根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/openapi/docs.py` 行8-23（swagger_ui_default_parameters）
- E-02: `fastapi/openapi/docs.py` 行26-158（get_swagger_ui_html関数）
- E-03: `fastapi/openapi/docs.py` 行56-66（CDN URL デフォルト値）
- E-04: `fastapi/applications.py` 行1079-1130（setup メソッド）
- E-05: `fastapi/applications.py` 行1093-1109（swagger_ui_html 登録）
- E-06: `fastapi/applications.py` 行865-866（docs_url デフォルト "/docs"）
- E-07: `fastapi/applications.py` 行906-908（title, version アサーション）
- E-08: `fastapi/openapi/docs.py` 行113-115（パラメータマージ処理）
- E-09: `fastapi/openapi/docs.py` 行117-158（HTML生成処理）
- E-10: `fastapi/openapi/docs.py` 行256-344（OAuth2リダイレクトHTML）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Swagger UIは/docsエンドポイントで提供される | E-06 | ○ |
| C-02 | get_swagger_ui_html関数でHTML生成 | E-02 | ○ |
| C-03 | デフォルトでCDN（jsDelivr）からJS/CSS読み込み | E-03 | ○ |
| C-04 | swagger_ui_default_parametersにdom_id等が含まれる | E-01 | ○ |
| C-05 | setup()メソッドでルート登録 | E-04, E-05 | ○ |
| C-06 | root_pathとopenapi_urlを結合 | E-05 | ○ |
| C-07 | oauth2_redirect_urlの設定処理 | E-02, E-05 | ○ |
| C-08 | swagger_ui_parametersのマージ処理 | E-08 | ○ |
| C-09 | HTML文字列を動的生成 | E-09 | ○ |
| C-10 | HTMLResponseを返却 | E-02 | ○ |
| C-11 | titleとversionが必須 | E-07 | ○ |
| C-12 | docs_urlがNoneで無効化可能 | E-04 | ○ |
| C-13 | swagger_js_url/swagger_css_urlカスタマイズ可能 | E-03 | ○ |
| C-14 | init_oauthパラメータでOAuth2設定 | E-02 | ○ |
| C-15 | OAuth2リダイレクトHTMLの生成 | E-10 | ○ |
| C-16 | ファイル形式はHTML | E-02 | ○ |
| C-17 | 文字コードはUTF-8 | E-02, E-09 | ○ |
| C-18 | swagger_favicon_urlでファビコン設定 | E-02 | ○ |
| C-19 | applications.pyでswagger_ui_htmlルート登録 | E-05 | ○ |
| C-20 | 行1111-1120でOAuth2リダイレクトルート登録 | E-04 | ○ |
| C-21 | SwaggerUIBundleプリセット設定 | E-09 | ○ |
| C-22 | jsonable_encoderでパラメータをJSON化 | E-02 | ○ |
| C-23 | swagger_ui_parametersでカスタマイズ可能 | E-01, E-08 | ○ |
| C-24 | openapi_urlのデフォルトは/openapi.json | E-06 | ○ |
| C-25 | 目標出力時間100ms以下 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- パフォーマンス要件（目標出力時間100ms）はソースコードに明示的な根拠がない
  - 候補：ベンチマークテスト結果 / 設計ドキュメント / 非機能要件定義書

## 5) リスクフラグ（レビュー観点）

- 0: 機能仕様に関する主張は全て根拠あり（低リスク）
- 1: パフォーマンス要件は推定値のため要確認（中リスク）

## 6) レビュアーチェックリスト（最小）

- [ ] パフォーマンス要件（100ms以下）が妥当か確認
- [ ] OAuth2関連のセキュリティ設定記述が十分か確認
- [ ] 本番環境での無効化推奨事項が適切か確認
