---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：2-ReDoc_HTML.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **目標出力時間50ms以下**：パフォーマンス要件の具体値に根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/openapi/docs.py` 行161-207（get_redoc_html関数パラメータ）
- E-02: `fastapi/openapi/docs.py` 行161-253（get_redoc_html関数全体）
- E-03: `fastapi/openapi/docs.py` 行191（CDN URL デフォルト値）
- E-04: `fastapi/openapi/docs.py` 行199（redoc_favicon_url デフォルト値）
- E-05: `fastapi/openapi/docs.py` 行200-207（with_google_fonts パラメータ）
- E-06: `fastapi/applications.py` 行1121-1130（redoc_html 登録）
- E-07: `fastapi/applications.py` 行867（redoc_url デフォルト "/redoc"）
- E-08: `fastapi/openapi/docs.py` 行219-227（HTML head 生成）
- E-09: `fastapi/openapi/docs.py` 行228-231（Google Fonts 条件分岐）
- E-10: `fastapi/openapi/docs.py` 行244-248（noscript と redoc 要素）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ReDocは/redocエンドポイントで提供される | E-07 | ○ |
| C-02 | get_redoc_html関数でHTML生成 | E-02 | ○ |
| C-03 | デフォルトでCDN（jsDelivr）からJS読み込み | E-03 | ○ |
| C-04 | with_google_fontsパラメータでフォント制御 | E-05, E-09 | ○ |
| C-05 | setup()メソッドでルート登録 | E-06 | ○ |
| C-06 | root_pathとopenapi_urlを結合 | E-06 | ○ |
| C-07 | redoc_favicon_urlでファビコン設定 | E-04 | ○ |
| C-08 | HTML文字列を動的生成 | E-08 | ○ |
| C-09 | HTMLResponseを返却 | E-02 | ○ |
| C-10 | redoc_urlがNoneで無効化可能 | E-06 | ○ |
| C-11 | redoc_js_urlカスタマイズ可能 | E-03 | ○ |
| C-12 | ファイル形式はHTML | E-02 | ○ |
| C-13 | 文字コードはUTF-8 | E-08 | ○ |
| C-14 | viewportメタタグでレスポンシブ対応 | E-08 | ○ |
| C-15 | noscript要素でJS無効時メッセージ | E-10 | ○ |
| C-16 | redocカスタム要素でspec-url指定 | E-10 | ○ |
| C-17 | タイトルは"FastAPI.title - ReDoc"形式 | E-06 | ○ |
| C-18 | Google Fontsデフォルト有効 | E-05 | ○ |
| C-19 | bodyのmargin/paddingを0に設定 | E-02 | ○ |
| C-20 | 行1121-1130でReDocルート登録 | E-06 | ○ |
| C-21 | openapi_urlとredoc_url両方必要 | E-06 | ○ |
| C-22 | 目標出力時間50ms以下 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- パフォーマンス要件（目標出力時間50ms）はソースコードに明示的な根拠がない
  - 候補：ベンチマークテスト結果 / 設計ドキュメント / 非機能要件定義書

## 5) リスクフラグ（レビュー観点）

- 0: 機能仕様に関する主張は全て根拠あり（低リスク）
- 1: パフォーマンス要件は推定値のため要確認（中リスク）

## 6) レビュアーチェックリスト（最小）

- [ ] パフォーマンス要件（50ms以下）が妥当か確認
- [ ] Google Fonts利用時のプライバシー考慮事項が十分か確認
- [ ] 本番環境での無効化推奨事項が適切か確認
