---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-OAuth2リダイレクトHTML.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/openapi/docs.py` 行256-344（get_swagger_ui_oauth2_redirect_html関数）
- E-02: `fastapi/openapi/docs.py` 行262（Swagger UI v4.14.0のコメント）
- E-03: `fastapi/openapi/docs.py` 行267（タイトル "Swagger UI: OAuth2 Redirect"）
- E-04: `fastapi/openapi/docs.py` 行272-275（oauth2オブジェクト取得）
- E-05: `fastapi/openapi/docs.py` 行278-282（hash/searchからパラメータ抽出）
- E-06: `fastapi/openapi/docs.py` 行284-290（JSON変換処理）
- E-07: `fastapi/openapi/docs.py` 行292（state検証）
- E-08: `fastapi/openapi/docs.py` 行294-298（フロー種別判定）
- E-09: `fastapi/openapi/docs.py` 行299-306（state不一致警告）
- E-10: `fastapi/openapi/docs.py` 行308-311（コード取得成功）
- E-11: `fastapi/openapi/docs.py` 行312-325（エラー処理）
- E-12: `fastapi/openapi/docs.py` 行327-329（トークンフロー処理）
- E-13: `fastapi/openapi/docs.py` 行330（window.close）
- E-14: `fastapi/openapi/docs.py` 行332-338（DOMContentLoaded判定）
- E-15: `fastapi/applications.py` 行1111-1120（OAuth2リダイレクトルート登録）
- E-16: `fastapi/applications.py` 行867（swagger_ui_oauth2_redirect_urlデフォルト値）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | get_swagger_ui_oauth2_redirect_html関数でHTML生成 | E-01 | ○ |
| C-02 | Swagger UI v4.14.0ベース | E-02 | ○ |
| C-03 | タイトルは"Swagger UI: OAuth2 Redirect" | E-03 | ○ |
| C-04 | oauth2オブジェクトを親ウィンドウから取得 | E-04 | ○ |
| C-05 | hashまたはsearchからパラメータ抽出 | E-05 | ○ |
| C-06 | パラメータをJSON形式に変換 | E-06 | ○ |
| C-07 | state検証でCSRF対策 | E-07 | ○ |
| C-08 | authorization_code/accessCodeフロー対応 | E-08 | ○ |
| C-09 | state不一致時に警告 | E-09 | ○ |
| C-10 | コード取得成功時にcallback実行 | E-10 | ○ |
| C-11 | エラー時にerrCb実行 | E-11 | ○ |
| C-12 | トークンフロー対応 | E-12 | ○ |
| C-13 | 処理完了後にwindow.close | E-13 | ○ |
| C-14 | DOMContentLoaded判定 | E-14 | ○ |
| C-15 | setup()でルート登録 | E-15 | ○ |
| C-16 | デフォルトURL /docs/oauth2-redirect | E-16 | ○ |
| C-17 | 引数なしの関数 | E-01 | ○ |
| C-18 | HTMLResponseを返却 | E-01 | ○ |
| C-19 | 外部JavaScript依存なし | E-01 | ○ |
| C-20 | swagger_ui_oauth2_redirect_url設定必要 | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし：全ての主張に対して根拠が存在する

## 5) リスクフラグ（レビュー観点）

- 0: 全ての主張に根拠あり（低リスク）

## 6) レビュアーチェックリスト（最小）

- [ ] OAuth2セキュリティフローの説明が十分か確認
- [ ] エラーメッセージの説明が適切か確認
- [ ] ブラウザ互換性に関する記述が必要か検討
