---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-OpenAPI_JSON.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/openapi/utils.py` 行476-567（get_openapi関数）
- E-02: `fastapi/openapi/utils.py` 行259-442（get_openapi_path関数）
- E-03: `fastapi/openapi/utils.py` 行41-66（validation_error_definition）
- E-04: `fastapi/openapi/utils.py` 行493-504（info構築）
- E-05: `fastapi/openapi/utils.py` 行556-557（schemasソート）
- E-06: `fastapi/openapi/utils.py` 行567（jsonable_encoder）
- E-07: `fastapi/applications.py` 行1046-1077（openapi()メソッド）
- E-08: `fastapi/applications.py` 行1060-1077（スキーマ生成とキャッシュ）
- E-09: `fastapi/applications.py` 行1080-1092（setup()でルート登録）
- E-10: `fastapi/applications.py` 行227（openapi_urlデフォルト値）
- E-11: `fastapi/applications.py` 行906-908（title/versionアサーション）
- E-12: `fastapi/openapi/utils.py` 行232-256（get_openapi_operation_metadata）
- E-13: `fastapi/openapi/utils.py` 行78-101（get_openapi_security_definitions）
- E-14: `fastapi/openapi/utils.py` 行104-174（_get_openapi_operation_parameters）
- E-15: `fastapi/openapi/utils.py` 行177-209（get_openapi_operation_request_body）
- E-16: `fastapi/applications.py` 行874-904（openapi_version）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | get_openapi関数でスキーマ生成 | E-01 | ○ |
| C-02 | /openapi.jsonがデフォルトエンドポイント | E-10 | ○ |
| C-03 | OpenAPI 3.1.0がデフォルトバージョン | E-16 | ○ |
| C-04 | title, versionが必須 | E-11 | ○ |
| C-05 | openapi_schemaにキャッシュ | E-08 | ○ |
| C-06 | JSONResponseで返却 | E-09 | ○ |
| C-07 | info辞書にtitle, version含む | E-04 | ○ |
| C-08 | componentsのschemasをソート | E-05 | ○ |
| C-09 | jsonable_encoderでJSON化 | E-06 | ○ |
| C-10 | get_openapi_pathで各ルート処理 | E-02 | ○ |
| C-11 | validation_error_definition定義 | E-03 | ○ |
| C-12 | get_openapi_operation_metadataでメタデータ取得 | E-12 | ○ |
| C-13 | get_openapi_security_definitionsでセキュリティ定義抽出 | E-13 | ○ |
| C-14 | _get_openapi_operation_parametersでパラメータ処理 | E-14 | ○ |
| C-15 | get_openapi_operation_request_bodyでボディ処理 | E-15 | ○ |
| C-16 | openapi()メソッドでスキーマ取得 | E-07 | ○ |
| C-17 | setup()でルート登録 | E-09 | ○ |
| C-18 | servers情報を含む | E-01 | ○ |
| C-19 | paths情報を含む | E-01 | ○ |
| C-20 | webhooks情報を含む | E-01 | ○ |
| C-21 | tags情報を含む | E-01 | ○ |
| C-22 | externalDocs情報を含む | E-01 | ○ |
| C-23 | 422バリデーションエラー自動追加 | E-02 | ○ |
| C-24 | operation_id重複チェック | E-12 | ○ |
| C-25 | include_in_schemaで除外可能 | E-02 | ○ |
| C-26 | separate_input_output_schemasオプション | E-01 | ○ |
| C-27 | root_path_in_serversオプション | E-09 | ○ |
| C-28 | OpenAPIモデルで検証 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし：全ての主張に対して根拠が存在する

## 5) リスクフラグ（レビュー観点）

- 0: 全ての主張に根拠あり（低リスク）

## 6) レビュアーチェックリスト（最小）

- [ ] OpenAPI 3.1.0仕様との完全な準拠を確認
- [ ] セキュリティスキーム情報の公開リスクについて確認
- [ ] パフォーマンス要件（キャッシュ戦略）が適切か確認
