---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 19
  claims_with_evidence: 17
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：7-Jinja2テンプレートレスポンス.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：17 / 19、根拠なし：2
- 優先レビュー（高）
  1. **auto_reload設定**：Starlette/Jinja2実装に依存
  2. **テンプレートキャッシュ**：Jinja2実装の詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/templating.py` 行1（Jinja2Templatesの再エクスポート）
- E-02: Jinja2公式ドキュメント（外部参照）
- E-03: Starlette公式ドキュメント（外部参照）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Jinja2TemplatesはStarletteからの再エクスポート | E-01 | ○ |
| C-02 | fastapi/templating.pyで提供 | E-01 | ○ |
| C-03 | FastAPI独自の実装はない | E-01 | ○ |
| C-04 | directoryパラメータでテンプレートディレクトリ指定 | E-03 | ○ |
| C-05 | TemplateResponseでHTMLレスポンス生成 | E-03 | ○ |
| C-06 | requestオブジェクトがコンテキストに必須 | E-03 | ○ |
| C-07 | {{ var }}で変数展開 | E-02 | ○ |
| C-08 | {% if %}で条件分岐 | E-02 | ○ |
| C-09 | {% for %}でループ | E-02 | ○ |
| C-10 | {% extends %}でテンプレート継承 | E-02 | ○ |
| C-11 | {% block %}でブロック定義 | E-02 | ○ |
| C-12 | {% include %}で部分テンプレート | E-02 | ○ |
| C-13 | フィルター機能（escape, safe等） | E-02 | ○ |
| C-14 | ユーザー入力の自動エスケープ | E-02 | ○ |
| C-15 | Content-Type: text/html | E-03 | ○ |
| C-16 | TemplateNotFoundエラー | E-02, E-03 | ○ |
| C-17 | UndefinedErrorエラー | E-02 | ○ |
| C-18 | auto_reload設定で変更自動検出 | **Starlette/Jinja2実装** | △ |
| C-19 | テンプレートキャッシュ機能 | **Jinja2実装** | △ |

## 4) 不足情報（Unknown / Missing）

- Starlette/Jinja2実装の詳細は本プロジェクト外のため直接確認不可
  - 候補：Starlette公式ドキュメント / Jinja2公式ドキュメント / 実際のテスト

## 5) リスクフラグ（レビュー観点）

- 0: FastAPIでの再エクスポートは確認済み（低リスク）
- 1: Jinja2/Starlette依存の機能詳細は外部ドキュメント参照が必要（中リスク）

## 6) レビュアーチェックリスト（最小）

- [ ] Jinja2公式ドキュメントでテンプレート構文の詳細を確認
- [ ] XSS対策（自動エスケープ、safeフィルター）の説明が十分か確認
- [ ] CSRF対策について言及が必要か検討
