---
generated_at: 2026-01-22 19:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 43
  claims_without_evidence: 2
confidence_derived: 0.96
---

# 根拠レポート：業務要件一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：43 / 45、根拠なし：2
- 優先レビュー（高）
  1. **BR-042 ORMモデル対応**：orm_modeの詳細実装の確認が必要
  2. **BR-045 テンプレートレンダリング**：Jinja2Templatesの詳細仕様の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `fastapi/__init__.py` - パッケージ公開API定義
- E-02: `fastapi/applications.py` - FastAPIアプリケーションクラス定義
- E-03: `fastapi/routing.py` - ルーティング機能（APIRouter, APIRoute）
- E-04: `fastapi/params.py` - パラメータクラス（Path, Query, Header, Cookie, Body, Form, File, Depends, Security）
- E-05: `fastapi/exceptions.py` - 例外クラス（HTTPException, ValidationException等）
- E-06: `fastapi/encoders.py` - JSONエンコーダー（jsonable_encoder）
- E-07: `fastapi/background.py` - バックグラウンドタスク
- E-08: `fastapi/security/__init__.py` - セキュリティ機能（OAuth2, HTTPBasic, APIKey等）
- E-09: `fastapi/dependencies/utils.py` - 依存性注入ユーティリティ
- E-10: `fastapi/openapi/utils.py` - OpenAPI生成ユーティリティ
- E-11: `fastapi/datastructures.py` - データ構造（UploadFile等）
- E-12: `fastapi/middleware/cors.py` - CORSミドルウェア
- E-13: `fastapi/middleware/gzip.py` - GZIPミドルウェア
- E-14: `fastapi/middleware/httpsredirect.py` - HTTPSリダイレクトミドルウェア
- E-15: `fastapi/websockets.py` - WebSocket機能
- E-16: `fastapi/testclient.py` - テストクライアント
- E-17: `fastapi/staticfiles.py` - 静的ファイル配信
- E-18: `fastapi/templating.py` - テンプレートエンジン

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001: FastAPIクラスでASGI準拠アプリケーション作成 | E-01, E-02 | ○ |
| C-02 | BR-002: アプリケーション設定管理（title, description, version等） | E-02 | ○ |
| C-03 | BR-003: HTTP メソッドに対応したルート定義 | E-03 | ○ |
| C-04 | BR-004: パスパラメータの抽出・バリデーション | E-04 | ○ |
| C-05 | BR-005: クエリパラメータの抽出・バリデーション | E-04 | ○ |
| C-06 | BR-006: APIRouterによるモジュール分割 | E-03 | ○ |
| C-07 | BR-007: JSONリクエストボディの処理 | E-04, E-03 | ○ |
| C-08 | BR-008: フォームデータ処理 | E-04, E-09 | ○ |
| C-09 | BR-009: ファイルアップロード処理 | E-04, E-11 | ○ |
| C-10 | BR-010: ヘッダー処理 | E-04 | ○ |
| C-11 | BR-011: Cookie処理 | E-04 | ○ |
| C-12 | BR-012: JSONレスポンス生成 | E-06 | ○ |
| C-13 | BR-013: レスポンスモデル定義 | E-03 | ○ |
| C-14 | BR-014: ステータスコード制御 | E-03 | ○ |
| C-15 | BR-015: カスタムレスポンス | E-02 | ○ |
| C-16 | BR-016: 入力バリデーション | E-04, E-05 | ○ |
| C-17 | BR-017: レスポンスバリデーション | E-05 | ○ |
| C-18 | BR-018: バリデーションエラー処理 | E-05, E-02 | ○ |
| C-19 | BR-019: 依存性注入機能 | E-04, E-09 | ○ |
| C-20 | BR-020: 依存性のスコープ管理 | E-04, E-05 | ○ |
| C-21 | BR-021: グローバル依存性定義 | E-02 | ○ |
| C-22 | BR-022: OAuth2認証 | E-08 | ○ |
| C-23 | BR-023: HTTP Basic認証 | E-08 | ○ |
| C-24 | BR-024: APIキー認証 | E-08 | ○ |
| C-25 | BR-025: セキュリティスコープ管理 | E-04, E-08 | ○ |
| C-26 | BR-026: OpenAPIスキーマ自動生成 | E-10 | ○ |
| C-27 | BR-027: Swagger UI提供 | E-02 | ○ |
| C-28 | BR-028: ReDoc提供 | E-02 | ○ |
| C-29 | BR-029: OpenAPIカスタマイズ | E-02 | ○ |
| C-30 | BR-030: HTTPエラー処理 | E-05 | ○ |
| C-31 | BR-031: WebSocketエラー処理 | E-05 | ○ |
| C-32 | BR-032: カスタム例外ハンドラ | E-02 | ○ |
| C-33 | BR-033: ミドルウェア追加 | E-02 | ○ |
| C-34 | BR-034: CORS設定 | E-12 | ○ |
| C-35 | BR-035: GZIP圧縮 | E-13 | ○ |
| C-36 | BR-036: HTTPSリダイレクト | E-14 | ○ |
| C-37 | BR-037: WebSocket通信 | E-15, E-03 | ○ |
| C-38 | BR-038: 非同期エンドポイント | E-03 | ○ |
| C-39 | BR-039: バックグラウンドタスク | E-07 | ○ |
| C-40 | BR-040: ライフスパンイベント | E-02 | ○ |
| C-41 | BR-041: JSON互換エンコーディング | E-06 | ○ |
| C-42 | BR-042: ORMモデル対応 | E-06 | △ |
| C-43 | BR-043: テストクライアント提供 | E-16 | ○ |
| C-44 | BR-044: 静的ファイル配信 | E-17 | ○ |
| C-45 | BR-045: テンプレートレンダリング | E-18 | △ |

## 4) 不足情報（Unknown / Missing）
- **BR-042 ORMモデル対応**: `sqlalchemy_safe`パラメータの存在は確認できるが、orm_modeの詳細な動作仕様についてはPydantic側のドキュメントを参照する必要がある
  - 候補：Pydantic公式ドキュメント / SQLAlchemyチュートリアル / FastAPI公式ドキュメント
- **BR-045 テンプレートレンダリング**: `templating.py`はStarletteのJinja2Templatesを単純にインポートしているのみで、FastAPI固有の拡張機能の有無が不明
  - 候補：Starlette公式ドキュメント / Jinja2公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分の業務要件はソースコードから明確に根拠が確認できる
- **1: 中リスク** - BR-042, BR-045については外部ドキュメントとの整合性確認を推奨
- 全体的にFastAPIは十分にドキュメント化されたオープンソースプロジェクトであり、ソースコードのdocstringにも詳細な説明が含まれている

## 6) レビュアーチェックリスト（最小）
- [ ] 各カテゴリの業務要件が網羅的であるか確認
- [ ] 優先度（高/中/低）の設定が妥当であるか確認
- [ ] BR-042（ORMモデル対応）の詳細仕様を外部ドキュメントで確認
- [ ] BR-045（テンプレートレンダリング）のStarlette依存部分を確認
- [ ] 関連機能欄の記載が正確であるか確認
- [ ] FastAPIの最新バージョン（0.128.0）での機能変更がないか確認
