---
generated_at: 2026-01-22 19:30:00
metrics:
  claims_total: 50
  claims_with_evidence: 50
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：50 / 50、根拠なし：0
- 優先レビュー（高）
  1. なし（全ての主張にソースコード根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `fastapi/__init__.py` - FastAPIの公開インターフェース定義
- E-02: `fastapi/applications.py` - FastAPIアプリケーションクラス
- E-03: `fastapi/routing.py` - APIRouterとルーティング処理
- E-04: `fastapi/requests.py` - リクエスト処理
- E-05: `fastapi/responses.py` - レスポンス処理
- E-06: `fastapi/param_functions.py` - パラメータ関数（Path, Query, Header等）
- E-07: `fastapi/params.py` - パラメータクラス定義
- E-08: `fastapi/dependencies/utils.py` - 依存性注入ユーティリティ
- E-09: `fastapi/dependencies/models.py` - 依存性モデル
- E-10: `fastapi/security/__init__.py` - セキュリティモジュール公開インターフェース
- E-11: `fastapi/security/oauth2.py` - OAuth2認証
- E-12: `fastapi/security/http.py` - HTTP認証（Basic, Bearer, Digest）
- E-13: `fastapi/security/api_key.py` - APIキー認証
- E-14: `fastapi/security/open_id_connect_url.py` - OpenID Connect
- E-15: `fastapi/openapi/docs.py` - Swagger UI/ReDoc生成
- E-16: `fastapi/openapi/utils.py` - OpenAPIスキーマ生成
- E-17: `fastapi/openapi/models.py` - OpenAPIモデル定義
- E-18: `fastapi/exceptions.py` - 例外クラス定義
- E-19: `fastapi/exception_handlers.py` - 例外ハンドラ
- E-20: `fastapi/websockets.py` - WebSocket機能
- E-21: `fastapi/background.py` - バックグラウンドタスク
- E-22: `fastapi/encoders.py` - JSONエンコーダ
- E-23: `fastapi/datastructures.py` - データ構造（UploadFile等）
- E-24: `fastapi/middleware/__init__.py` - ミドルウェア基盤
- E-25: `fastapi/middleware/cors.py` - CORSミドルウェア
- E-26: `fastapi/middleware/gzip.py` - GZipミドルウェア
- E-27: `fastapi/middleware/httpsredirect.py` - HTTPSリダイレクト
- E-28: `fastapi/middleware/trustedhost.py` - TrustedHostミドルウェア
- E-29: `fastapi/middleware/wsgi.py` - WSGIミドルウェア
- E-30: `fastapi/middleware/asyncexitstack.py` - AsyncExitStackミドルウェア
- E-31: `fastapi/templating.py` - テンプレート機能
- E-32: `fastapi/staticfiles.py` - 静的ファイル
- E-33: `fastapi/testclient.py` - テストクライアント
- E-34: `fastapi/cli.py` - CLI機能
- E-35: `fastapi/concurrency.py` - 並行処理
- E-36: `fastapi/utils.py` - ユーティリティ
- E-37: `fastapi/_compat/` - 互換性レイヤー
- E-38: `fastapi/logger.py` - ログ機能
- E-39: `fastapi/types.py` - 型定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FastAPIアプリケーション機能 | E-01, E-02 | ○ |
| C-02 | APIRouter機能 | E-01, E-03 | ○ |
| C-03 | Request/Response処理 | E-04, E-05 | ○ |
| C-04 | Pathパラメータ | E-06, E-07 | ○ |
| C-05 | Queryパラメータ | E-06, E-07 | ○ |
| C-06 | Headerパラメータ | E-06, E-07 | ○ |
| C-07 | Cookieパラメータ | E-06, E-07 | ○ |
| C-08 | Bodyパラメータ | E-06, E-07 | ○ |
| C-09 | Formパラメータ | E-06, E-07 | ○ |
| C-10 | Fileアップロード | E-06, E-23 | ○ |
| C-11 | Depends依存性注入 | E-06, E-08, E-09 | ○ |
| C-12 | Security依存性注入 | E-06, E-10 | ○ |
| C-13 | OAuth2認証 | E-10, E-11 | ○ |
| C-14 | HTTP Basic認証 | E-10, E-12 | ○ |
| C-15 | HTTP Bearer認証 | E-10, E-12 | ○ |
| C-16 | HTTP Digest認証 | E-10, E-12 | ○ |
| C-17 | APIキー認証 | E-10, E-13 | ○ |
| C-18 | OpenID Connect | E-10, E-14 | ○ |
| C-19 | SecurityScopes | E-10, E-11 | ○ |
| C-20 | OpenAPIスキーマ生成 | E-16, E-17 | ○ |
| C-21 | Swagger UI | E-15 | ○ |
| C-22 | ReDoc | E-15 | ○ |
| C-23 | OAuth2リダイレクト | E-15 | ○ |
| C-24 | HTTPException | E-18 | ○ |
| C-25 | WebSocketException | E-18 | ○ |
| C-26 | RequestValidationError | E-18 | ○ |
| C-27 | ResponseValidationError | E-18 | ○ |
| C-28 | 例外ハンドラ | E-19 | ○ |
| C-29 | WebSocket接続 | E-20, E-03 | ○ |
| C-30 | WebSocketDisconnect | E-20 | ○ |
| C-31 | BackgroundTasks | E-21 | ○ |
| C-32 | jsonable_encoder | E-22 | ○ |
| C-33 | UploadFile | E-23 | ○ |
| C-34 | FormData/QueryParams | E-23 | ○ |
| C-35 | Middleware基盤 | E-24 | ○ |
| C-36 | CORSミドルウェア | E-25 | ○ |
| C-37 | GZipミドルウェア | E-26 | ○ |
| C-38 | HTTPSリダイレクト | E-27 | ○ |
| C-39 | TrustedHostミドルウェア | E-28 | ○ |
| C-40 | WSGIミドルウェア | E-29 | ○ |
| C-41 | AsyncExitStackミドルウェア | E-30 | ○ |
| C-42 | Jinja2Templates | E-31 | ○ |
| C-43 | StaticFiles | E-32 | ○ |
| C-44 | TestClient | E-33 | ○ |
| C-45 | fastapi CLI | E-34 | ○ |
| C-46 | run_in_threadpool | E-35 | ○ |
| C-47 | generate_unique_id | E-36 | ○ |
| C-48 | Pydantic v2互換 | E-37 | ○ |
| C-49 | ログ機能 | E-38 | ○ |
| C-50 | 型ヒント・型定義 | E-39 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての機能はソースコードから直接確認されており、根拠なしの項目はありません
- 外部ドキュメント（公式ドキュメント等）との照合は行っていないため、機能の詳細な振る舞いについては追加確認が推奨される場合があります

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての機能がソースコードで直接確認できるため、信頼性は高い
- 注意点: FastAPIはStarletteを基盤としているため、一部の機能（Request, Response, Middleware等）はStarletteからの再エクスポートであり、詳細な動作はStarletteのソースコード参照が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 機能カテゴリの分類は妥当か
- [ ] 機能名と説明は正確か
- [ ] 備考に記載されたソースファイルは正しいか
- [ ] 重要な機能の漏れはないか（特にStarletteから継承される機能）
- [ ] 機能の依存関係や相互作用が適切に記述されているか
