# 機能設計書 1-FastAPIアプリケーション

## 概要

本ドキュメントは、FastAPIフレームワークのメインエントリーポイントであるFastAPIアプリケーションクラスの機能設計を記述する。Starletteを拡張した高性能Webアプリケーションフレームワークとして、APIの構築に必要なすべての基盤機能を提供する。

### 本機能の処理概要

FastAPIアプリケーションは、Starletteフレームワークを継承・拡張したASGI対応Webアプリケーションフレームワークのコアクラスである。開発者はこのクラスをインスタンス化することで、RESTful APIやWebSocketエンドポイントを簡潔に定義できる。

**業務上の目的・背景**：現代のWebアプリケーション開発において、高性能かつ型安全なAPIを迅速に構築する需要が高まっている。FastAPIアプリケーションは、Python型ヒントを活用した自動バリデーション、OpenAPIスキーマの自動生成、非同期処理のネイティブサポートを提供することで、開発者の生産性向上とAPIの品質確保を同時に実現する。従来のフレームワークでは手動で行っていたドキュメント生成やバリデーション実装を自動化し、開発コストを大幅に削減する。

**機能の利用シーン**：
- 新規Webアプリケーション・APIサービスの開発開始時
- マイクロサービスアーキテクチャにおける各サービスの構築時
- 既存システムのモダナイゼーションでAPIレイヤーを刷新する際
- プロトタイプから本番環境まで一貫した開発フロー実現時

**主要な処理内容**：
1. アプリケーションインスタンスの初期化とStarletteベースクラスの設定
2. OpenAPI設定（タイトル、バージョン、説明等）の構成と保持
3. ルーターの初期化とパスオペレーションの登録基盤提供
4. ミドルウェアスタックの構築と例外ハンドラの設定
5. Swagger UI・ReDocドキュメントエンドポイントの自動設定
6. ライフサイクルイベント（startup/shutdown/lifespan）の管理

**関連システム・外部連携**：Starlette（ASGI基盤）、Pydantic（データバリデーション）、uvicorn/hypercorn等のASGIサーバー、OpenAPI/Swagger仕様に準拠したドキュメントツール

**権限による制御**：本機能自体は権限制御を持たないが、アプリケーション全体に適用されるグローバル依存性（dependencies引数）を通じて、認証・認可ミドルウェアを設定可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Swagger UI | 結果表示画面 | FastAPIアプリケーションの設定（タイトル、バージョン、説明等）がSwagger UIに反映される |
| 2 | ReDoc | 結果表示画面 | FastAPIアプリケーションの設定がReDocドキュメントに反映される |
| 5 | OpenAPI JSON | 結果表示画面 | アプリケーション設定を基にOpenAPIスキーマを生成 |

## 機能種別

フレームワーク基盤 / アプリケーション初期化 / ルーティング管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| debug | bool | No | デバッグモード有効化（デフォルト: False） | ブール値 |
| title | str | No | APIタイトル（デフォルト: "FastAPI"） | 文字列 |
| summary | Optional[str] | No | API概要 | 文字列または None |
| description | str | No | API説明（Markdown対応） | 文字列 |
| version | str | No | APIバージョン（デフォルト: "0.1.0"） | 文字列 |
| openapi_url | Optional[str] | No | OpenAPIスキーマURL（デフォルト: "/openapi.json"） | URLパスまたは None |
| openapi_tags | Optional[list[dict]] | No | OpenAPIタグ定義リスト | 辞書リストまたは None |
| servers | Optional[list[dict]] | No | サーバー情報リスト | 辞書リストまたは None |
| dependencies | Optional[Sequence[Depends]] | No | グローバル依存性リスト | Dependsインスタンスのシーケンス |
| default_response_class | type[Response] | No | デフォルトレスポンスクラス（デフォルト: JSONResponse） | Responseのサブクラス |
| docs_url | Optional[str] | No | Swagger UI URL（デフォルト: "/docs"） | URLパスまたは None |
| redoc_url | Optional[str] | No | ReDoc URL（デフォルト: "/redoc"） | URLパスまたは None |
| swagger_ui_oauth2_redirect_url | Optional[str] | No | OAuth2リダイレクトURL | URLパスまたは None |
| middleware | Optional[Sequence[Middleware]] | No | ミドルウェアリスト | Middlewareインスタンスのシーケンス |
| exception_handlers | Optional[dict] | No | 例外ハンドラ辞書 | 例外型/コードとハンドラ関数の辞書 |
| lifespan | Optional[Lifespan] | No | ライフスパンコンテキストマネージャ | Lifespanインスタンス |
| root_path | str | No | ルートパス（プロキシ経由時） | 文字列 |

### 入力データソース

- コンストラクタ引数（開発者による直接指定）
- 環境設定ファイル（Pydantic Settings経由での読み込み推奨）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| app | FastAPI | 初期化済みFastAPIアプリケーションインスタンス |
| openapi_schema | dict | 生成されたOpenAPIスキーマ（openapi()メソッド経由） |
| routes | list[BaseRoute] | 登録済みルート一覧 |
| state | State | アプリケーション状態オブジェクト |

### 出力先

- ASGIサーバー（uvicorn等）への受け渡し
- テストクライアントへのマウント
- 他のASGIアプリケーションへのサブマウント

## 処理フロー

### 処理シーケンス

```
1. FastAPIインスタンス生成
   └─ コンストラクタ引数の受け取りと検証
2. Starletteベースクラスの初期化
   └─ ルーター、ミドルウェアスタック、例外ハンドラの設定
3. FastAPI固有設定の初期化
   └─ OpenAPI関連設定、ドキュメントURL設定の保持
4. APIRouterの初期化と設定
   └─ デフォルトレスポンスクラス、依存性の設定
5. ドキュメントエンドポイントの自動登録
   └─ /docs, /redoc, /openapi.json エンドポイントの設定
6. ミドルウェアスタックの構築
   └─ AsyncExitStackMiddleware等の追加
7. 例外ハンドラの登録
   └─ RequestValidationError、HTTPException等のハンドラ設定
```

### フローチャート

```mermaid
flowchart TD
    A[FastAPI初期化開始] --> B[コンストラクタ引数検証]
    B --> C[Starlette初期化]
    C --> D[OpenAPI設定保持]
    D --> E[APIRouter初期化]
    E --> F{openapi_url設定あり?}
    F -->|Yes| G[ドキュメントエンドポイント登録]
    F -->|No| H[ドキュメント無効化]
    G --> I[ミドルウェア構築]
    H --> I
    I --> J[例外ハンドラ登録]
    J --> K[初期化完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | OpenAPI自動無効化 | openapi_urlがNoneの場合、docs_urlとredoc_urlも自動的に無効化される | openapi_url=None指定時 |
| BR-002 | デフォルトレスポンス継承 | default_response_classはルーター・パスオペレーションに継承される | response_class未指定のパスオペレーション |
| BR-003 | ルートパス適用 | root_pathはOpenAPIスキーマのserversに自動反映される | root_path_in_servers=True（デフォルト） |

### 計算ロジック

該当なし（初期化・設定保持が主機能）

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本機能はデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | AssertionError | routes引数が非推奨パラメータとして使用された場合の警告 | path operation methodsの使用を推奨 |
| - | TypeError | 不正な型の引数が渡された場合 | 型ヒントに従った正しい型の引数を渡す |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- インスタンス生成は同期的に実行され、通常数ミリ秒以内に完了する
- OpenAPIスキーマ生成は初回アクセス時にキャッシュされる

## セキュリティ考慮事項

- debugモードは本番環境では無効化すること（スタックトレース露出防止）
- docs_url/redoc_urlは必要に応じてNone設定で無効化可能
- グローバル依存性を通じた認証・認可の一元管理を推奨

## 備考

- FastAPIはStarletteを継承しているため、Starletteの全機能が利用可能
- Pydantic v2との互換性が完全にサポートされている

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

FastAPIアプリケーションの設定値とその型定義を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | datastructures.py | `fastapi/datastructures.py` | Default、DefaultPlaceholderクラスの役割を理解する |
| 1-2 | types.py | `fastapi/types.py` | DecoratedCallable、IncEx等の型定義を確認 |

**読解のコツ**: DefaultPlaceholderは「値が明示的に設定されたか」を判定するためのラッパークラス。デフォルト値がFalsyでも区別可能にする仕組み。

#### Step 2: エントリーポイントを理解する

FastAPIクラスの定義と初期化処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | applications.py | `fastapi/applications.py` | FastAPIクラスの定義と__init__メソッド |

**主要処理フロー**:
1. **48-62行目**: FastAPIクラス定義とドキュメント
2. **64-700行目**: __init__メソッドでの各種パラメータの受け取りとStarlette初期化
3. **101-121行目**: title設定の定義とドキュメント
4. **205-227行目**: openapi_url設定の定義
5. **337-358行目**: dependencies（グローバル依存性）設定

#### Step 3: ルーティング基盤を理解する

APIRouterとの連携を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | routing.py | `fastapi/routing.py` | APIRouter、APIRouteクラスの定義 |

**主要処理フロー**:
- **664-690行目**: APIRouterクラスの定義とドキュメント
- **485-662行目**: APIRouteクラスによるパスオペレーション管理

#### Step 4: OpenAPI生成を理解する

OpenAPIスキーマ生成の仕組みを確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | openapi/utils.py | `fastapi/openapi/utils.py` | get_openapi関数によるスキーマ生成 |
| 4-2 | openapi/docs.py | `fastapi/openapi/docs.py` | Swagger UI/ReDoc HTML生成 |

### プログラム呼び出し階層図

```
FastAPI (applications.py)
    │
    ├─ Starlette (starlette/applications.py) [継承]
    │      └─ Router (starlette/routing.py)
    │
    ├─ APIRouter (routing.py) [内部ルーター]
    │      └─ APIRoute (routing.py)
    │             └─ get_request_handler
    │
    ├─ get_openapi (openapi/utils.py) [スキーマ生成]
    │
    └─ get_swagger_ui_html / get_redoc_html (openapi/docs.py) [ドキュメント生成]
```

### データフロー図

```
[入力]                     [処理]                           [出力]

コンストラクタ引数 ───▶ FastAPI.__init__() ───▶ FastAPIインスタンス
                              │
                              ├─▶ Starlette初期化
                              │
                              ├─▶ APIRouter設定
                              │
                              └─▶ ドキュメントエンドポイント登録

HTTPリクエスト ───▶ ASGIインターフェース ───▶ レスポンス
                    (app.__call__)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| applications.py | `fastapi/applications.py` | ソース | FastAPIクラスの定義 |
| routing.py | `fastapi/routing.py` | ソース | APIRouter、APIRouteクラス |
| datastructures.py | `fastapi/datastructures.py` | ソース | Default、UploadFile等のデータ構造 |
| types.py | `fastapi/types.py` | ソース | 型定義 |
| openapi/utils.py | `fastapi/openapi/utils.py` | ソース | OpenAPIスキーマ生成 |
| openapi/docs.py | `fastapi/openapi/docs.py` | ソース | ドキュメントUI生成 |
| exception_handlers.py | `fastapi/exception_handlers.py` | ソース | デフォルト例外ハンドラ |
| middleware/asyncexitstack.py | `fastapi/middleware/asyncexitstack.py` | ソース | 依存性管理ミドルウェア |
