# 機能設計書 10-Fileアップロード

## 概要

本ドキュメントは、FastAPIフレームワークにおけるFileアップロード機能の設計を記述する。multipart/form-data形式でアップロードされたファイルを受け取るパラメータ定義機能であり、UploadFileクラスによる非同期ファイル操作を提供する。

### 本機能の処理概要

Fileアップロード機能は、HTTPリクエストのmultipart/form-data形式で送信されたファイルを受け取り、パスオペレーション関数の引数として渡す機能である。UploadFileクラスを通じて、ファイル名、サイズ、Content-Type等のメタデータと共にファイル内容にアクセスできる。

**業務上の目的・背景**：Webアプリケーションにおいて、ユーザーからのファイルアップロード（画像、ドキュメント、データファイル等）は重要な機能である。プロフィール画像のアップロード、ドキュメント管理、データインポート等、多様なユースケースに対応する必要がある。本機能により、ファイルアップロードの受け取りと処理を型安全かつ非同期で実装できる。

**機能の利用シーン**：
- プロフィール画像のアップロード
- ドキュメントファイルのアップロード
- CSVデータのインポート
- 複数ファイルの一括アップロード

**主要な処理内容**：
1. multipart/form-data形式のリクエストボディ解析
2. アップロードファイルの一時保存
3. UploadFileオブジェクトの生成（ファイルハンドル、メタデータ）
4. 非同期ファイル読み取り/書き込みメソッドの提供
5. OpenAPIスキーマへのファイルパラメータ情報追加

**関連システム・外部連携**：Starlette（UploadFileベースクラス）、python-multipart（パーサー）、OpenAPI（スキーマ生成）

**権限による制御**：本機能自体は権限制御を持たないが、依存性注入を通じてアップロード権限チェックが可能

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに直接の関連なし |

## 機能種別

ファイル処理 / マルチパートデータ処理 / 非同期I/O

## 入力仕様

### 入力パラメータ（File）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| default | Any | No | デフォルト値（Undefinedで必須） | 任意 |
| media_type | str | No | メディアタイプ（デフォルト: "multipart/form-data"） | MIMEタイプ |
| alias | Optional[str] | No | パラメータの別名 | 文字列 |
| title | Optional[str] | No | 人間可読なタイトル（OpenAPI用） | 文字列 |
| description | Optional[str] | No | パラメータの説明（OpenAPI用） | 文字列 |
| deprecated | Union[bool, str, None] | No | 非推奨フラグ | ブール値または文字列 |
| include_in_schema | bool | No | OpenAPIスキーマへの含有（デフォルト: True） | ブール値 |

### UploadFileの属性

| 属性名 | 型 | 説明 |
|--------|-----|------|
| file | BinaryIO | ファイルオブジェクト（同期アクセス用） |
| filename | Optional[str] | アップロードされたファイル名 |
| size | Optional[int] | ファイルサイズ（バイト） |
| headers | Headers | リクエストヘッダー |
| content_type | Optional[str] | Content-Type |

### UploadFileのメソッド

| メソッド名 | 戻り値 | 説明 |
|-----------|--------|------|
| read(size: int = -1) | bytes | 指定バイト数を読み取り（非同期） |
| write(data: bytes) | None | バイト列を書き込み（非同期） |
| seek(offset: int) | None | ファイル位置を移動（非同期） |
| close() | None | ファイルを閉じる（非同期） |

### 入力データソース

- HTTPリクエストボディ（multipart/form-data形式）
- パスオペレーション定義（関数シグネチャ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ファイルオブジェクト | UploadFile | アップロードされたファイルを表すオブジェクト |
| ファイル内容 | bytes | ファイルの内容（bytes型引数の場合） |

### 出力先

- パスオペレーション関数の引数

## 処理フロー

### 処理シーケンス

```
1. multipart/form-dataパース
   └─ python-multipartによるリクエストボディ解析
2. ファイル抽出
   └─ フォームデータからファイルパートを抽出
3. 一時ファイル作成
   └─ SpooledTemporaryFileに内容を保存
4. UploadFileオブジェクト生成
   └─ ファイルハンドルとメタデータを保持
5. 関数引数への受け渡し
6. 処理完了後のクリーンアップ
   └─ 一時ファイルの自動削除
```

### フローチャート

```mermaid
flowchart TD
    A[HTTPリクエスト受信] --> B[Content-Typeチェック]
    B --> C{multipart/form-data?}
    C -->|Yes| D[request.form取得]
    C -->|No| E[エラー]
    D --> F[ファイルパート抽出]
    F --> G[SpooledTemporaryFile作成]
    G --> H[UploadFileオブジェクト生成]
    H --> I[関数引数に設定]
    I --> J[パスオペレーション実行]
    J --> K[ファイルクローズ・クリーンアップ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | python-multipart必須 | ファイルアップロードにはpython-multipartパッケージが必要 | File使用時 |
| BR-002 | bytes型の場合 | bytes型ヒントの場合、ファイル内容がメモリに読み込まれる | bytes型指定時 |
| BR-003 | UploadFile型の場合 | UploadFile型ヒントの場合、ストリーミングアクセスが可能 | UploadFile型指定時 |
| BR-004 | 複数ファイル | list[UploadFile]で複数ファイルを受け取り可能 | リスト型ヒント時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本機能はデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 422 | Unprocessable Entity | 必須ファイルが未送信 | ファイルを送信する |
| 400 | Bad Request | multipartパースエラー | 正しい形式で送信 |
| 413 | Request Entity Too Large | ファイルサイズ超過 | サイズ制限内のファイルを送信 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- 小さいファイルはメモリ上のSpooledTemporaryFileに保存
- 大きいファイルはディスクの一時ファイルに保存（1MB以上）
- 非同期I/OによりI/Oバウンドの処理を効率化

## セキュリティ考慮事項

- アップロードファイルサイズの制限
- 許可するファイル拡張子・MIMEタイプの制限
- ファイル名のサニタイズ（パストラバーサル対策）
- アップロードディレクトリのアクセス権限設定
- ウイルススキャンの実施（必要に応じて）
- ファイル内容の検証（マジックバイトチェック等）

## 備考

- FileクラスはFormを継承（media_type="multipart/form-data"）
- UploadFileはStarletteのUploadFileを拡張し、Pydantic互換を追加
- async with構文でのファイルクローズが推奨

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

UploadFileクラスとFileクラスの定義を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | datastructures.py | `fastapi/datastructures.py` | UploadFileクラスの定義（23-153行目） |
| 1-2 | params.py | `fastapi/params.py` | Fileクラスの定義（664-743行目） |

**読解のコツ**:
- **23行目**: UploadFileはStarletteUploadFileを継承
- **57-66行目**: file、filename、size、headers、content_type属性の定義
- **68-86行目**: write()メソッド（非同期）
- **88-104行目**: read()メソッド（非同期）
- **106-124行目**: seek()メソッド（非同期）
- **126-132行目**: close()メソッド（非同期）
- **664行目**: FileクラスはFormを継承（`class File(Form)`）
- **671行目**: media_type: str = "multipart/form-data"

#### Step 2: 関数インターフェースを理解する

File()関数の定義を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | param_functions.py | `fastapi/param_functions.py` | File関数の定義（1880-2172行目） |

**主要処理フロー**:
1. **1901-1909行目**: media_typeパラメータ（デフォルト: multipart/form-data）
2. **2140-2172行目**: params.Fileインスタンスの生成と返却

### プログラム呼び出し階層図

```
@app.post("/upload")
async def upload_file(file: UploadFile):
    │
    ├─ get_dependant() [dependencies/utils.py]
    │      └─ Fileパラメータとして登録
    │
    └─ solve_dependencies() [dependencies/utils.py]
           │
           ├─ await request.form()
           ├─ FormData from UploadFile抽出
           │      └─ SpooledTemporaryFile使用
           ├─ UploadFileオブジェクト生成
           └─ 関数引数への値設定
```

### データフロー図

```
[入力]                     [処理]                           [出力]

POST /upload
Content-Type: multipart/form-data
--boundary
Content-Disposition: form-data; name="file"; filename="image.png"
Content-Type: image/png

<binary data>
--boundary--
         │
         ▼
    request.form() ───▶ FormData
         │
         ▼
    UploadFile抽出 ───▶ UploadFile(
                            file=SpooledTemporaryFile,
                            filename="image.png",
                            content_type="image/png"
                        )
         │
         ▼
    file: UploadFile ───▶ 関数引数
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| param_functions.py | `fastapi/param_functions.py` | ソース | File関数定義 |
| params.py | `fastapi/params.py` | ソース | Fileクラス定義 |
| datastructures.py | `fastapi/datastructures.py` | ソース | UploadFileクラス定義 |
| dependencies/utils.py | `fastapi/dependencies/utils.py` | ソース | ファイルアップロード処理 |
| routing.py | `fastapi/routing.py` | ソース | フォームデータ・ファイルのクローズ処理 |
