# 機能設計書 20-OpenAPIスキーマ生成

## 概要

本ドキュメントはFastAPIフレームワークにおけるOpenAPIスキーマ生成機能の設計仕様を定義する。

### 本機能の処理概要

OpenAPIスキーマ生成機能は、FastAPIアプリケーションのルート定義から自動的にOpenAPI 3.1.0準拠のAPIスキーマを生成する。生成されたスキーマはSwagger UIやReDocでのAPI文書表示、クライアントコード自動生成、APIテストツールとの連携などに使用される。

**業務上の目的・背景**：OpenAPIはREST APIの仕様を記述する業界標準フォーマットであり、API開発において以下の利点を提供する。自動ドキュメント生成によりAPIの可視化と理解を促進し、クライアントSDKの自動生成により開発効率を向上させ、契約ベースの開発を可能にする。FastAPIはこのOpenAPIスキーマを完全に自動生成する。

**機能の利用シーン**：
- `/openapi.json`エンドポイントでのスキーマ取得
- Swagger UI（/docs）でのインタラクティブなAPI文書表示
- ReDoc（/redoc）での美しいAPI文書表示
- OpenAPI Generatorによるクライアントコード自動生成
- Postman等のAPIテストツールとの連携

**主要な処理内容**：
1. アプリケーションのルート情報を収集
2. パスオペレーション（エンドポイント）の解析
3. リクエスト/レスポンススキーマの生成
4. セキュリティスキームの定義
5. OpenAPI仕様に準拠したJSONの出力

**関連システム・外部連携**：
- Swagger UI: スキーマを元にインタラクティブUI生成
- ReDoc: スキーマを元に文書UI生成
- Pydantic: モデルからJSONスキーマを生成
- JSON Schema Draft 2020-12: スキーマ定義の基盤

**権限による制御**：OpenAPIスキーマ自体には認証がかからない（デフォルト）。本番環境でスキーマを非公開にする場合は、openapi_url=Noneを設定する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Swagger UI | 主機能 | OpenAPIスキーマを解析してインタラクティブUIを生成 |
| 2 | ReDoc | 主機能 | OpenAPIスキーマを解析してドキュメントUIを生成 |

## 機能種別

ドキュメント生成 / API仕様定義

## 入力仕様

### 入力パラメータ（get_openapi関数）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| title | str | Yes | APIのタイトル | 必須 |
| version | str | Yes | APIのバージョン | 必須 |
| openapi_version | str | No | OpenAPIバージョン（デフォルト: "3.1.0"） | 文字列 |
| summary | str \| None | No | APIの概要 | 文字列 |
| description | str \| None | No | APIの詳細説明（Markdown対応） | 文字列 |
| routes | Sequence[BaseRoute] | Yes | ルート定義のシーケンス | 必須 |
| webhooks | Sequence[BaseRoute] \| None | No | Webhookルートのシーケンス | シーケンス |
| tags | list[dict] \| None | No | タグ定義のリスト | リスト |
| servers | list[dict] \| None | No | サーバー定義のリスト | リスト |
| terms_of_service | str \| None | No | 利用規約のURL | URL形式 |
| contact | dict \| None | No | 連絡先情報 | 辞書 |
| license_info | dict \| None | No | ライセンス情報 | 辞書 |
| separate_input_output_schemas | bool | No | 入力/出力スキーマを分離するか（デフォルト: True） | ブール値 |
| external_docs | dict \| None | No | 外部ドキュメントへのリンク | 辞書 |

### 入力データソース

- FastAPIアプリケーションのルート登録情報
- パスオペレーション関数のシグネチャ
- Pydanticモデルの定義
- Security依存関係の定義

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| openapi | str | OpenAPIバージョン（例: "3.1.0"） |
| info | dict | API情報（title、version、description等） |
| paths | dict | パスオペレーションの定義 |
| components | dict | 再利用可能なコンポーネント（schemas、securitySchemes） |
| security | list | グローバルセキュリティ要件 |
| tags | list | タグ定義 |
| servers | list | サーバー定義 |
| webhooks | dict | Webhook定義 |

### 出力先

- `/openapi.json`エンドポイント（JSON形式）
- アプリケーションのopenapi()メソッド

## 処理フロー

### 処理シーケンス

```
1. ルート情報の収集
   └─ get_fields_from_routes: ルートからフィールド情報を収集
2. モデル名マップの生成
   └─ get_compat_model_name_map: Pydanticモデルの名前マップを生成
3. スキーマ定義の生成
   └─ get_definitions: JSON Schemaの定義を生成
4. パスオペレーションの処理
   └─ get_openapi_path: 各ルートのOpenAPI定義を生成
      ├─ get_openapi_operation_metadata: メタデータ（tags、summary、operationId等）
      ├─ _get_openapi_operation_parameters: パラメータ定義
      ├─ get_openapi_operation_request_body: リクエストボディ定義
      └─ get_openapi_security_definitions: セキュリティ定義
5. 結果の統合
   └─ OpenAPIモデルのインスタンス化とJSON変換
```

### フローチャート

```mermaid
flowchart TD
    A[get_openapi呼び出し] --> B[get_fields_from_routes]
    B --> C[get_compat_model_name_map]
    C --> D[get_definitions]
    D --> E[ルートのループ処理]
    E --> F[get_openapi_path]
    F --> G[get_openapi_operation_metadata]
    F --> H[_get_openapi_operation_parameters]
    F --> I[get_openapi_operation_request_body]
    F --> J[get_openapi_security_definitions]
    G --> K[paths辞書に追加]
    H --> K
    I --> K
    J --> L[components/securitySchemesに追加]
    K --> M{次のルート?}
    M -->|Yes| E
    M -->|No| N[OpenAPIモデル生成]
    N --> O[jsonable_encoder]
    O --> P[OpenAPIスキーマJSON]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-20-01 | operationId一意性 | 同一operationIdが重複する場合、警告を出力 | 複数ルートで同一IDを使用 |
| BR-20-02 | バリデーションエラー定義 | パラメータまたはボディを持つルートには自動で422エラーレスポンスを追加 | include_in_schema=True |
| BR-20-03 | スキーマソート | components/schemasはアルファベット順にソートされる | スキーマ出力時 |
| BR-20-04 | ヘッダー変換 | ヘッダーパラメータのアンダースコアはデフォルトでハイフンに変換 | convert_underscores=True |
| BR-20-05 | include_in_schema | include_in_schema=Falseのルートはスキーマに含まれない | ルート登録時 |

### 計算ロジック

operationIdの生成（デフォルト）:
```python
operation_id = route.operation_id or route.unique_id
# unique_idは関数名とパスから自動生成
```

HTTPステータスの説明文自動生成:
```python
status_text = status_code_ranges.get(str(code).upper()) or http.client.responses.get(int(code))
```

## データベース操作仕様

本機能はデータベース操作を直接行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| Warning | 重複operationId | 同一operationIdが複数ルートで使用された | 一意なoperation_idを明示的に指定 |
| AssertionError | メソッド未定義 | ルートにmethodsが設定されていない | methodsを正しく設定 |

### リトライ仕様

本機能では自動リトライは行わない。

## トランザクション仕様

本機能はトランザクション管理を行わない。

## パフォーマンス要件

- スキーマ生成は一度だけ実行され、結果がキャッシュされる
- 大量のルート（1000以上）がある場合、初回生成に時間がかかる可能性がある
- Pydanticモデルの複雑さに応じてスキーマ生成時間が増加

## セキュリティ考慮事項

- OpenAPIスキーマはデフォルトで公開される（/openapi.json）
- 本番環境でAPIスキーマを非公開にする場合は、openapi_url=Noneを設定
- スキーマにはエンドポイントの詳細情報が含まれるため、攻撃者に情報を提供する可能性がある
- セキュリティスキームの定義は含まれるが、実際の認証情報は含まれない

## 備考

- OpenAPI 3.1.0はJSON Schema Draft 2020-12に準拠している
- separate_input_output_schemas=Trueにより、入力と出力で異なるスキーマ（readonly、writeonly等）を生成可能
- Webhookはroutes とは別にwebhooksパラメータで指定する

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、OpenAPIモデルの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | models.py | `fastapi/openapi/models.py` | OpenAPIモデル（422-433行目） |
| 1-2 | models.py | `fastapi/openapi/models.py` | Components、PathItem、Operationモデル |

**読解のコツ**: `OpenAPI`クラスがルートモデルであり、`info`、`paths`、`components`等の主要セクションを持つ。

#### Step 2: メインエントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | utils.py | `fastapi/openapi/utils.py` | get_openapi関数（476-567行目） |

**主要処理フロー**:
1. **493-503行目**: info辞書の構築
2. **504-510行目**: 初期出力構造の設定
3. **511-517行目**: フィールド収集とスキーマ定義生成
4. **518-536行目**: ルートのループ処理とパス定義生成
5. **556-567行目**: 最終出力の組み立てとJSON変換

#### Step 3: パスオペレーション生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | utils.py | `fastapi/openapi/utils.py` | get_openapi_path関数（259-442行目） |

**主要処理フロー**:
- **280-283行目**: メタデータ取得（get_openapi_operation_metadata）
- **285-292行目**: セキュリティ定義取得（get_openapi_security_definitions）
- **293-312行目**: パラメータ定義取得
- **313-321行目**: リクエストボディ定義取得
- **339-373行目**: レスポンス定義生成
- **418-438行目**: バリデーションエラーレスポンス追加

#### Step 4: セキュリティ定義生成を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | utils.py | `fastapi/openapi/utils.py` | get_openapi_security_definitions関数（78-101行目） |

**主要処理フロー**:
- **84-91行目**: セキュリティ依存関係からスキーム定義を抽出
- **92-97行目**: 同一スキームのスコープをマージ
- **98-100行目**: OpenAPI形式のsecurity要件を構築

### プログラム呼び出し階層図

```
get_openapi(title, version, routes, ...)
    │
    ├─ get_fields_from_routes(routes)
    │      └─ 各ルートからModelFieldを収集
    │
    ├─ get_compat_model_name_map(all_fields)
    │      └─ Pydanticモデルの名前マップ生成
    │
    ├─ get_definitions(fields, model_name_map)
    │      └─ JSON Schema定義を生成
    │
    └─ get_openapi_path(route, ...)  [ルートごとにループ]
           │
           ├─ get_openapi_operation_metadata(route, method)
           │      └─ tags、summary、operationId等
           │
           ├─ get_openapi_security_definitions(flat_dependant)
           │      └─ securitySchemes、security要件
           │
           ├─ _get_openapi_operation_parameters(dependant, ...)
           │      └─ path、query、header、cookieパラメータ
           │
           └─ get_openapi_operation_request_body(body_field, ...)
                  └─ requestBody定義
```

### データフロー図

```
[入力]                    [処理]                         [出力]

FastAPIアプリ           get_openapi()                OpenAPI JSON
routes             ───▶  スキーマ生成         ───▶   /openapi.json
    │                         │
    ▼                         ▼
ルート解析              get_openapi_path()
body_field              パス定義生成
response_field              │
dependant                   ▼
    │               get_openapi_security_definitions()
    ▼               セキュリティスキーム
Pydanticモデル              │
    │                       ▼
    ▼               _get_openapi_operation_parameters()
get_definitions()      パラメータ定義
JSON Schema                 │
                            ▼
                   components.schemas
                   paths
                   securitySchemes
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| utils.py | `fastapi/openapi/utils.py` | ソース | OpenAPIスキーマ生成の主要ロジック |
| models.py | `fastapi/openapi/models.py` | ソース | OpenAPI仕様のPydanticモデル定義 |
| constants.py | `fastapi/openapi/constants.py` | ソース | REF_PREFIX等の定数定義 |
| routing.py | `fastapi/routing.py` | ソース | APIRouteクラス（ルート情報の提供元） |
| applications.py | `fastapi/applications.py` | ソース | FastAPIアプリでのopenapi()メソッド |
| _compat.py | `fastapi/_compat.py` | ソース | Pydanticとの互換性処理 |
