# 機能設計書 21-Swagger UI

## 概要

本ドキュメントは、FastAPIフレームワークが提供するSwagger UIインタラクティブAPIドキュメント機能の設計について記載する。

### 本機能の処理概要

Swagger UIは、OpenAPI仕様に基づいたインタラクティブなAPIドキュメントを自動生成し、Webブラウザ上で閲覧・操作可能にする機能である。開発者やAPIユーザーは、Swagger UIを通じてAPIエンドポイントの仕様確認、リクエストパラメータの確認、および実際のAPIリクエストの実行・テストを行うことができる。

**業務上の目的・背景**：API開発において、開発者間でのAPI仕様共有やフロントエンド開発者によるAPI動作確認は重要な作業である。従来、API仕様書は別途作成・管理が必要であったが、Swagger UIはコードから自動生成されたOpenAPIスキーマを視覚化することで、ドキュメント管理の負担を軽減し、仕様とコードの乖離を防止する。

**機能の利用シーン**：
- 開発フェーズでのAPI仕様確認およびテスト
- フロントエンド開発者によるバックエンドAPI連携時の動作検証
- QAチームによるAPI機能テスト
- 外部開発者へのAPI仕様公開

**主要な処理内容**：
1. FastAPIアプリケーション起動時にSwagger UIエンドポイント（デフォルト: `/docs`）を自動登録
2. OpenAPIスキーマURL（デフォルト: `/openapi.json`）を参照するHTMLページを動的生成
3. Swagger UI JavaScript/CSSライブラリをCDNまたはカスタムURLからロード
4. OAuth2認証フローのサポート（オプション）

**関連システム・外部連携**：
- CDN（jsdelivr.net）からのSwagger UIアセット取得
- OpenAPIスキーマ生成機能との連携
- OAuth2認証サーバーとの連携（OAuth2使用時）

**権限による制御**：本機能自体には認証・認可は設定されていないが、`docs_url=None`の設定により無効化可能。本番環境では無効化することを推奨。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | Swagger UI | 主画面 | /docsエンドポイントでインタラクティブなAPIドキュメント画面を表示 |

## 機能種別

ドキュメント生成 / UI表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| openapi_url | str | Yes | OpenAPIスキーマのURL | 有効なURLパス形式 |
| title | str | Yes | HTMLページのタイトル | - |
| swagger_js_url | str | No | Swagger UI JavaScriptのURL | デフォルト: CDN URL |
| swagger_css_url | str | No | Swagger UI CSSのURL | デフォルト: CDN URL |
| swagger_favicon_url | str | No | ファビコンのURL | デフォルト: FastAPI公式URL |
| oauth2_redirect_url | Optional[str] | No | OAuth2リダイレクトURL | - |
| init_oauth | Optional[dict] | No | OAuth2初期化設定 | - |
| swagger_ui_parameters | Optional[dict] | No | Swagger UIカスタムパラメータ | - |

### 入力データソース

- FastAPIアプリケーション設定（タイトル、OpenAPI URL等）
- HTTPリクエスト（root_pathの取得）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| html | str | Swagger UI表示用のHTMLコンテンツ |
| response | HTMLResponse | HTTPレスポンスオブジェクト |

### 出力先

- HTTPレスポンス（HTMLコンテンツ）

## 処理フロー

### 処理シーケンス

```
1. FastAPIアプリケーション初期化（setup()メソッド）
   └─ openapi_urlとdocs_urlが設定されている場合、Swagger UIルートを登録
2. クライアントからの/docsリクエスト受信
   └─ swagger_ui_html関数が呼び出される
3. root_pathの取得
   └─ リクエストスコープからroot_pathを取得し、OpenAPI URLを構築
4. get_swagger_ui_html関数の呼び出し
   └─ Swagger UIパラメータのマージ、HTMLテンプレートの生成
5. HTMLResponseの返却
   └─ 生成されたHTMLをクライアントに返却
```

### フローチャート

```mermaid
flowchart TD
    A[クライアントが/docsにアクセス] --> B{openapi_url設定あり?}
    B -->|No| C[404エラー]
    B -->|Yes| D{docs_url設定あり?}
    D -->|No| C
    D -->|Yes| E[root_pathを取得]
    E --> F[openapi_urlを構築]
    F --> G[get_swagger_ui_html呼び出し]
    G --> H[デフォルトパラメータとカスタムパラメータをマージ]
    H --> I[HTMLテンプレート生成]
    I --> J{oauth2_redirect_url設定あり?}
    J -->|Yes| K[OAuth2リダイレクト設定を追加]
    J -->|No| L[HTMLResponse生成]
    K --> L
    L --> M[レスポンス返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-21-1 | OpenAPI URL必須 | Swagger UIを表示するにはopenapi_urlが設定されている必要がある | 常時 |
| BR-21-2 | docs_url無効化 | docs_url=Noneの場合、Swagger UIエンドポイントは登録されない | docs_url=None時 |
| BR-21-3 | デフォルトパラメータ | swagger_ui_parametersが未指定の場合、swagger_ui_default_parametersが使用される | swagger_ui_parameters未指定時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本機能はデータベースアクセスを行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | AssertionError | openapi_url設定時にtitleが未設定 | FastAPI初期化時にtitleを指定する |
| - | AssertionError | openapi_url設定時にversionが未設定 | FastAPI初期化時にversionを指定する |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし（本機能はステートレスなHTMLレスポンス生成のみ）

## パフォーマンス要件

- HTML生成は同期処理で即時完了
- CDNからのSwagger UIアセット取得はクライアント側で実行

## セキュリティ考慮事項

- 本番環境ではdocs_url=Noneに設定してSwagger UIを無効化することを推奨
- OAuth2認証を使用する場合、適切なリダイレクトURLの設定が必要
- XSS攻撃防止のため、ユーザー入力値はJSONエンコードされる

## 備考

- Swagger UIのバージョンはCDN URLで指定（デフォルト: v5）
- カスタムSwagger UIアセットを使用する場合は、swagger_js_url/swagger_css_urlを指定

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Swagger UIの設定パラメータとデフォルト値を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | docs.py | `fastapi/openapi/docs.py` | swagger_ui_default_parametersの定義を確認 |

**読解のコツ**: `swagger_ui_default_parameters`（8-23行目）はSwagger UIのJavaScript初期化オプションのデフォルト値を定義している。dom_id、layout、deepLinkingなどの設定項目がある。

#### Step 2: エントリーポイントを理解する

FastAPIアプリケーションのsetupメソッドでSwagger UIルートがどのように登録されるかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | applications.py | `fastapi/applications.py` | setup()メソッドでのルート登録処理 |

**主要処理フロー**:
1. **1079-1080行目**: openapi_urlが設定されているかチェック
2. **1093-1109行目**: docs_urlが設定されている場合、swagger_ui_html関数を定義しルートに登録
3. **1095-1106行目**: swagger_ui_html関数内でroot_pathを取得し、get_swagger_ui_htmlを呼び出し

#### Step 3: HTML生成処理を理解する

get_swagger_ui_html関数の詳細な処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | docs.py | `fastapi/openapi/docs.py` | get_swagger_ui_html関数の実装 |

**主要処理フロー**:
- **26-101行目**: 関数定義とパラメータ（Annotatedによる詳細ドキュメント付き）
- **113-115行目**: デフォルトパラメータのコピーとカスタムパラメータのマージ
- **117-133行目**: HTMLテンプレートの基本部分生成
- **135-136行目**: Swagger UIパラメータをJSONとしてHTMLに埋め込み
- **138-139行目**: OAuth2リダイレクトURLの設定（存在する場合）
- **148-151行目**: OAuth2初期化設定の追加（存在する場合）
- **158行目**: HTMLResponseとして返却

### プログラム呼び出し階層図

```
FastAPI.__init__()
    │
    └─ FastAPI.setup()
           │
           ├─ openapi_url設定チェック
           │
           └─ swagger_ui_html() [内部関数]
                  │
                  └─ get_swagger_ui_html()
                         │
                         ├─ swagger_ui_default_parameters.copy()
                         ├─ current_swagger_ui_parameters.update()
                         ├─ HTMLテンプレート生成
                         ├─ jsonable_encoder() [パラメータのJSON変換]
                         └─ HTMLResponse()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

FastAPI設定                 FastAPI.setup()
- openapi_url ─────────────▶ ルート登録
- docs_url
- swagger_ui_parameters

HTTPリクエスト              swagger_ui_html()
- root_path ──────────────▶ URL構築

                            get_swagger_ui_html()
パラメータ ────────────────▶ HTMLテンプレート生成 ──────────▶ HTMLResponse
- openapi_url                                                (Swagger UI画面)
- title
- swagger_*_url
- oauth2_*
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| docs.py | `fastapi/openapi/docs.py` | ソース | Swagger UI HTML生成関数の定義 |
| applications.py | `fastapi/applications.py` | ソース | FastAPIアプリケーションクラス、setup()メソッド |
| encoders.py | `fastapi/encoders.py` | ソース | jsonable_encoder関数（パラメータのJSON変換） |
| responses.py | `starlette/responses.py` | 外部依存 | HTMLResponseクラス |
