# 機能設計書 22-ReDoc

## 概要

本ドキュメントは、FastAPIフレームワークが提供するReDoc APIドキュメント機能の設計について記載する。

### 本機能の処理概要

ReDocは、OpenAPI仕様に基づいた読みやすいAPIドキュメントを自動生成し、Webブラウザ上で閲覧可能にする機能である。Swagger UIとは異なりインタラクティブなAPI実行機能はないが、より洗練されたデザインで長文のAPI仕様書を読みやすく表示する。三カラムレイアウトにより、エンドポイント一覧、詳細説明、リクエスト/レスポンス例を同時に確認できる。

**業務上の目的・背景**：API仕様の閲覧に特化したドキュメントUIとして、Swagger UIの代替または補完として機能する。特に大規模なAPIを持つプロジェクトでは、ReDocの構造化されたナビゲーションとマークダウンレンダリング機能が有用である。外部パートナーや社内の非開発者向けにAPI仕様を共有する際にも適している。

**機能の利用シーン**：
- API仕様書としての閲覧・印刷
- 外部パートナーへのAPI仕様共有
- 社内ドキュメントとしての利用
- Swagger UIでの実行テストと併用した仕様確認

**主要な処理内容**：
1. FastAPIアプリケーション起動時にReDocエンドポイント（デフォルト: `/redoc`）を自動登録
2. OpenAPIスキーマURL（デフォルト: `/openapi.json`）を参照するHTMLページを動的生成
3. ReDoc JavaScriptライブラリをCDNまたはカスタムURLからロード
4. Google Fontsの読み込み（オプション、デフォルト有効）

**関連システム・外部連携**：
- CDN（jsdelivr.net）からのReDocアセット取得
- Google Fonts APIからのフォント取得（オプション）
- OpenAPIスキーマ生成機能との連携

**権限による制御**：本機能自体には認証・認可は設定されていないが、`redoc_url=None`の設定により無効化可能。本番環境での公開可否は要件に応じて判断する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | ReDoc | 主画面 | /redocエンドポイントで読みやすいAPIドキュメント画面を表示 |

## 機能種別

ドキュメント生成 / UI表示

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| openapi_url | str | Yes | OpenAPIスキーマのURL | 有効なURLパス形式 |
| title | str | Yes | HTMLページのタイトル | - |
| redoc_js_url | str | No | ReDoc JavaScriptのURL | デフォルト: CDN URL |
| redoc_favicon_url | str | No | ファビコンのURL | デフォルト: FastAPI公式URL |
| with_google_fonts | bool | No | Google Fontsを使用するか | デフォルト: True |

### 入力データソース

- FastAPIアプリケーション設定（タイトル、OpenAPI URL等）
- HTTPリクエスト（root_pathの取得）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| html | str | ReDoc表示用のHTMLコンテンツ |
| response | HTMLResponse | HTTPレスポンスオブジェクト |

### 出力先

- HTTPレスポンス（HTMLコンテンツ）

## 処理フロー

### 処理シーケンス

```
1. FastAPIアプリケーション初期化（setup()メソッド）
   └─ openapi_urlとredoc_urlが設定されている場合、ReDocルートを登録
2. クライアントからの/redocリクエスト受信
   └─ redoc_html関数が呼び出される
3. root_pathの取得
   └─ リクエストスコープからroot_pathを取得し、OpenAPI URLを構築
4. get_redoc_html関数の呼び出し
   └─ HTMLテンプレートの生成
5. HTMLResponseの返却
   └─ 生成されたHTMLをクライアントに返却
```

### フローチャート

```mermaid
flowchart TD
    A[クライアントが/redocにアクセス] --> B{openapi_url設定あり?}
    B -->|No| C[404エラー]
    B -->|Yes| D{redoc_url設定あり?}
    D -->|No| C
    D -->|Yes| E[root_pathを取得]
    E --> F[openapi_urlを構築]
    F --> G[get_redoc_html呼び出し]
    G --> H{with_google_fonts=True?}
    H -->|Yes| I[Google Fontsリンクを追加]
    H -->|No| J[HTMLテンプレート生成]
    I --> J
    J --> K[redocカスタム要素を追加]
    K --> L[HTMLResponse生成]
    L --> M[レスポンス返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-22-1 | OpenAPI URL必須 | ReDocを表示するにはopenapi_urlが設定されている必要がある | 常時 |
| BR-22-2 | redoc_url無効化 | redoc_url=Noneの場合、ReDocエンドポイントは登録されない | redoc_url=None時 |
| BR-22-3 | Google Fontsデフォルト有効 | with_google_fontsはデフォルトでTrueであり、Montserrat/Robotoフォントがロードされる | with_google_fonts=True時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本機能はデータベースアクセスを行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 404 Not Found | redoc_urlが無効化されている場合 | redoc_urlを適切に設定する |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし（本機能はステートレスなHTMLレスポンス生成のみ）

## パフォーマンス要件

- HTML生成は同期処理で即時完了
- CDNからのReDocアセット取得はクライアント側で実行
- Google Fontsの取得もクライアント側で実行

## セキュリティ考慮事項

- 機密性の高いAPIの場合、redoc_url=Noneに設定して無効化可能
- with_google_fonts=Falseに設定することで外部リソースへのアクセスを制限可能

## 備考

- ReDocのバージョンはCDN URLで指定（デフォルト: v2）
- ReDocはJavaScriptが無効な環境では表示できない（noscriptメッセージあり）
- 三カラムレイアウトにより大規模APIドキュメントの閲覧に適している

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

FastAPIアプリケーションのsetupメソッドでReDocルートがどのように登録されるかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | applications.py | `fastapi/applications.py` | setup()メソッドでのルート登録処理 |

**主要処理フロー**:
1. **1121-1130行目**: openapi_urlとredoc_urlが設定されている場合の処理
2. **1123-1127行目**: redoc_html関数の定義
3. **1130行目**: redoc_urlへのルート登録

#### Step 2: HTML生成処理を理解する

get_redoc_html関数の詳細な処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | docs.py | `fastapi/openapi/docs.py` | get_redoc_html関数の実装 |

**主要処理フロー**:
- **161-208行目**: 関数定義とパラメータ（Annotatedによる詳細ドキュメント付き）
- **219-227行目**: HTMLヘッダー部分の生成（viewport設定含む）
- **228-231行目**: Google Fontsのリンク追加（with_google_fonts=Trueの場合）
- **232-243行目**: CSSスタイル定義
- **244-249行目**: bodyとredocカスタム要素の生成
- **253行目**: HTMLResponseとして返却

**読解のコツ**: ReDocは`<redoc spec-url="..."></redoc>`というカスタム要素を使用する。これはReDocのJavaScriptライブラリが認識し、OpenAPIスキーマを取得して描画する。

### プログラム呼び出し階層図

```
FastAPI.__init__()
    │
    └─ FastAPI.setup()
           │
           ├─ openapi_url設定チェック
           │
           └─ redoc_html() [内部関数]
                  │
                  └─ get_redoc_html()
                         │
                         ├─ HTMLテンプレート生成
                         ├─ Google Fontsリンク追加（条件付き）
                         ├─ redocカスタム要素生成
                         └─ HTMLResponse()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

FastAPI設定                 FastAPI.setup()
- openapi_url ─────────────▶ ルート登録
- redoc_url

HTTPリクエスト              redoc_html()
- root_path ──────────────▶ URL構築

                            get_redoc_html()
パラメータ ────────────────▶ HTMLテンプレート生成 ──────────▶ HTMLResponse
- openapi_url                                                (ReDoc画面)
- title
- redoc_js_url
- with_google_fonts
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| docs.py | `fastapi/openapi/docs.py` | ソース | ReDoc HTML生成関数の定義 |
| applications.py | `fastapi/applications.py` | ソース | FastAPIアプリケーションクラス、setup()メソッド |
| responses.py | `starlette/responses.py` | 外部依存 | HTMLResponseクラス |
