# 機能設計書 23-OAuth2リダイレクト

## 概要

本ドキュメントは、FastAPIフレームワークが提供するSwagger UI向けOAuth2リダイレクト機能の設計について記載する。

### 本機能の処理概要

OAuth2リダイレクトは、Swagger UIでのOAuth2認証フローをサポートするためのリダイレクト処理を提供する機能である。OAuth2認証サーバーからの認証コードやトークンを受け取り、親ウィンドウ（Swagger UI）に認証情報を引き渡す役割を担う。

**業務上の目的・背景**：OAuth2認証を採用するAPIでは、認証フロー中にリダイレクトが発生する。Swagger UIから直接APIをテストする際、認証サーバーからのコールバックを適切に処理し、取得したトークンをSwagger UIに渡す必要がある。本機能はこのリダイレクト処理を標準化し、開発者がOAuth2保護されたAPIをSwagger UI上でテストできるようにする。

**機能の利用シーン**：
- Swagger UI上でOAuth2認証が必要なAPIをテストする際
- Authorization Code FlowやImplicit Flowでの認証後のコールバック処理
- 認証サーバーからのエラーレスポンス処理

**主要な処理内容**：
1. FastAPIアプリケーション起動時にOAuth2リダイレクトエンドポイント（デフォルト: `/docs/oauth2-redirect`）を自動登録
2. 認証サーバーからのリダイレクト時、URLフラグメントまたはクエリパラメータから認証情報を抽出
3. 親ウィンドウ（Swagger UI）のOAuth2オブジェクトにコールバックを通知
4. 認証成功/失敗の結果をSwagger UIに伝達

**関連システム・外部連携**：
- OAuth2認証サーバー（Authorization Server）
- Swagger UI（親ウィンドウ）
- OpenAPIスキーマ生成機能

**権限による制御**：本機能自体には認証・認可は設定されていない。swagger_ui_oauth2_redirect_url=Noneの設定により無効化可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | OAuth2リダイレクト | 主画面 | Swagger UIからのOAuth2認証フローで使用されるリダイレクト画面 |

## 機能種別

認証連携 / リダイレクト処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| (URLフラグメント) code | str | 条件付き | 認証コード（Authorization Code Flow） | - |
| (URLフラグメント) token | str | 条件付き | アクセストークン（Implicit Flow） | - |
| (URLフラグメント) error | str | 条件付き | エラーコード | - |
| (URLフラグメント) error_description | str | No | エラー詳細 | - |
| (URLフラグメント) error_uri | str | No | エラー情報URI | - |
| (URLフラグメント) state | str | Yes | CSRF対策用ステート値 | - |

### 入力データソース

- URLフラグメント（#以降）またはクエリパラメータ（?以降）
- 親ウィンドウ（Swagger UI）のswaggerUIRedirectOauth2オブジェクト

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| html | str | OAuth2リダイレクト処理用のHTMLコンテンツ |
| response | HTMLResponse | HTTPレスポンスオブジェクト |

### 出力先

- HTTPレスポンス（HTMLコンテンツ / JavaScript実行）
- 親ウィンドウへのコールバック通知

## 処理フロー

### 処理シーケンス

```
1. FastAPIアプリケーション初期化（setup()メソッド）
   └─ swagger_ui_oauth2_redirect_urlが設定されている場合、リダイレクトルートを登録
2. OAuth2認証サーバーからのリダイレクト受信
   └─ swagger_ui_redirect関数が呼び出される
3. get_swagger_ui_oauth2_redirect_html関数の呼び出し
   └─ JavaScriptを含むHTMLを生成
4. クライアントブラウザでJavaScript実行
   └─ URLフラグメント/クエリパラメータの解析
5. ステート検証
   └─ 送信時のstateと受信時のstateを比較
6. 認証フロー種別の判定
   └─ Authorization Code Flow か Implicit Flow かを判定
7. 親ウィンドウへのコールバック
   └─ oauth2.callback()またはoauth2.errCb()を呼び出し
8. ウィンドウのクローズ
   └─ window.close()でリダイレクトウィンドウを閉じる
```

### フローチャート

```mermaid
flowchart TD
    A[認証サーバーからリダイレクト] --> B[HTMLレスポンス返却]
    B --> C[JavaScript実行]
    C --> D{URLにcode/token/errorあり?}
    D -->|フラグメント| E[フラグメントから解析]
    D -->|クエリ| F[クエリパラメータから解析]
    E --> G[JSONとしてパース]
    F --> G
    G --> H{state一致?}
    H -->|No| I[警告コールバック]
    H -->|Yes| J{フロー種別判定}
    J -->|Authorization Code Flow| K{codeあり?}
    K -->|Yes| L[callback: auth.code設定]
    K -->|No| M{errorあり?}
    M -->|Yes| N[errCb: エラー通知]
    M -->|No| O[errCb: 汎用エラー]
    J -->|Implicit/Other| P[callback: token設定]
    I --> Q[window.close]
    L --> Q
    N --> Q
    O --> Q
    P --> Q
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-23-1 | ステート検証 | 認証リクエスト時に送信したstateと、レスポンスで受信したstateが一致する必要がある | 常時 |
| BR-23-2 | Authorization Code Flow判定 | flow種別がaccessCode、authorizationCode、authorization_codeのいずれかの場合 | OAuth2フロー実行時 |
| BR-23-3 | エラー優先 | codeがない場合、errorの有無をチェックしエラーメッセージを構築 | Authorization Code Flow時 |
| BR-23-4 | ウィンドウクローズ | 処理完了後は必ずリダイレクトウィンドウを閉じる | 常時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本機能はデータベースアクセスを行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | auth/warning | stateが一致しない | ユーザーに警告を表示、認証をやり直す |
| error値 | auth/error | 認証サーバーがエラーを返した | エラー詳細を表示、認証設定を確認 |
| - | auth/error | codeもerrorもない | 認証サーバーの設定を確認 |

### リトライ仕様

該当なし（エラー時は手動で認証をやり直す）

## トランザクション仕様

該当なし（本機能はステートレスなリダイレクト処理のみ）

## パフォーマンス要件

- HTML生成は同期処理で即時完了
- JavaScript処理はクライアント側で即時実行

## セキュリティ考慮事項

- **CSRF対策**：stateパラメータによる検証を実施
- **情報漏洩防止**：トークン等の機密情報はURLフラグメントで受け取り、サーバーログに残らないようにする
- **親ウィンドウ検証**：window.openerの存在を前提としており、直接アクセスされた場合はエラーとなる

## 備考

- 本機能のJavaScriptコードはSwagger UI公式のoauth2-redirect.html（v4.14.0）をベースにしている
- Authorization Code Flow、Implicit Flow、およびその他のフローに対応

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: エントリーポイントを理解する

FastAPIアプリケーションのsetupメソッドでOAuth2リダイレクトルートがどのように登録されるかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | applications.py | `fastapi/applications.py` | setup()メソッドでのルート登録処理 |

**主要処理フロー**:
1. **1111-1120行目**: swagger_ui_oauth2_redirect_urlが設定されている場合の処理
2. **1113-1114行目**: swagger_ui_redirect関数の定義
3. **1116-1120行目**: swagger_ui_oauth2_redirect_urlへのルート登録

#### Step 2: HTML/JavaScript生成処理を理解する

get_swagger_ui_oauth2_redirect_html関数の詳細な処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | docs.py | `fastapi/openapi/docs.py` | get_swagger_ui_oauth2_redirect_html関数の実装 |

**主要処理フロー**:
- **256-261行目**: 関数定義とドキュメント
- **262-263行目**: コードの出典コメント
- **270-273行目**: 親ウィンドウのOAuth2オブジェクト取得
- **278-281行目**: URLフラグメントまたはクエリパラメータからの解析
- **284-290行目**: クエリパラメータのJSONパース
- **292行目**: ステート検証
- **294-298行目**: Authorization Code Flow判定
- **299-306行目**: ステート不一致時の警告
- **308-326行目**: codeまたはerrorの処理
- **327-328行目**: Implicit/その他フローの処理
- **330行目**: ウィンドウクローズ
- **333-338行目**: DOMContentLoaded対応
- **344行目**: HTMLResponseとして返却

**読解のコツ**: JavaScriptコードはSwagger UIの公式実装に基づいている。`window.opener.swaggerUIRedirectOauth2`が親ウィンドウのOAuth2状態管理オブジェクトを参照する。

### プログラム呼び出し階層図

```
FastAPI.__init__()
    │
    └─ FastAPI.setup()
           │
           ├─ swagger_ui_oauth2_redirect_url設定チェック
           │
           └─ swagger_ui_redirect() [内部関数]
                  │
                  └─ get_swagger_ui_oauth2_redirect_html()
                         │
                         └─ HTMLResponse()
                                │
                                └─ [クライアント側JavaScript実行]
                                       │
                                       ├─ URLパラメータ解析
                                       ├─ ステート検証
                                       ├─ oauth2.callback() または oauth2.errCb()
                                       └─ window.close()
```

### データフロー図

```
[入力]                          [処理]                        [出力]

認証サーバーからの
リダイレクト
- code/token ─────────────────▶ JavaScript解析
- state                         ↓
- error                         ステート検証
                                ↓
                                フロー判定
                                ↓
                            親ウィンドウ
                            コールバック ────────────────▶ Swagger UI
                                ↓                         (トークン保持)
                            window.close()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| docs.py | `fastapi/openapi/docs.py` | ソース | OAuth2リダイレクトHTML生成関数の定義 |
| applications.py | `fastapi/applications.py` | ソース | FastAPIアプリケーションクラス、setup()メソッド |
| oauth2.py | `fastapi/security/oauth2.py` | ソース | OAuth2認証スキームの定義（関連） |
| responses.py | `starlette/responses.py` | 外部依存 | HTMLResponseクラス |
