# 機能設計書 25-WebSocketException

## 概要

本ドキュメントは、FastAPIフレームワークが提供するWebSocketException例外クラスの設計について記載する。

### 本機能の処理概要

WebSocketExceptionは、WebSocket接続においてエラーを通知し、接続を終了させるために使用する例外クラスである。開発者はこの例外をraiseすることで、WebSocket仕様に準拠したクローズコードとクローズ理由を指定して接続を終了できる。

**業務上の目的・背景**：WebSocket通信において、クライアント側のエラー（認証失敗、不正なデータ、ポリシー違反等）を検知した場合、適切なクローズコードとともに接続を終了する必要がある。WebSocketExceptionは、RFC 6455で定義されたクローズコードを使用して、クライアントにエラーの種類を通知する標準的な方法を提供する。

**機能の利用シーン**：
- WebSocket接続時の認証失敗
- 不正なメッセージ形式の受信
- ポリシー違反の検出
- リソース制限の超過
- セッションタイムアウト

**主要な処理内容**：
1. WebSocketExceptionインスタンスの生成（code、reasonの設定）
2. 例外のraise
3. FastAPIのミドルウェア/ルーティングによるキャッチ
4. WebSocket接続の適切なクローズ

**関連システム・外部連携**：
- StarletteのWebSocketException（基底クラス）
- WebSocket接続管理機能

**権限による制御**：本機能自体は例外クラスの定義であり、権限制御は含まれない。認証・認可エラーを通知する手段として使用される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | WebSocket通信全般のエラー処理に使用 |

## 機能種別

例外処理 / WebSocket接続管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| code | int | Yes | WebSocketクローズコード（RFC 6455準拠） | 有効なクローズコード |
| reason | Union[str, None] | No | クローズ理由（UTF-8エンコード） | デフォルト: None |

### 入力データソース

- 開発者がWebSocketエンドポイント関数内で明示的に指定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| code | int | WebSocketクローズコード |
| reason | str | クローズ理由 |

### 出力先

- WebSocket接続クローズフレーム

## 処理フロー

### 処理シーケンス

```
1. 開発者がWebSocketエンドポイント関数内でWebSocketExceptionをraise
   └─ code、reasonを指定
2. FastAPIのルーティング/ミドルウェアがキャッチ
   └─ WebSocket接続のクローズ処理を実行
3. クローズフレームの送信
   └─ 指定されたcodeとreasonでWebSocket接続をクローズ
4. 接続終了
   └─ クライアントとの接続が切断される
```

### フローチャート

```mermaid
flowchart TD
    A[WebSocketエンドポイント実行] --> B{エラー条件発生?}
    B -->|No| C[正常処理継続]
    B -->|Yes| D[WebSocketException raise]
    D --> E[FastAPIがキャッチ]
    E --> F[WebSocket.close呼び出し]
    F --> G[クローズフレーム送信]
    G --> H[接続終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-25-1 | RFC 6455準拠 | codeはRFC 6455で定義されたクローズコードを使用すべき | 常時 |
| BR-25-2 | reason文字数制限 | reasonはUTF-8で125バイト以下が推奨 | WebSocket仕様 |
| BR-25-3 | 一般的なコード | 1008（Policy Violation）は認証エラー等に使用 | 認証失敗時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本機能はデータベースアクセスを行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1000 | Normal Closure | 正常終了 | - |
| 1001 | Going Away | サーバーシャットダウン | 再接続を試行 |
| 1002 | Protocol Error | プロトコルエラー | クライアント実装を確認 |
| 1003 | Unsupported Data | サポートされないデータ型 | データ形式を確認 |
| 1008 | Policy Violation | ポリシー違反（認証失敗等） | 認証情報を確認 |
| 1011 | Internal Error | サーバー内部エラー | サーバーログを確認 |

### リトライ仕様

該当なし（例外定義のためリトライロジックは含まれない）

## トランザクション仕様

該当なし

## パフォーマンス要件

- 例外生成とハンドリングは即時完了

## セキュリティ考慮事項

- reasonに機密情報（内部パス、スタックトレース等）を含めないよう注意
- 認証エラー時は詳細な理由を公開しない（1008コードのみを使用）

## 備考

- WebSocketExceptionはStarletteのWebSocketExceptionを継承
- status.WS_1008_POLICY_VIOLATIONなどの定数が利用可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

WebSocketException例外クラスの定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | exceptions.py | `fastapi/exceptions.py` | WebSocketExceptionクラスの定義 |

**主要処理フロー**:
- **76-144行目**: WebSocketExceptionクラス定義
- **77-116行目**: クラスドキュメント（使用例含む）
- **118-144行目**: __init__メソッド（code、reason）

**読解のコツ**: WebSocketExceptionはStarletteのWebSocketExceptionを継承している。Annotatedによるパラメータドキュメントが詳細に記載されており、RFC 6455への参照も含まれている。

#### Step 2: WebSocket接続管理を理解する

WebSocketクラスとその接続管理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | websockets.py | `fastapi/websockets.py` | WebSocket関連のインポート |

**主要処理フロー**:
- **1-3行目**: StarletteからのWebSocket、WebSocketDisconnect、WebSocketStateのインポート

**読解のコツ**: FastAPIのWebSocket機能はStarletteに委譲されている。詳細な実装はstarlette.websocketsを参照。

#### Step 3: ルーティングでのWebSocket処理を理解する

WebSocketルートでの例外処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | routing.py | `fastapi/routing.py` | APIWebSocketRouteクラス |

**主要処理フロー**:
- **443行目付近**: APIWebSocketRouteクラス定義
- **406-440行目**: get_websocket_app関数

### プログラム呼び出し階層図

```
WebSocketエンドポイント関数
    │
    └─ raise WebSocketException(code, reason)
           │
           └─ [FastAPIルーティング/ミドルウェア]
                  │
                  └─ WebSocket.close(code, reason)
                         │
                         └─ クローズフレーム送信
                                │
                                └─ 接続終了
```

### データフロー図

```
[入力]                      [処理]                           [出力]

raise WebSocketException    FastAPIハンドリング
- code ────────────────────▶ WebSocket.close ───────────────▶ クローズフレーム
- reason                     ↓                              - code
                            接続終了                         - reason
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| exceptions.py | `fastapi/exceptions.py` | ソース | WebSocketException例外クラスの定義 |
| websockets.py | `fastapi/websockets.py` | ソース | WebSocket関連クラスのインポート |
| routing.py | `fastapi/routing.py` | ソース | APIWebSocketRouteクラス |
| websockets.py | `starlette/websockets.py` | 外部依存 | WebSocketクラスの実装 |
| exceptions.py | `starlette/exceptions.py` | 外部依存 | StarletteWebSocketException（基底クラス） |
| status.py | `starlette/status.py` | 外部依存 | WebSocketステータスコード定数 |
