# 機能設計書 27-ResponseValidationError

## 概要

本ドキュメントは、FastAPIフレームワークが提供するResponseValidationError例外クラスの設計について記載する。

### 本機能の処理概要

ResponseValidationErrorは、レスポンスデータのバリデーションに失敗した際に発生する例外クラスである。エンドポイント関数が返却するデータが、定義されたresponse_model（Pydanticモデル）の制約に適合しない場合に発生する。主に開発時のデバッグ目的で使用される。

**業務上の目的・背景**：APIレスポンスがスキーマ定義と一致することを保証することは、APIの信頼性とクライアント互換性の観点から重要である。ResponseValidationErrorは、エンドポイント関数が期待されるスキーマと異なるデータを返却した場合に開発者に通知し、本番環境へのデプロイ前にバグを発見する機会を提供する。

**機能の利用シーン**：
- response_modelで定義したフィールドが欠落している場合
- フィールドのデータ型が一致しない場合
- 必須フィールドがNoneの場合
- カスタムバリデータがエラーを返した場合
- データベースから取得したデータがモデル定義と不一致の場合

**主要な処理内容**：
1. エンドポイント関数のレスポンスデータをresponse_modelでバリデーション
2. バリデーションエラーの検出
3. ResponseValidationErrorインスタンスの生成（エラーリスト、ボディ、エンドポイントコンテキスト）
4. 例外の発生（開発時のデバッグ用）

**関連システム・外部連携**：
- Pydanticバリデーション機能
- FastAPIレスポンス処理機能

**権限による制御**：本機能自体は例外クラスの定義であり、権限制御は含まれない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | API開発時のレスポンスバリデーションエラー検出に使用 |

## 機能種別

例外処理 / バリデーション / デバッグ支援

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| errors | Sequence[Any] | Yes | バリデーションエラーのリスト | - |
| body | Any | No | レスポンスボディ（参照用） | デフォルト: None |
| endpoint_ctx | Optional[EndpointContext] | No | エンドポイントのコンテキスト情報 | デフォルト: None |

### 入力データソース

- Pydanticバリデーションエラー
- FastAPIレスポンス処理

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| errors | Sequence[Any] | バリデーションエラーの詳細リスト |
| body | Any | 問題のあったレスポンスボディ |
| endpoint_ctx | EndpointContext | エンドポイント情報（関数名、パス、ファイル、行番号） |

### 出力先

- 例外として発生（キャッチしなければサーバーエラーとなる）

## 処理フロー

### 処理シーケンス

```
1. エンドポイント関数実行
   └─ レスポンスデータを返却
2. FastAPIによるレスポンスバリデーション
   └─ response_modelでの型変換・制約検証
3. バリデーションエラー検出
   └─ エラーがある場合、ResponseValidationErrorを生成
4. 例外発生
   └─ デフォルトではサーバーエラー（500）として処理
```

### フローチャート

```mermaid
flowchart TD
    A[エンドポイント関数実行] --> B[レスポンスデータ返却]
    B --> C{response_model定義あり?}
    C -->|No| D[レスポンスそのまま返却]
    C -->|Yes| E[Pydanticバリデーション実行]
    E --> F{バリデーション成功?}
    F -->|Yes| G[バリデート済みデータでレスポンス生成]
    F -->|No| H[ResponseValidationError raise]
    H --> I{カスタムハンドラあり?}
    I -->|Yes| J[カスタムハンドラ実行]
    I -->|No| K[500 Internal Server Error]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-27-1 | デバッグ用途 | ResponseValidationErrorは主に開発・デバッグ時に使用 | 開発時 |
| BR-27-2 | デフォルトハンドラなし | FastAPIはResponseValidationError用のデフォルト例外ハンドラを提供しない | 常時 |
| BR-27-3 | エンドポイントコンテキスト | デバッグ用にエンドポイントのファイル・行番号情報を保持 | 例外発生時 |
| BR-27-4 | 本番環境での注意 | 本番環境ではResponseValidationErrorが発生しないようにテストすべき | 本番デプロイ前 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本機能はデータベースアクセスを行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 500 | Internal Server Error | レスポンスバリデーション失敗（デフォルト） | エンドポイント関数の返却値を修正 |

### リトライ仕様

該当なし（サーバー側のバグのため、コード修正が必要）

## トランザクション仕様

該当なし

## パフォーマンス要件

- バリデーション処理は同期的に実行され即時完了

## セキュリティ考慮事項

- 本番環境では詳細なエラー情報（スタックトレース、内部データ）がクライアントに露出しないよう注意
- カスタム例外ハンドラで適切なエラーレスポンスを生成することを推奨

## 備考

- ValidationExceptionクラスを継承
- body属性でレスポンスボディへの参照を保持
- endpoint_ctx属性でエンドポイントのコンテキスト情報（関数名、パス、ファイル、行番号）を保持
- RequestValidationErrorとは異なり、デフォルト例外ハンドラが登録されていない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ValidationExceptionとResponseValidationErrorの継承関係と構造を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | exceptions.py | `fastapi/exceptions.py` | ValidationException基底クラス |
| 1-2 | exceptions.py | `fastapi/exceptions.py` | ResponseValidationErrorクラス |

**主要処理フロー**:
- **164-200行目**: ValidationException基底クラス
- **224-234行目**: ResponseValidationErrorクラス定義
- **225-234行目**: __init__メソッド（errors、body、endpoint_ctx）

**読解のコツ**: ResponseValidationErrorはValidationExceptionを継承し、RequestValidationErrorと同様にbody属性を持つ。構造はRequestValidationErrorとほぼ同一だが、用途が異なる（リクエストではなくレスポンスのバリデーション）。

#### Step 2: レスポンスバリデーション処理を理解する

ルーティング処理でのレスポンスバリデーションを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | routing.py | `fastapi/routing.py` | レスポンス処理時のバリデーション |

**読解のコツ**: routing.pyは大きなファイルのため、ResponseValidationErrorのインポートと使用箇所を検索して確認するとよい。

### プログラム呼び出し階層図

```
エンドポイント関数
    │
    └─ レスポンスデータ返却
           │
           └─ FastAPIレスポンス処理
                  │
                  ├─ response_modelでバリデーション
                  │      │
                  │      └─ Pydanticバリデーション
                  │
                  └─ バリデーションエラー発生
                         │
                         └─ raise ResponseValidationError(errors, body, endpoint_ctx)
                                │
                                └─ [デフォルトハンドラなし]
                                       │
                                       └─ 500 Internal Server Error
```

### データフロー図

```
[入力]                      [処理]                           [出力]

エンドポイント関数          response_modelバリデーション
- return value ────────────▶ Pydanticバリデーション
                             ↓
                            バリデーションエラー検出
                             ↓
                            ResponseValidationError
                             ↓
                            [カスタムハンドラ or 500エラー]
                             ↓
                            レスポンス ──────────────────▶ HTTPレスポンス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| exceptions.py | `fastapi/exceptions.py` | ソース | ValidationException、ResponseValidationErrorクラス定義 |
| routing.py | `fastapi/routing.py` | ソース | レスポンスバリデーション処理 |
| encoders.py | `fastapi/encoders.py` | ソース | jsonable_encoder関数 |
