# 機能設計書 29-WebSocket接続

## 概要

本ドキュメントは、FastAPIフレームワークが提供するWebSocket接続機能の設計について記載する。

### 本機能の処理概要

WebSocket接続機能は、HTTPプロトコルを拡張した双方向リアルタイム通信を実現する機能である。FastAPIはStarletteのWebSocketクラスを活用し、接続の確立、メッセージの送受信、接続の終了を管理する。@app.websocketデコレータにより、WebSocketエンドポイントを簡単に定義できる。

**業務上の目的・背景**：リアルタイム性が求められるアプリケーション（チャット、通知、ライブ更新、ゲーム等）では、従来のHTTPリクエスト/レスポンスモデルでは効率的な通信が困難である。WebSocketは、単一のTCP接続上で双方向通信を可能にし、低遅延・低オーバーヘッドのリアルタイム通信を実現する。

**機能の利用シーン**：
- リアルタイムチャットアプリケーション
- ライブ通知システム
- ダッシュボードのリアルタイム更新
- オンラインゲームの状態同期
- IoTデバイスとのリアルタイム通信

**主要な処理内容**：
1. WebSocketエンドポイントの定義（@app.websocketデコレータ）
2. クライアントからの接続要求受付
3. 接続の確立（accept）
4. メッセージの送受信（テキスト、バイナリ、JSON）
5. 接続のクローズ

**関連システム・外部連携**：
- StarletteのWebSocketクラス
- FastAPI依存性注入システム
- WebSocketバリデーション

**権限による制御**：WebSocket接続時に認証・認可を実装可能（Cookie、クエリパラメータ、ヘッダー経由）。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | リアルタイム通信を必要とする画面全般で使用 |

## 機能種別

リアルタイム通信 / 双方向メッセージング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| websocket | WebSocket | Yes | WebSocket接続オブジェクト | - |
| (パスパラメータ) | 任意 | No | URLパスからのパラメータ | 型変換・バリデーション |
| (クエリパラメータ) | 任意 | No | クエリ文字列からのパラメータ | 型変換・バリデーション |
| (ヘッダー) | 任意 | No | HTTPヘッダーからの値 | 型変換・バリデーション |
| (Cookie) | 任意 | No | Cookieからの値 | 型変換・バリデーション |

### 入力データソース

- クライアントからのWebSocket接続要求
- URLパス、クエリパラメータ、ヘッダー、Cookie

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| テキストメッセージ | str | send_text()で送信 |
| バイナリメッセージ | bytes | send_bytes()で送信 |
| JSONメッセージ | dict/list | send_json()で送信 |

### 出力先

- WebSocket接続を通じてクライアントへ送信

## 処理フロー

### 処理シーケンス

```
1. クライアントからWebSocket接続要求
   └─ ws://またはwss://プロトコルでアクセス
2. FastAPIルーティングによるエンドポイントマッチング
   └─ APIWebSocketRouteで処理
3. 依存性解決・パラメータバリデーション
   └─ パスパラメータ、クエリ、ヘッダー、Cookieの取得・検証
4. WebSocketエンドポイント関数の実行
   └─ websocket.accept()で接続確立
5. メッセージ送受信ループ
   └─ receive_text/bytes/json、send_text/bytes/json
6. 接続終了
   └─ websocket.close()またはクライアント切断
```

### フローチャート

```mermaid
flowchart TD
    A[クライアント接続要求] --> B[ルーティングマッチング]
    B --> C[APIWebSocketRoute処理]
    C --> D[依存性解決・バリデーション]
    D --> E{バリデーション成功?}
    E -->|No| F[WebSocketRequestValidationError]
    F --> G[接続クローズ 1008]
    E -->|Yes| H[エンドポイント関数実行]
    H --> I[websocket.accept]
    I --> J[接続確立]
    J --> K{メッセージ受信?}
    K -->|Yes| L[メッセージ処理]
    L --> M[レスポンス送信]
    M --> K
    K -->|切断検出| N[WebSocketDisconnect]
    N --> O[接続終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-29-1 | 接続確立必須 | メッセージ送受信前にwebsocket.accept()を呼び出す必要がある | 常時 |
| BR-29-2 | バリデーションエラー時 | パラメータバリデーションエラー時は1008コードで接続クローズ | バリデーション失敗時 |
| BR-29-3 | 非同期必須 | WebSocketエンドポイント関数は非同期関数(async def)である必要がある | 常時 |
| BR-29-4 | 依存性注入対応 | HTTP エンドポイントと同様にDependsによる依存性注入が利用可能 | 常時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本機能自体はデータベースアクセスを行わないが、エンドポイント内で実装可能）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1000 | Normal Closure | 正常終了 | - |
| 1001 | Going Away | サーバーシャットダウン | 再接続を試行 |
| 1008 | Policy Violation | バリデーションエラー | パラメータを修正 |
| 1011 | Internal Error | サーバー内部エラー | サーバーログを確認 |

### リトライ仕様

クライアント側で再接続ロジックを実装する（指数バックオフ推奨）

## トランザクション仕様

該当なし（WebSocketはステートフルな接続であり、トランザクション管理はアプリケーション層で実装）

## パフォーマンス要件

- 接続確立は即時完了
- メッセージ送受信は低遅延で処理
- 大量の同時接続をサポートするにはイベントループの適切な活用が必要

## セキュリティ考慮事項

- WebSocket接続時の認証を実装すること（Cookie、トークン等）
- wss://（WebSocket Secure）の使用を推奨
- 入力データのサニタイズを行うこと
- 接続タイムアウトを設定すること

## 備考

- WebSocketクラスはStarletteから再エクスポートされている
- WebSocketStateで接続状態（CONNECTING、CONNECTED、DISCONNECTED）を管理
- WebSocketDisconnect例外でクライアント切断を検出可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

WebSocket関連クラスの定義を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | websockets.py | `fastapi/websockets.py` | WebSocket関連クラスのインポート |

**主要処理フロー**:
- **1行目**: StarletteのWebSocketクラスをインポート
- **2行目**: WebSocketDisconnect例外をインポート
- **3行目**: WebSocketStateをインポート

**読解のコツ**: FastAPIのWebSocket機能はStarletteに完全に委譲されている。詳細な実装はstarlette.websocketsを参照する必要がある。

#### Step 2: ルーティングを理解する

WebSocketルートの定義と処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | routing.py | `fastapi/routing.py` | APIWebSocketRouteクラス |
| 2-2 | routing.py | `fastapi/routing.py` | websocket_session関数 |
| 2-3 | routing.py | `fastapi/routing.py` | get_websocket_app関数 |

**主要処理フロー**:
- **122-145行目**: websocket_session関数（ASGIアプリケーション生成）
- **130-131行目**: WebSocketインスタンス生成
- **133-141行目**: AsyncExitStackを使用したリソース管理
- **406-440行目**: get_websocket_app関数（依存性解決とエンドポイント呼び出し）
- **411-412行目**: WebSocketアプリ関数定義
- **428-431行目**: 依存性解決
- **432-436行目**: バリデーションエラー時の処理
- **437-438行目**: エンドポイント関数の呼び出し
- **443-476行目**: APIWebSocketRouteクラス
- **470-476行目**: websocket_sessionでアプリを構築

#### Step 3: デコレータを理解する

WebSocketエンドポイント定義のデコレータを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | routing.py | `fastapi/routing.py` | websocketデコレータ |
| 3-2 | routing.py | `fastapi/routing.py` | add_api_websocket_route関数 |

**主要処理フロー**:
- **1115-1180行目**: websocketデコレータの定義
- **1174-1178行目**: デコレータ本体（add_api_websocket_routeを呼び出し）
- **1094-1113行目**: add_api_websocket_route関数（ルート追加）
- **1106-1112行目**: APIWebSocketRouteインスタンス生成

### プログラム呼び出し階層図

```
@app.websocket("/ws")
    │
    └─ APIRouter.websocket() [デコレータ]
           │
           └─ APIRouter.add_api_websocket_route()
                  │
                  └─ APIWebSocketRoute.__init__()
                         │
                         ├─ Dependantの構築
                         │
                         └─ websocket_session()
                                │
                                └─ get_websocket_app()
                                       │
                                       └─ WebSocket接続処理
                                              │
                                              ├─ 依存性解決
                                              ├─ バリデーション
                                              └─ エンドポイント関数呼び出し
```

### データフロー図

```
[入力]                          [処理]                        [出力]

クライアント接続要求           APIWebSocketRoute
- ws://host/path ────────────▶ websocket_session
                                ↓
                               WebSocket生成
                                ↓
                               get_websocket_app
                                ↓
                               依存性解決
                                ↓
                               バリデーション
                                ↓
                               エンドポイント関数
                                ↓
メッセージ送受信               websocket.accept() ──────────▶ 接続確立
- receive_text/bytes/json ◀───▶ websocket.send_* ──────────▶ クライアント
                                ↓
クライアント切断 ─────────────▶ WebSocketDisconnect ────────▶ 接続終了
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| websockets.py | `fastapi/websockets.py` | ソース | WebSocket関連クラスのインポート |
| routing.py | `fastapi/routing.py` | ソース | APIWebSocketRoute、websocket_session、get_websocket_app |
| exceptions.py | `fastapi/exceptions.py` | ソース | WebSocketRequestValidationError |
| dependencies/utils.py | `fastapi/dependencies/utils.py` | ソース | 依存性解決 |
| websockets.py | `starlette/websockets.py` | 外部依存 | WebSocket、WebSocketDisconnect、WebSocketState |
