# 機能設計書 33-UploadFile

## 概要

本ドキュメントは、FastAPIのUploadFile機能について、その設計意図、処理フロー、実装詳細を記述した機能設計書である。

### 本機能の処理概要

UploadFileは、HTTPリクエストでアップロードされたファイルを扱うためのクラスである。ファイル名、サイズ、コンテンツタイプなどのメタデータと、非同期でのファイル読み書きメソッドを提供する。

**業務上の目的・背景**：Webアプリケーションにおいてファイルアップロード機能は一般的な要件である。UploadFileクラスは、アップロードされたファイルのメタデータへのアクセスと、大容量ファイルでも効率的に処理できる非同期I/O操作を提供することで、開発者が容易にファイルアップロード機能を実装できるようにする。

**機能の利用シーン**：
- ユーザープロフィール画像のアップロード
- ドキュメントファイルの受付
- データインポート用CSVファイルのアップロード
- 画像・動画コンテンツの投稿

**主要な処理内容**：
1. エンドポイント関数のパラメータとしてUploadFileを受け取る
2. ファイルメタデータ（filename、size、content_type、headers）へのアクセス
3. 非同期メソッド（read、write、seek、close）によるファイル操作
4. Pydanticとの統合によるバリデーション

**関連システム・外部連携**：ストレージサービス（S3、GCS等）、データベースへのファイルパス保存

**権限による制御**：UploadFile自体には権限制御機能はない。エンドポイントレベルで実装する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | UploadFileは画面を持たないバックエンド機能 |

## 機能種別

データ受信 / ファイル処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| file | BinaryIO | Yes | 標準Pythonファイルオブジェクト（非同期対応） | なし |
| filename | Optional[str] | No | 元のファイル名 | なし |
| size | Optional[int] | No | ファイルサイズ（バイト） | なし |
| headers | Headers | Yes | リクエストヘッダー | なし |
| content_type | Optional[str] | No | コンテンツタイプ（MIME型） | なし |

### 入力データソース

- HTTPリクエストのmultipart/form-dataボディ
- クライアントがアップロードしたファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| read() | bytes | 読み込んだファイルの内容（バイト列） |
| filename | str | ファイル名 |
| size | int | ファイルサイズ |
| content_type | str | コンテンツタイプ |

### 出力先

- read()メソッドで取得したデータを任意の出力先（ストレージ、データベース等）に保存

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信
   └─ multipart/form-dataとしてファイルを受信
2. UploadFileオブジェクト生成
   └─ Starletteがファイルデータをパースし、UploadFileインスタンスを作成
3. エンドポイント関数でファイル操作
   ├─ filename、size等のメタデータ取得
   └─ read()でファイル内容を取得
4. ファイル保存・処理
   └─ 開発者が任意の処理を実装
5. クリーンアップ
   └─ close()でファイルハンドルを解放
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B[multipart/form-data解析]
    B --> C[UploadFileオブジェクト生成]
    C --> D[エンドポイント関数呼び出し]
    D --> E{ファイル操作}
    E --> F[read: ファイル内容取得]
    E --> G[filename: ファイル名取得]
    E --> H[size: サイズ取得]
    F --> I[ファイル保存・処理]
    I --> J[close: クリーンアップ]
    J --> K[レスポンス送信]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-33-001 | 非同期I/O | read/write/seek/closeは非同期メソッド | すべてのファイル操作 |
| BR-33-002 | SpooledTemporaryFile | デフォルトでSpooledTemporaryFileを使用 | python-multipart使用時 |
| BR-33-003 | ブロッキング操作 | 同期コード用にfile属性で標準ファイルオブジェクト取得可能 | 同期関数での使用時 |

### 計算ロジック

計算ロジックは特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | UploadFile自体はDB操作を行わない |

### テーブル別操作詳細

UploadFileはデータベース操作機能を持たない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ValueError | StarletteUploadFile以外のオブジェクトを_validateに渡した | 正しいUploadFileオブジェクトを使用 |
| - | RuntimeError | python-multipartがインストールされていない | pip install python-multipart |

### リトライ仕様

リトライ機能は提供しない。

## トランザクション仕様

トランザクション管理は不要。

## パフォーマンス要件

- 非同期I/Oによりスレッドプールで実行されるため、同期処理をブロックしない
- 大容量ファイルはストリーミング処理を推奨
- SpooledTemporaryFileにより小さいファイルはメモリ上で処理

## セキュリティ考慮事項

- ファイル名のサニタイズ（パストラバーサル対策）
- ファイルサイズの制限
- コンテンツタイプの検証
- ウイルススキャンの実装検討

## 備考

- StarletteのUploadFileクラスを継承
- Pydanticバリデーションとの統合（__get_pydantic_core_schema__）
- OpenAPIスキーマでは`{"type": "string", "format": "binary"}`として表現

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

UploadFileクラスの属性とメソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | datastructures.py | `fastapi/datastructures.py` | UploadFileクラス定義（23-153行目） |

**読解のコツ**:
- `Annotated`と`Doc`はドキュメント生成のためのメタデータ
- 各属性（file、filename、size、headers、content_type）の型と説明を確認

**主要処理フロー**:
1. **23行目**: `UploadFile`クラスがStarletteの`StarletteUploadFile`を継承
2. **57-66行目**: 属性定義（file、filename、size、headers、content_type）
3. **68-86行目**: `write`メソッド - バイト列をファイルに書き込み
4. **88-104行目**: `read`メソッド - ファイルからバイト列を読み込み
5. **106-124行目**: `seek`メソッド - ファイル内の位置を移動
6. **126-132行目**: `close`メソッド - ファイルを閉じる

#### Step 2: Pydantic統合を理解する

PydanticバリデーションとOpenAPIスキーマ生成の仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | datastructures.py | `fastapi/datastructures.py` | Pydantic統合メソッド（134-152行目） |

**主要処理フロー**:
- **134-138行目**: `_validate`メソッド - StarletteUploadFileの検証
- **140-144行目**: `__get_pydantic_json_schema__` - OpenAPIスキーマ生成
- **146-152行目**: `__get_pydantic_core_schema__` - Pydanticコアスキーマ

#### Step 3: 再エクスポートを理解する

Starletteからの再エクスポートを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | __init__.py | `fastapi/__init__.py` | UploadFileのエクスポート（9行目） |

**主要処理フロー**:
- **9行目**: `from .datastructures import UploadFile as UploadFile`

### プログラム呼び出し階層図

```
HTTPリクエスト（multipart/form-data）
    │
    ▼
Starlette（リクエスト解析）
    │
    ▼
UploadFile（FastAPI）
    │
    ├─ filename    → str（ファイル名）
    ├─ size        → int（サイズ）
    ├─ content_type → str（MIME型）
    ├─ headers     → Headers（ヘッダー）
    │
    ├─ read()      → bytes（非同期）
    │      └─ super().read() → StarletteUploadFile.read()
    │
    ├─ write()     → None（非同期）
    │      └─ super().write() → StarletteUploadFile.write()
    │
    ├─ seek()      → None（非同期）
    │      └─ super().seek() → StarletteUploadFile.seek()
    │
    └─ close()     → None（非同期）
           └─ super().close() → StarletteUploadFile.close()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

クライアント
    │
    │ multipart/form-data
    ▼
Starlette ─────────────▶ UploadFileオブジェクト生成
                              │
                              ├─ filename ──────────▶ str
                              ├─ size ──────────────▶ int
                              ├─ content_type ──────▶ str
                              │
                              └─ read() ────────────▶ bytes
                                     │
                                     ▼
                              ファイル保存処理
                                     │
                                     ▼
                              ストレージ/DB
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| datastructures.py | `fastapi/datastructures.py` | ソース | UploadFileクラス定義 |
| __init__.py | `fastapi/__init__.py` | ソース | モジュールエクスポート定義 |
| param_functions.py | `fastapi/param_functions.py` | ソース | Fileパラメータ定義 |
| dependencies/utils.py | `fastapi/dependencies/utils.py` | ソース | UploadFile判定ロジック |
