# 機能設計書 34-FormData/QueryParams

## 概要

本ドキュメントは、FastAPIのFormData/QueryParamsデータ構造について、その設計意図、処理フロー、実装詳細を記述した機能設計書である。

### 本機能の処理概要

FormDataとQueryParamsは、HTTPリクエストのフォームデータとクエリパラメータを扱うためのデータ構造クラスである。Starletteから再エクスポートされ、FastAPIで一貫したAPIを提供する。

**業務上の目的・背景**：WebアプリケーションではHTMLフォームからのデータ送信やURLクエリパラメータからのデータ取得が頻繁に行われる。FormDataとQueryParamsは、これらのデータを効率的に扱うためのデータ構造を提供し、開発者が複数値の取得やイテレーションを容易に行えるようにする。

**機能の利用シーン**：
- HTMLフォームからの検索条件入力
- URLクエリストリングからのフィルタリング条件取得
- 複数選択項目（チェックボックス等）のデータ取得
- ページネーションパラメータの取得

**主要な処理内容**：
1. HTTPリクエストからFormData/QueryParamsオブジェクトを生成
2. キーによる値の取得（単一値または複数値）
3. イテレーションによる全項目の取得
4. ImmutableMultiDictとしての操作

**関連システム・外部連携**：なし（FastAPI内部のデータ構造）

**権限による制御**：権限制御機能はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | FormData/QueryParamsは画面を持たないバックエンド機能 |

## 機能種別

データ構造 / パラメータ処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| (QueryParams) scope | dict | No | リクエストスコープ（query_string含む） | なし |
| (FormData) items | list[tuple] | No | フォームデータの項目リスト | なし |

### 入力データソース

- QueryParams: URLのクエリ文字列（?key=value&key2=value2形式）
- FormData: HTTPリクエストボディ（application/x-www-form-urlencoded または multipart/form-data）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| get(key) | str | 指定キーの最初の値を取得 |
| getlist(key) | list[str] | 指定キーのすべての値をリストで取得 |
| keys() | Iterator[str] | すべてのキーのイテレータ |
| values() | Iterator[str] | すべての値のイテレータ |
| items() | Iterator[tuple[str, str]] | すべてのキーと値のペアのイテレータ |
| multi_items() | list[tuple[str, str]] | 重複キーを含むすべての項目 |

### 出力先

- エンドポイント関数内で使用

## 処理フロー

### 処理シーケンス

```
1. HTTPリクエスト受信
   └─ Starletteがリクエストを解析
2. パラメータ/データ抽出
   ├─ QueryParams: query_stringをパース
   └─ FormData: リクエストボディをパース
3. ImmutableMultiDictオブジェクト生成
   └─ キーと値のマッピングを保持
4. 開発者がデータにアクセス
   ├─ get(): 単一値取得
   ├─ getlist(): 複数値取得
   └─ items(): 全項目取得
```

### フローチャート

```mermaid
flowchart TD
    A[HTTPリクエスト] --> B{データタイプ}
    B -->|QueryString| C[QueryParams生成]
    B -->|FormBody| D[FormData生成]
    C --> E[ImmutableMultiDict]
    D --> E
    E --> F{アクセス方法}
    F -->|単一値| G[get key]
    F -->|複数値| H[getlist key]
    F -->|全項目| I[items/multi_items]
    G --> J[値を返却]
    H --> J
    I --> J
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-34-001 | イミュータブル | 値の変更は不可（読み取り専用） | すべての操作 |
| BR-34-002 | 複数値対応 | 同一キーで複数の値を保持可能 | getlist使用時 |
| BR-34-003 | デフォルト値 | get()でキーが存在しない場合はNone | get使用時 |

### 計算ロジック

計算ロジックは特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | FormData/QueryParams自体はDB操作を行わない |

### テーブル別操作詳細

FormData/QueryParamsはデータベース操作機能を持たない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | KeyError | 存在しないキーを[]でアクセス | get()を使用するか、キーの存在を確認 |

### リトライ仕様

リトライ機能は提供しない。

## トランザクション仕様

トランザクション管理は不要。

## パフォーマンス要件

- イミュータブルデータ構造のため、メモリ効率が良い
- 内部的にはdictベースの実装で高速なキーアクセス

## セキュリティ考慮事項

- イミュータブルなため、リクエストデータの改ざんを防止
- 入力値のバリデーションは別途必要

## 備考

- Starletteから再エクスポートされるクラス
- ImmutableMultiDictの特性を継承
- URL、Address、Headers、Stateなど他のデータ構造も同様に再エクスポート

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造の再エクスポートを理解する

FastAPIがStarletteからどのようにデータ構造を再エクスポートしているかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | datastructures.py | `fastapi/datastructures.py` | 再エクスポート定義（14-19行目） |

**読解のコツ**:
- `from starlette.datastructures import ... as ...`の形式で再エクスポート
- `# noqa: F401`は未使用importの警告を抑制

**主要処理フロー**:
1. **14行目**: `URL as URL` - URLクラスの再エクスポート
2. **15行目**: `Address as Address` - Addressクラスの再エクスポート
3. **16行目**: `FormData as FormData` - FormDataクラスの再エクスポート
4. **17行目**: `Headers as Headers` - Headersクラスの再エクスポート
5. **18行目**: `QueryParams as QueryParams` - QueryParamsクラスの再エクスポート
6. **19行目**: `State as State` - Stateクラスの再エクスポート

#### Step 2: 依存性注入での使用を理解する

依存性注入システムでFormData/QueryParamsがどのように使用されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | utils.py | `fastapi/dependencies/utils.py` | FormData、QueryParamsのimport（58-63行目） |

**主要処理フロー**:
- **58-63行目**: Starletteからのデータ構造import

### プログラム呼び出し階層図

```
HTTPリクエスト
    │
    ▼
Starlette（リクエスト解析）
    │
    ├─ QueryParams（クエリ文字列から生成）
    │      └─ ImmutableMultiDict
    │             ├─ get(key)
    │             ├─ getlist(key)
    │             ├─ keys()
    │             ├─ values()
    │             ├─ items()
    │             └─ multi_items()
    │
    └─ FormData（リクエストボディから生成）
           └─ ImmutableMultiDict
                  ├─ get(key)
                  ├─ getlist(key)
                  ├─ keys()
                  ├─ values()
                  ├─ items()
                  └─ multi_items()
```

### データフロー図

```
[入力]                    [処理]                           [出力]

URLクエリ文字列
?key1=val1&key2=val2
    │
    ▼
QueryParams ────────────▶ ImmutableMultiDict ───────────▶ 値取得
                              │
                              ├─ get("key1") ──────▶ "val1"
                              └─ getlist("key1") ──▶ ["val1"]


FormBody
key1=val1&key2=val2
    │
    ▼
FormData ────────────────▶ ImmutableMultiDict ───────────▶ 値取得
                              │
                              ├─ get("key1") ──────▶ "val1"
                              └─ getlist("key1") ──▶ ["val1"]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| datastructures.py | `fastapi/datastructures.py` | ソース | データ構造の再エクスポート |
| dependencies/utils.py | `fastapi/dependencies/utils.py` | ソース | 依存性注入でのデータ構造使用 |
