# 機能設計書 35-Middleware基盤

## 概要

本ドキュメントは、FastAPIのMiddleware基盤機能について、その設計意図、処理フロー、実装詳細を記述した機能設計書である。

### 本機能の処理概要

Middleware基盤は、HTTPリクエスト/レスポンスの処理をカスタマイズするための機能を提供する。リクエストがエンドポイントに到達する前、およびレスポンスがクライアントに返される前に、共通処理を挿入できる。

**業務上の目的・背景**：Webアプリケーションでは、認証、ログ記録、エラー処理、レスポンス変換など、すべてのリクエストに対して共通して行う処理が必要となる。Middleware基盤は、これらの横断的関心事を一元的に管理し、各エンドポイントに個別に実装する必要をなくすことで、コードの重複を削減し保守性を向上させる。

**機能の利用シーン**：
- すべてのリクエストに対するログ記録
- 認証トークンの検証
- レスポンスヘッダーの追加
- リクエスト処理時間の計測
- CORS、圧縮、リダイレクト等の共通処理

**主要な処理内容**：
1. FastAPIアプリケーション起動時にミドルウェアスタックを構築
2. リクエスト受信時にミドルウェアチェーンを順次実行
3. エンドポイント処理の実行
4. レスポンス送信時にミドルウェアチェーンを逆順で実行

**関連システム・外部連携**：Starletteミドルウェアとの完全な互換性を持つ。

**権限による制御**：Middleware基盤自体には権限制御機能はないが、認証ミドルウェアを実装することで権限制御が可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | Middleware基盤は画面を持たないバックエンド機能 |

## 機能種別

インターセプター / リクエスト/レスポンス処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| middleware_class | type[Middleware] | Yes | ミドルウェアクラス | ASGIミドルウェアインターフェース準拠 |
| *args | Any | No | ミドルウェアコンストラクタの位置引数 | なし |
| **kwargs | Any | No | ミドルウェアコンストラクタのキーワード引数 | なし |

### 入力データソース

- FastAPIアプリケーションの初期化時に`app.add_middleware()`で登録
- または`middleware`パラメータでリスト形式で渡す

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| なし | None | add_middleware()は戻り値を返さない |

### 出力先

- ミドルウェアスタックに追加され、リクエスト処理時に実行される

## 処理フロー

### 処理シーケンス

```
1. ミドルウェアスタック構築（アプリ起動時）
   └─ build_middleware_stack()でミドルウェアチェーンを構築
2. リクエスト受信
   └─ 最外層のミドルウェアから処理開始
3. ミドルウェアチェーン実行（外側→内側）
   ├─ ServerErrorMiddleware
   ├─ ユーザー定義ミドルウェア（登録順の逆順）
   ├─ AsyncExitStackMiddleware
   └─ ExceptionMiddleware
4. エンドポイント処理
   └─ ルーターがリクエストを処理
5. ミドルウェアチェーン実行（内側→外側）
   └─ 各ミドルウェアのレスポンス処理
6. レスポンス送信
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B[ServerErrorMiddleware]
    B --> C[ユーザーミドルウェア1]
    C --> D[ユーザーミドルウェア2]
    D --> E[AsyncExitStackMiddleware]
    E --> F[ExceptionMiddleware]
    F --> G[Router/Endpoint]
    G --> H[レスポンス生成]
    H --> F2[ExceptionMiddleware戻り]
    F2 --> E2[AsyncExitStackMiddleware戻り]
    E2 --> D2[ユーザーミドルウェア2戻り]
    D2 --> C2[ユーザーミドルウェア1戻り]
    C2 --> B2[ServerErrorMiddleware戻り]
    B2 --> I[レスポンス送信]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-35-001 | 実行順序 | ミドルウェアは登録順の逆順で実行される | リクエスト処理時 |
| BR-35-002 | ASGI互換 | ASGIミドルウェアインターフェースに準拠 | すべてのミドルウェア |
| BR-35-003 | チェーン構造 | 次のミドルウェアを呼び出すことでチェーンを形成 | すべてのミドルウェア |

### 計算ロジック

計算ロジックは特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | Middleware基盤自体はDB操作を行わない |

### テーブル別操作詳細

Middleware基盤はデータベース操作機能を持たない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ServerError | ミドルウェア内で未処理例外発生 | ServerErrorMiddlewareがキャッチ |
| - | HTTPException | ミドルウェア内でHTTPException発生 | ExceptionMiddlewareが処理 |

### リトライ仕様

リトライ機能は提供しない。

## トランザクション仕様

トランザクション管理は不要。

## パフォーマンス要件

- ミドルウェアはすべてのリクエストで実行されるため、軽量な処理が望ましい
- 重い処理はBackgroundTasksやキューを使用

## セキュリティ考慮事項

- 認証ミドルウェアはセキュリティの第一線として機能
- エラー時に機密情報を漏洩しないよう注意

## 備考

- Starletteの`Middleware`クラスを再エクスポート
- `@app.middleware("http")`デコレータでも登録可能
- BaseHTTPMiddlewareを使用すると同期コードも書きやすい

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: Middlewareクラスの再エクスポートを理解する

FastAPIがStarletteからMiddlewareをどのように再エクスポートしているかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | __init__.py | `fastapi/middleware/__init__.py` | Middlewareクラスの再エクスポート（1行目） |

**読解のコツ**:
- `from starlette.middleware import Middleware as Middleware`の形式で再エクスポート

**主要処理フロー**:
1. **1行目**: Starletteから`Middleware`クラスを再エクスポート

#### Step 2: ミドルウェアスタックの構築を理解する

FastAPIアプリケーションでミドルウェアスタックがどのように構築されるかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | applications.py | `fastapi/applications.py` | build_middleware_stack関数（998-1042行目付近） |

**主要処理フロー**:
- **992-995行目**: `user_middleware`リストの初期化
- **998-1042行目**: `build_middleware_stack()`でミドルウェアチェーン構築
- **1011-1014行目**: ミドルウェアの組み立て順序定義
- **1042行目**: ミドルウェアスタックを逆順でラップ

#### Step 3: AsyncExitStackMiddlewareを理解する

FastAPI固有のAsyncExitStackMiddlewareの役割を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | asyncexitstack.py | `fastapi/middleware/asyncexitstack.py` | AsyncExitStackMiddleware定義（1-18行目） |

**主要処理フロー**:
- **8-18行目**: `AsyncExitStackMiddleware`クラス - yield依存性のクリーンアップ用

### プログラム呼び出し階層図

```
FastAPI.__init__()
    │
    ├─ self.user_middleware = []
    │
    └─ build_middleware_stack()
           │
           ├─ ServerErrorMiddleware（最外層）
           │      │
           │      └─ ユーザーミドルウェア（登録順の逆順）
           │             │
           │             └─ AsyncExitStackMiddleware
           │                    │
           │                    └─ ExceptionMiddleware
           │                           │
           │                           └─ Router（エンドポイント）
           │
           └─ ミドルウェアスタック完成
```

### データフロー図

```
[入力]                    [処理]                           [出力]

HTTPリクエスト
    │
    ▼
ServerErrorMiddleware ─────────────────────────────────▶ エラーハンドリング
    │
    ▼
ユーザーミドルウェア ─────────────────────────────────▶ カスタム処理
    │
    ▼
AsyncExitStackMiddleware ─────────────────────────────▶ リソース管理
    │
    ▼
ExceptionMiddleware ─────────────────────────────────▶ 例外変換
    │
    ▼
Router ───────────────────────────────────────────────▶ エンドポイント
    │
    ▼
レスポンス（逆方向に伝搬）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| __init__.py | `fastapi/middleware/__init__.py` | ソース | Middlewareクラスの再エクスポート |
| asyncexitstack.py | `fastapi/middleware/asyncexitstack.py` | ソース | AsyncExitStackMiddleware定義 |
| applications.py | `fastapi/applications.py` | ソース | ミドルウェアスタック構築 |
