# 機能設計書 36-CORSミドルウェア

## 概要

本ドキュメントは、FastAPIのCORSミドルウェア機能について、その設計意図、処理フロー、実装詳細を記述した機能設計書である。

### 本機能の処理概要

CORSミドルウェア（Cross-Origin Resource Sharing）は、異なるオリジン（ドメイン、プロトコル、ポート）からのリクエストを制御するための機能を提供する。ブラウザのセキュリティ機能であるSame-Origin Policyを適切に緩和し、クロスオリジンリクエストを許可する。

**業務上の目的・背景**：モダンなWebアプリケーションでは、フロントエンド（React、Vue等）とバックエンドAPI（FastAPI）が異なるオリジンで動作することが一般的である。CORSミドルウェアは、ブラウザがクロスオリジンリクエストをブロックしないよう、適切なCORSヘッダーを付与することで、安全にAPIを公開できるようにする。

**機能の利用シーン**：
- SPAアプリケーションからのAPI呼び出し
- マイクロサービス間のAPI連携
- サードパーティアプリケーションへのAPI公開
- 開発環境でのフロントエンド・バックエンド分離

**主要な処理内容**：
1. プリフライトリクエスト（OPTIONS）の処理
2. CORSレスポンスヘッダーの付与
3. 許可オリジン、メソッド、ヘッダーの検証
4. 資格情報（Cookie等）の許可制御

**関連システム・外部連携**：ブラウザのCORS機能と連携して動作する。

**権限による制御**：オリジン、メソッド、ヘッダー単位でのアクセス制御が可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | CORSミドルウェアは画面を持たないバックエンド機能 |

## 機能種別

セキュリティ / アクセス制御

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| allow_origins | Sequence[str] | No | 許可するオリジンのリスト（デフォルト: []） | なし |
| allow_methods | Sequence[str] | No | 許可するHTTPメソッド（デフォルト: ["GET"]） | なし |
| allow_headers | Sequence[str] | No | 許可するHTTPヘッダー（デフォルト: []） | なし |
| allow_credentials | bool | No | 資格情報を許可するか（デフォルト: False） | なし |
| expose_headers | Sequence[str] | No | クライアントに公開するヘッダー（デフォルト: []） | なし |
| max_age | int | No | プリフライト結果のキャッシュ時間（秒） | なし |

### 入力データソース

- FastAPIアプリケーションの初期化時に`app.add_middleware(CORSMiddleware, ...)`で設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Access-Control-Allow-Origin | str | 許可されたオリジン |
| Access-Control-Allow-Methods | str | 許可されたメソッド |
| Access-Control-Allow-Headers | str | 許可されたヘッダー |
| Access-Control-Allow-Credentials | str | 資格情報の許可状態 |
| Access-Control-Expose-Headers | str | 公開ヘッダー |
| Access-Control-Max-Age | str | キャッシュ時間 |

### 出力先

- HTTPレスポンスヘッダー

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信
   └─ OriginヘッダーとMethodを確認
2. プリフライト判定
   └─ OPTIONSリクエストかつAccess-Control-Request-Methodヘッダーあり
3. プリフライト処理（該当する場合）
   ├─ 許可オリジンの検証
   ├─ 許可メソッドの検証
   ├─ 許可ヘッダーの検証
   └─ CORSヘッダー付きの200レスポンスを返却
4. 通常リクエスト処理
   ├─ 許可オリジンの検証
   ├─ 次のミドルウェア/エンドポイントを呼び出し
   └─ レスポンスにCORSヘッダーを付与
5. レスポンス送信
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B{Originヘッダーあり?}
    B -->|No| C[通常処理へ]
    B -->|Yes| D{プリフライト?}
    D -->|Yes| E{オリジン許可?}
    E -->|No| F[400 Bad Request]
    E -->|Yes| G{メソッド許可?}
    G -->|No| F
    G -->|Yes| H{ヘッダー許可?}
    H -->|No| F
    H -->|Yes| I[CORSヘッダー付き200応答]
    D -->|No| J{オリジン許可?}
    J -->|No| K[CORSヘッダーなしで応答]
    J -->|Yes| L[エンドポイント処理]
    L --> M[CORSヘッダー付きレスポンス]
    C --> N[エンドポイント処理]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-36-001 | ワイルドカード | allow_origins=["*"]ですべてのオリジンを許可 | 開発環境等 |
| BR-36-002 | 資格情報制限 | allow_credentials=Trueの場合、ワイルドカードは使用不可 | 資格情報許可時 |
| BR-36-003 | プリフライトキャッシュ | max_ageでブラウザのキャッシュ時間を制御 | パフォーマンス最適化時 |

### 計算ロジック

計算ロジックは特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | CORSミドルウェア自体はDB操作を行わない |

### テーブル別操作詳細

CORSミドルウェアはデータベース操作機能を持たない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | Bad Request | 許可されていないオリジン/メソッド/ヘッダー | CORS設定を確認 |

### リトライ仕様

リトライ機能は提供しない。

## トランザクション仕様

トランザクション管理は不要。

## パフォーマンス要件

- プリフライトリクエストはmax_age設定でキャッシュ可能
- すべてのクロスオリジンリクエストで処理されるため軽量な実装

## セキュリティ考慮事項

- 本番環境では`allow_origins=["*"]`の使用を避ける
- 信頼できるオリジンのみを明示的に許可
- `allow_credentials=True`の場合は特に慎重な設定が必要

## 備考

- StarletteのCORSMiddlewareを再エクスポート
- ブラウザのみがCORS制限を適用（サーバー間通信には影響なし）
- 開発時はより緩い設定、本番では厳格な設定を推奨

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: CORSMiddlewareの再エクスポートを理解する

FastAPIがStarletteからCORSMiddlewareをどのように再エクスポートしているかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | cors.py | `fastapi/middleware/cors.py` | CORSMiddlewareの再エクスポート（1行目） |

**読解のコツ**:
- `from starlette.middleware.cors import CORSMiddleware as CORSMiddleware`の形式で再エクスポート
- `# noqa`は未使用import警告の抑制

**主要処理フロー**:
1. **1行目**: Starletteから`CORSMiddleware`を再エクスポート

#### Step 2: ミドルウェアの登録方法を理解する

FastAPIアプリケーションでCORSMiddlewareをどのように登録するかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | applications.py | `fastapi/applications.py` | add_middleware関数の使用例 |

**主要処理フロー**:
- `app.add_middleware(CORSMiddleware, allow_origins=[...], allow_methods=[...], ...)`

### プログラム呼び出し階層図

```
リクエスト受信
    │
    ▼
CORSMiddleware
    │
    ├─ Originヘッダー確認
    │
    ├─ プリフライト判定（OPTIONSメソッド）
    │      │
    │      ├─ Yes: プリフライト応答
    │      │      ├─ オリジン検証
    │      │      ├─ メソッド検証
    │      │      ├─ ヘッダー検証
    │      │      └─ 200 + CORSヘッダー
    │      │
    │      └─ No: 通常処理
    │
    ├─ オリジン検証
    │
    └─ 次のミドルウェア/エンドポイント
           │
           └─ レスポンスにCORSヘッダー付与
```

### データフロー図

```
[入力]                    [処理]                           [出力]

HTTPリクエスト
    │
    ├─ Originヘッダー
    ├─ Method
    └─ Access-Control-Request-*
    │
    ▼
CORSMiddleware ─────────────────────────────────────▶ HTTPレスポンス
    │                                                    │
    ├─ オリジン検証 ────▶ 許可/拒否                       ├─ Access-Control-Allow-Origin
    ├─ メソッド検証 ────▶ 許可/拒否                       ├─ Access-Control-Allow-Methods
    └─ ヘッダー検証 ────▶ 許可/拒否                       ├─ Access-Control-Allow-Headers
                                                         ├─ Access-Control-Allow-Credentials
                                                         └─ Access-Control-Max-Age
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| cors.py | `fastapi/middleware/cors.py` | ソース | CORSMiddlewareの再エクスポート |
| applications.py | `fastapi/applications.py` | ソース | ミドルウェア登録機能 |
