# 機能設計書 38-HTTPSリダイレクト

## 概要

本ドキュメントは、FastAPIのHTTPSリダイレクトミドルウェア機能について、その設計意図、処理フロー、実装詳細を記述した機能設計書である。

### 本機能の処理概要

HTTPSRedirectMiddlewareは、HTTPリクエストを自動的にHTTPSにリダイレクトすることで、セキュアな通信を強制するミドルウェアである。

**業務上の目的・背景**：現代のWebアプリケーションでは、データの機密性と完全性を確保するためにHTTPS通信が必須となっている。HTTPSRedirectMiddlewareは、誤ってHTTPでアクセスしたクライアントを自動的にHTTPSにリダイレクトすることで、常にセキュアな通信を保証する。これにより、中間者攻撃（MITM）や通信の傍受を防止できる。

**機能の利用シーン**：
- 本番環境でのHTTPS強制
- SSL/TLS終端を行わないリバースプロキシ構成
- セキュリティポリシーの一元的な適用
- 旧URLからの自動リダイレクト

**主要な処理内容**：
1. リクエストのスキーム（http/https）を確認
2. HTTPリクエストの場合、HTTPSにリダイレクト
3. WebSocket（ws）の場合、wssにリダイレクト
4. 301リダイレクトレスポンスを返却

**関連システム・外部連携**：ロードバランサー、リバースプロキシとの連携。

**権限による制御**：権限制御機能はない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | HTTPSリダイレクトは画面を持たないバックエンド機能 |

## 機能種別

セキュリティ / リダイレクト

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| app | ASGIApp | Yes | 次のASGIアプリケーション | なし |

### 入力データソース

- FastAPIアプリケーションの初期化時に`app.add_middleware(HTTPSRedirectMiddleware)`で設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 301 Redirect | Response | HTTPSへのリダイレクトレスポンス |
| Location | str | リダイレクト先URL（httpsスキーム） |

### 出力先

- HTTPレスポンスヘッダー

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信
   └─ URLスキームを確認
2. スキーム判定
   ├─ https/wss → 通常処理へ
   └─ http/ws → リダイレクト処理
3. リダイレクト処理
   ├─ URLをhttps/wssに変換
   └─ 301レスポンスを返却
4. 通常処理（HTTPS）
   └─ 次のミドルウェア/エンドポイントへ
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B{スキーム確認}
    B -->|https| C[通常処理]
    B -->|wss| C
    B -->|http| D[HTTPSリダイレクト]
    B -->|ws| E[WSSリダイレクト]
    D --> F[301 Redirect]
    E --> F
    F --> G[Location: https://...]
    C --> H[エンドポイント処理]
    G --> I[クライアントが再リクエスト]
    I --> A
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-38-001 | 永続リダイレクト | 301 Moved Permanentlyを使用 | すべてのリダイレクト |
| BR-38-002 | WebSocket対応 | ws → wss へもリダイレクト | WebSocket接続時 |
| BR-38-003 | パス・クエリ保持 | リダイレクト時にパスとクエリパラメータを保持 | すべてのリダイレクト |

### 計算ロジック

計算ロジックは特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | HTTPSリダイレクト自体はDB操作を行わない |

### テーブル別操作詳細

HTTPSリダイレクトはデータベース操作機能を持たない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | エラーケースは特にない | - |

### リトライ仕様

リトライ機能は提供しない。クライアントが自動的にリダイレクト先にアクセスする。

## トランザクション仕様

トランザクション管理は不要。

## パフォーマンス要件

- リダイレクトは即座に実行され、オーバーヘッドは最小限
- 301リダイレクトはブラウザにキャッシュされるため、2回目以降は直接HTTPSにアクセス

## セキュリティ考慮事項

- 本番環境での使用を強く推奨
- ロードバランサーでSSL終端する場合は、X-Forwarded-Protoヘッダーの設定が必要
- HSTSヘッダーとの併用でさらなるセキュリティ強化

## 備考

- StarletteのHTTPSRedirectMiddlewareを再エクスポート
- 開発環境では無効化することが多い（HTTPで開発するため）
- リバースプロキシ構成では二重リダイレクトに注意

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: HTTPSRedirectMiddlewareの再エクスポートを理解する

FastAPIがStarletteからHTTPSRedirectMiddlewareをどのように再エクスポートしているかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | httpsredirect.py | `fastapi/middleware/httpsredirect.py` | HTTPSRedirectMiddlewareの再エクスポート（1-3行目） |

**読解のコツ**:
- `from starlette.middleware.httpsredirect import HTTPSRedirectMiddleware as HTTPSRedirectMiddleware`の形式で再エクスポート
- `# noqa`は未使用import警告の抑制

**主要処理フロー**:
1. **1-3行目**: Starletteから`HTTPSRedirectMiddleware`を再エクスポート

### プログラム呼び出し階層図

```
リクエスト受信
    │
    ▼
HTTPSRedirectMiddleware
    │
    ├─ スキーム確認
    │      │
    │      ├─ http → https リダイレクト
    │      ├─ ws → wss リダイレクト
    │      │      │
    │      │      └─ 301 Moved Permanently
    │      │             │
    │      │             └─ Location: https://...
    │      │
    │      └─ https/wss → 通常処理
    │
    └─ 次のミドルウェア/エンドポイント
```

### データフロー図

```
[入力]                    [処理]                           [出力]

HTTPリクエスト
http://example.com/api
    │
    ▼
HTTPSRedirectMiddleware
    │
    ├─ スキーム判定 ─────▶ http検出
    │
    └─ リダイレクト生成
           │
           ▼
    301 Moved Permanently
    Location: https://example.com/api


HTTPSリクエスト
https://example.com/api
    │
    ▼
HTTPSRedirectMiddleware
    │
    ├─ スキーム判定 ─────▶ https検出
    │
    └─ 通常処理 ─────────▶ エンドポイントへ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| httpsredirect.py | `fastapi/middleware/httpsredirect.py` | ソース | HTTPSRedirectMiddlewareの再エクスポート |
| applications.py | `fastapi/applications.py` | ソース | ミドルウェア登録機能 |
