# 機能設計書 39-TrustedHostミドルウェア

## 概要

本ドキュメントは、FastAPIのTrustedHostミドルウェア機能について、その設計意図、処理フロー、実装詳細を記述した機能設計書である。

### 本機能の処理概要

TrustedHostMiddlewareは、許可されたホスト名からのリクエストのみを受け付けることで、ホストヘッダー攻撃を防止するセキュリティミドルウェアである。

**業務上の目的・背景**：HTTPのHostヘッダーはクライアントが自由に設定できるため、悪意のある攻撃者がホストヘッダーを偽装してアプリケーションの動作を操作する攻撃（Host Header Injection）が可能となる。TrustedHostMiddlewareは、事前に定義した許可ホストリストと照合することで、不正なリクエストを拒否し、セキュリティを強化する。

**機能の利用シーン**：
- 本番環境でのホストヘッダー攻撃防止
- マルチドメイン環境での許可ホスト管理
- キャッシュポイズニング攻撃の防止
- パスワードリセットURL偽装攻撃の防止

**主要な処理内容**：
1. リクエストのHostヘッダーを取得
2. 許可ホストリストとの照合
3. 一致しない場合は400 Bad Requestを返却
4. 一致する場合は通常処理を続行

**関連システム・外部連携**：なし。

**権限による制御**：ホスト名単位でのアクセス制御。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | TrustedHostミドルウェアは画面を持たないバックエンド機能 |

## 機能種別

セキュリティ / アクセス制御

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| allowed_hosts | Sequence[str] | No | 許可するホスト名のリスト（デフォルト: ["*"]） | なし |
| www_redirect | bool | No | wwwサブドメインへのリダイレクト（デフォルト: True） | なし |

### 入力データソース

- FastAPIアプリケーションの初期化時に`app.add_middleware(TrustedHostMiddleware, allowed_hosts=[...])`で設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 400 Bad Request | Response | 許可されていないホストからのリクエスト時 |
| 301 Redirect | Response | www_redirect有効時のリダイレクト |

### 出力先

- HTTPレスポンス

## 処理フロー

### 処理シーケンス

```
1. リクエスト受信
   └─ Hostヘッダーを取得
2. ホスト検証
   ├─ 許可リストに存在 → 通常処理へ
   ├─ ワイルドカード許可 → 通常処理へ
   └─ 許可リストに不存在 → 400エラー
3. wwwリダイレクト（有効時）
   └─ www付きホストへリダイレクト
4. 通常処理
   └─ 次のミドルウェア/エンドポイントへ
```

### フローチャート

```mermaid
flowchart TD
    A[リクエスト受信] --> B[Hostヘッダー取得]
    B --> C{allowed_hostsに*あり?}
    C -->|Yes| D[通常処理]
    C -->|No| E{Hostが許可リストに存在?}
    E -->|Yes| F{www_redirect有効?}
    E -->|No| G[400 Bad Request]
    F -->|Yes| H{wwwなし?}
    F -->|No| D
    H -->|Yes| I[301 wwwへリダイレクト]
    H -->|No| D
    D --> J[エンドポイント処理]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-39-001 | ワイルドカード許可 | allowed_hosts=["*"]ですべてのホストを許可 | 開発環境等 |
| BR-39-002 | サブドメインワイルドカード | "*.example.com"形式で任意のサブドメインを許可 | マルチサブドメイン環境 |
| BR-39-003 | wwwリダイレクト | www_redirect=Trueでwww付きURLにリダイレクト | 正規化が必要な場合 |

### 計算ロジック

計算ロジックは特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | TrustedHostミドルウェア自体はDB操作を行わない |

### テーブル別操作詳細

TrustedHostミドルウェアはデータベース操作機能を持たない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 400 | Bad Request | 許可されていないホストからのアクセス | allowed_hostsに正しいホストを追加 |

### リトライ仕様

リトライ機能は提供しない。

## トランザクション仕様

トランザクション管理は不要。

## パフォーマンス要件

- ホスト名の照合は文字列比較のみで高速
- すべてのリクエストで実行されるため軽量な実装

## セキュリティ考慮事項

- 本番環境では必ず具体的なホスト名を指定
- `["*"]`は開発環境のみで使用
- ロードバランサー経由の場合はX-Forwarded-Hostの考慮が必要

## 備考

- StarletteのTrustedHostMiddlewareを再エクスポート
- DNS Rebinding攻撃の防止にも有効
- 複数ドメインを運用する場合はすべてのドメインを許可リストに追加

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: TrustedHostMiddlewareの再エクスポートを理解する

FastAPIがStarletteからTrustedHostMiddlewareをどのように再エクスポートしているかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | trustedhost.py | `fastapi/middleware/trustedhost.py` | TrustedHostMiddlewareの再エクスポート（1-3行目） |

**読解のコツ**:
- `from starlette.middleware.trustedhost import TrustedHostMiddleware as TrustedHostMiddleware`の形式で再エクスポート
- `# noqa`は未使用import警告の抑制

**主要処理フロー**:
1. **1-3行目**: Starletteから`TrustedHostMiddleware`を再エクスポート

### プログラム呼び出し階層図

```
リクエスト受信
    │
    ▼
TrustedHostMiddleware
    │
    ├─ Hostヘッダー取得
    │
    ├─ 許可ホスト照合
    │      │
    │      ├─ 許可 → 通常処理
    │      │
    │      └─ 拒否 → 400 Bad Request
    │
    ├─ wwwリダイレクト判定
    │      │
    │      └─ 必要時 → 301 Redirect
    │
    └─ 次のミドルウェア/エンドポイント
```

### データフロー図

```
[入力]                    [処理]                           [出力]

HTTPリクエスト
    │
    ├─ Host: example.com
    │
    ▼
TrustedHostMiddleware ─────────────────────────────────▶ HTTPレスポンス
    │                                                    │
    ├─ allowed_hosts: ["example.com"]                    ├─ 通常レスポンス（許可時）
    │                                                    ├─ 400 Bad Request（拒否時）
    └─ www_redirect: True                                └─ 301 Redirect（www時）


不正リクエスト
    │
    ├─ Host: malicious.com
    │
    ▼
TrustedHostMiddleware
    │
    └─ 照合失敗 ─────────────────────────────────────▶ 400 Bad Request
                                                        Invalid host header
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| trustedhost.py | `fastapi/middleware/trustedhost.py` | ソース | TrustedHostMiddlewareの再エクスポート |
| applications.py | `fastapi/applications.py` | ソース | ミドルウェア登録機能 |
