# 機能設計書 40-WSGIミドルウェア

## 概要

本ドキュメントは、FastAPIのWSGIミドルウェア機能について、その設計意図、処理フロー、実装詳細を記述した機能設計書である。

### 本機能の処理概要

WSGIMiddlewareは、WSGI（Web Server Gateway Interface）アプリケーションをASGI（Asynchronous Server Gateway Interface）アプリケーション内で実行するためのミドルウェアである。これにより、FlaskやDjango等の従来のWSGIアプリケーションをFastAPIアプリケーションに統合できる。

**業務上の目的・背景**：多くの既存Pythonウェブアプリケーションは、WSGIインターフェースを使用して構築されている。WSGIMiddlewareを使用することで、既存のWSGIアプリケーションを段階的にFastAPI（ASGI）に移行したり、両方のアプリケーションを同一プロセスで実行したりすることが可能となる。これにより、レガシーシステムのモダナイゼーションを容易にする。

**機能の利用シーン**：
- 既存のFlaskアプリケーションをFastAPIに段階移行
- DjangoアプリケーションとFastAPIの共存
- 特定のパスのみWSGIアプリケーションで処理
- レガシーWSGIコードの再利用

**主要な処理内容**：
1. ASGIリクエストをWSGI環境に変換
2. WSGIアプリケーションを呼び出し
3. WSGIレスポンスをASGIレスポンスに変換
4. 非同期コンテキストでの同期WSGIアプリケーション実行

**関連システム・外部連携**：Flask、Django、Bottle等のWSGIアプリケーション。

**権限による制御**：権限制御機能はない。WSGIアプリケーション側で実装する。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | WSGIミドルウェアは画面を持たないバックエンド機能 |

## 機能種別

アダプター / 互換性レイヤー

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| app | WSGIApp | Yes | WSGIアプリケーション（callableオブジェクト） | WSGIプロトコル準拠 |
| workers | int | No | ワーカースレッド数（デフォルト: 10） | 正の整数 |

### 入力データソース

- FastAPIアプリケーションのマウント時に`app.mount("/path", WSGIMiddleware(wsgi_app))`で設定

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ASGIレスポンス | Response | WSGIレスポンスをASGI形式に変換したもの |

### 出力先

- HTTPレスポンス

## 処理フロー

### 処理シーケンス

```
1. ASGIリクエスト受信
   └─ FastAPIがリクエストを受け取る
2. WSGI環境構築
   ├─ environ辞書の構築
   └─ start_responseコールバックの準備
3. WSGIアプリケーション呼び出し
   └─ スレッドプールで同期WSGIアプリを実行
4. レスポンス変換
   ├─ WSGIイテレータからボディを取得
   └─ ASGIレスポンスイベントに変換
5. レスポンス送信
   └─ クライアントにレスポンスを返却
```

### フローチャート

```mermaid
flowchart TD
    A[ASGIリクエスト] --> B[WSGI環境構築]
    B --> C[environ辞書作成]
    C --> D[WSGIアプリ呼び出し]
    D --> E[start_response受信]
    E --> F[レスポンスボディ取得]
    F --> G[ASGIレスポンス変換]
    G --> H[http.response.start]
    H --> I[http.response.body]
    I --> J[クライアントへ送信]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-40-001 | スレッドプール実行 | WSGIアプリは別スレッドで同期実行 | すべてのWSGI呼び出し |
| BR-40-002 | environ変換 | ASGIスコープをWSGI environに変換 | リクエスト処理時 |
| BR-40-003 | イテレータ処理 | WSGIレスポンスイテレータを順次処理 | レスポンス送信時 |

### 計算ロジック

計算ロジックは特になし。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | WSGIミドルウェア自体はDB操作を行わない |

### テーブル別操作詳細

WSGIミドルウェアはデータベース操作機能を持たない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 500 | Internal Server Error | WSGIアプリ内で例外発生 | WSGIアプリ側でエラーハンドリング |
| - | TypeError | 不正なWSGIアプリケーション | WSGIプロトコル準拠のアプリを使用 |

### リトライ仕様

リトライ機能は提供しない。

## トランザクション仕様

トランザクション管理はWSGIアプリケーション側で実装。

## パフォーマンス要件

- スレッドプールによる同期WSGIアプリの実行オーバーヘッドあり
- workers数の調整で並行処理能力を制御
- 大量のリクエストがある場合はネイティブASGI化を検討

## セキュリティ考慮事項

- WSGIアプリケーションのセキュリティはそのアプリ側で管理
- FastAPI側のセキュリティミドルウェアはWSGIアプリにも適用される

## 備考

- StarletteのWSGIMiddlewareを再エクスポート
- 段階的な移行戦略の実装に有用
- 完全な移行後はWSGIMiddlewareを削除することを推奨

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: WSGIMiddlewareの再エクスポートを理解する

FastAPIがStarletteからWSGIMiddlewareをどのように再エクスポートしているかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | wsgi.py | `fastapi/middleware/wsgi.py` | WSGIMiddlewareの再エクスポート（1行目） |

**読解のコツ**:
- `from starlette.middleware.wsgi import WSGIMiddleware as WSGIMiddleware`の形式で再エクスポート
- `# noqa`は未使用import警告の抑制

**主要処理フロー**:
1. **1行目**: Starletteから`WSGIMiddleware`を再エクスポート

### プログラム呼び出し階層図

```
ASGIリクエスト（FastAPI）
    │
    ▼
WSGIMiddleware
    │
    ├─ ASGI → WSGI変換
    │      │
    │      ├─ scope → environ
    │      │      ├─ REQUEST_METHOD
    │      │      ├─ PATH_INFO
    │      │      ├─ QUERY_STRING
    │      │      ├─ wsgi.input
    │      │      └─ ...
    │      │
    │      └─ start_response コールバック
    │
    ├─ WSGIアプリケーション呼び出し
    │      │
    │      └─ スレッドプールで実行
    │
    └─ WSGI → ASGI変換
           │
           ├─ ステータスコード
           ├─ レスポンスヘッダー
           └─ レスポンスボディ
                  │
                  ▼
           ASGIレスポンス
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ASGIリクエスト
    │
    ├─ scope
    ├─ receive
    └─ send
    │
    ▼
WSGIMiddleware
    │
    ├─ environ構築
    │      ├─ REQUEST_METHOD
    │      ├─ SCRIPT_NAME
    │      ├─ PATH_INFO
    │      ├─ QUERY_STRING
    │      ├─ CONTENT_TYPE
    │      ├─ CONTENT_LENGTH
    │      ├─ SERVER_NAME
    │      ├─ SERVER_PORT
    │      ├─ SERVER_PROTOCOL
    │      └─ wsgi.input（ボディ）
    │
    ├─ WSGIアプリ呼び出し
    │      │
    │      └─ response_body = app(environ, start_response)
    │
    └─ ASGIレスポンス生成
           │
           ├─ http.response.start
           │      ├─ status
           │      └─ headers
           │
           └─ http.response.body
                  └─ body
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| wsgi.py | `fastapi/middleware/wsgi.py` | ソース | WSGIMiddlewareの再エクスポート |
| applications.py | `fastapi/applications.py` | ソース | mount()機能 |
