# 機能設計書 49-ログ機能

## 概要

本ドキュメントは、FastAPIにおけるログ機能の設計と実装について記述する。この機能はアプリケーションログの出力機能を提供し、デバッグやモニタリングに使用される。

### 本機能の処理概要

**業務上の目的・背景**：Webアプリケーションの運用において、ログは問題のトラブルシューティング、パフォーマンス監視、セキュリティ監査に不可欠である。FastAPIは専用のロガーインスタンスを提供し、フレームワーク内部からの情報出力を一元的に管理できるようにしている。これにより、開発者はログレベルの調整やログハンドラの設定を通じて、必要な情報を効率的に取得できる。

**機能の利用シーン**：本機能は以下のシーンで利用される：
- アプリケーションのデバッグ時
- エラー発生時の原因調査
- パフォーマンス問題の分析
- セキュリティイベントの監視
- 本番環境でのモニタリング

**主要な処理内容**：
1. Python標準ライブラリloggingを使用したロガーインスタンスの作成
2. "fastapi"という名前空間でのロガー取得
3. アプリケーション全体で共有されるロガーの提供

**関連システム・外部連携**：Python標準ライブラリのloggingモジュールを直接使用。外部のログ収集ツール（ELK Stack、CloudWatch等）との連携はアプリケーション層で設定可能。

**権限による制御**：本機能自体は権限制御を行わない。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能は内部ユーティリティであり、直接関連する画面はない |

## 機能種別

ログ出力 / デバッグ支援 / モニタリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | - | logger.pyはパラメータを受け取らない | - |

### ロガー使用時のパラメータ（標準logging）

| メソッド | 説明 |
|---------|------|
| logger.debug(msg) | DEBUGレベルのログ出力 |
| logger.info(msg) | INFOレベルのログ出力 |
| logger.warning(msg) | WARNINGレベルのログ出力 |
| logger.error(msg) | ERRORレベルのログ出力 |
| logger.critical(msg) | CRITICALレベルのログ出力 |

### 入力データソース

アプリケーションコードからの呼び出し

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| logger | logging.Logger | "fastapi"名前空間のロガーインスタンス |

### 出力先

設定されたログハンドラ（デフォルトはコンソール出力）

## 処理フロー

### 処理シーケンス

```
1. logger.pyインポート
   └─ import logging
2. ロガー取得
   └─ logging.getLogger("fastapi")
3. ロガーエクスポート
   └─ logger変数として公開
```

### フローチャート

```mermaid
flowchart TD
    A[logger.pyインポート] --> B[logging.getLogger呼び出し]
    B --> C[fastapi名前空間ロガー作成/取得]
    C --> D[loggerとしてエクスポート]
    D --> E[アプリケーションで使用]
    E --> F{ログレベル判定}
    F -->|出力対象| G[ハンドラに出力]
    F -->|出力対象外| H[スキップ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-49-01 | 名前空間 | ロガーは"fastapi"名前空間で統一される | 常時 |
| BR-49-02 | 階層構造 | 子ロガー（例: "fastapi.routing"）は親の設定を継承 | 子ロガー使用時 |
| BR-49-03 | デフォルトレベル | デフォルトのログレベルはWARNING | 未設定時 |
| BR-49-04 | 遅延設定 | ロガーの設定はアプリケーション起動時に行う | 常時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本機能自体はデータベース操作を行わない）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | logging.getLoggerは例外を発生させない | - |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- ログ出力はI/O操作のため、過度なログ出力は性能に影響
- DEBUGレベルのログは本番環境では無効化推奨
- 非同期ログハンドラの使用で性能改善可能

## セキュリティ考慮事項

- 機密情報（パスワード、トークン等）をログに出力しないこと
- 本番環境ではDEBUGレベルを無効化
- ログファイルへの適切なアクセス制御

## 備考

- logger.pyは非常にシンプルな実装（3行のみ）
- ログ設定のカスタマイズはアプリケーション側で行う
- uvicornのロガーとは別のインスタンス

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

logger.pyの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | logger.py | `fastapi/logger.py` | ロガーインスタンスの作成 |

**読解のコツ**: logger.pyは3行のみの非常にシンプルな実装。Python標準のloggingモジュールの基本的な使い方を理解していれば十分。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | logger.py | `fastapi/logger.py` | 全コード |

**主要処理フロー**:
1. **1行目**: `import logging` - loggingモジュールのインポート
2. **3行目**: `logger = logging.getLogger("fastapi")` - ロガー取得

#### Step 3: 使用例を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | アプリケーションコード | - | ロガーの実際の使用方法 |

**使用例**:
```python
from fastapi.logger import logger

# ログ出力
logger.info("Application started")
logger.warning("Resource usage high")
logger.error("Database connection failed")

# ログ設定（アプリケーション側）
import logging
logging.basicConfig(level=logging.DEBUG)
```

### プログラム呼び出し階層図

```
fastapi.logger.logger
    │
    └─ logging.getLogger("fastapi")
           │
           └─ logging.Logger インスタンス
                  │
                  ├─ debug(msg)
                  ├─ info(msg)
                  ├─ warning(msg)
                  ├─ error(msg)
                  └─ critical(msg)
```

### データフロー図

```
[入力]                    [処理]                           [出力]

ログメッセージ ─────────▶ logger.info(msg) ─────────────▶ ログハンドラ
       │                      │                              │
       └─ "Request received"  ├─ レベル判定                  ├─ コンソール
                              ├─ フォーマット                ├─ ファイル
                              └─ ハンドラに出力              └─ 外部サービス
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| logger.py | `fastapi/logger.py` | ソース | ロガーインスタンスの定義 |
| __init__.py | `fastapi/__init__.py` | ソース | loggerのエクスポート（必要に応じて） |
