# 機能設計書 6-Headerパラメータ

## 概要

本ドキュメントは、FastAPIフレームワークにおけるHeaderパラメータ機能の設計を記述する。HTTPヘッダーから値を受け取るパラメータ定義機能であり、認証トークン等のヘッダー情報の取得に使用される。

### 本機能の処理概要

Headerパラメータは、HTTPリクエストのヘッダー（例：`Authorization`、`X-Token`）から値を抽出し、パスオペレーション関数の引数として渡す機能である。Python変数名のアンダースコアをハイフンに自動変換する機能を持ち、HTTPヘッダーの命名規則に適合する。

**業務上の目的・背景**：HTTPヘッダーはリクエストのメタデータを伝達する重要な手段である。認証トークン（Bearer Token）、APIキー、クライアント識別情報（User-Agent）、コンテンツネゴシエーション（Accept-Language）等、多様な情報がヘッダーで送受信される。本機能により、これらのヘッダー情報を型安全かつ宣言的に取得でき、手動でのヘッダー解析が不要になる。

**機能の利用シーン**：
- 認証トークンの取得（`Authorization: Bearer xxx`）
- カスタムAPIキーの取得（`X-API-Key: xxx`）
- クライアント情報の取得（`User-Agent: xxx`）
- ロケール情報の取得（`Accept-Language: ja`）

**主要な処理内容**：
1. HTTPヘッダーからパラメータ値の抽出
2. アンダースコア→ハイフン変換（convert_underscores=True時）
3. 型ヒントに基づく型変換
4. バリデーションルールに基づく値検証
5. OpenAPIスキーマへのパラメータ情報追加

**関連システム・外部連携**：Pydantic（FieldInfo基底クラス、バリデーション）、OpenAPI（スキーマ生成）

**権限による制御**：Authorizationヘッダーと組み合わせた認証処理に活用

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに直接の関連なし |

## 機能種別

パラメータ抽出 / バリデーション / 型変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| default | Any | No | デフォルト値（Undefinedで必須） | 任意 |
| convert_underscores | bool | No | アンダースコアをハイフンに変換（デフォルト: True） | ブール値 |
| alias | Optional[str] | No | パラメータの別名 | 文字列 |
| title | Optional[str] | No | 人間可読なタイトル（OpenAPI用） | 文字列 |
| description | Optional[str] | No | パラメータの説明（OpenAPI用） | 文字列 |
| gt | Optional[float] | No | より大きい | 数値のみ |
| ge | Optional[float] | No | 以上 | 数値のみ |
| lt | Optional[float] | No | より小さい | 数値のみ |
| le | Optional[float] | No | 以下 | 数値のみ |
| min_length | Optional[int] | No | 最小文字列長 | 文字列のみ |
| max_length | Optional[int] | No | 最大文字列長 | 文字列のみ |
| pattern | Optional[str] | No | 正規表現パターン | 文字列のみ |
| deprecated | Union[bool, str, None] | No | 非推奨フラグ | ブール値または文字列 |
| include_in_schema | bool | No | OpenAPIスキーマへの含有（デフォルト: True） | ブール値 |

### 入力データソース

- HTTPリクエストヘッダー
- パスオペレーション定義（関数シグネチャ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 変換後の値 | 型ヒントで指定した型 | 抽出・変換・検証済みのパラメータ値 |

### 出力先

- パスオペレーション関数の引数

## 処理フロー

### 処理シーケンス

```
1. ヘッダー名変換
   └─ Python変数名のアンダースコアをハイフンに変換（オプション）
2. ヘッダー値抽出
   └─ request.headersから対応する値を取得
3. デフォルト値適用
   └─ 値がなければデフォルト値を使用
4. 型変換・バリデーション
   └─ Pydanticによる処理
5. 関数引数への受け渡し
```

### フローチャート

```mermaid
flowchart TD
    A[HTTPリクエスト受信] --> B{convert_underscores?}
    B -->|Yes| C[変数名_→ヘッダー名-変換]
    B -->|No| D[変数名をそのまま使用]
    C --> E[ヘッダー値取得]
    D --> E
    E --> F{値が存在?}
    F -->|Yes| G[型変換・バリデーション]
    F -->|No| H{デフォルト値あり?}
    H -->|Yes| I[デフォルト値使用]
    H -->|No| J[422エラー]
    G --> K[関数引数に設定]
    I --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | アンダースコア変換 | user_agentはuser-agentヘッダーから取得 | convert_underscores=True（デフォルト） |
| BR-002 | 大文字小文字不問 | HTTPヘッダー名は大文字小文字を区別しない | 常時 |
| BR-003 | 複数値対応 | list[str]型で同一ヘッダーの複数値を取得可能 | リスト型ヒント時 |

### 計算ロジック

- ヘッダー名変換: `variable_name.replace("_", "-")` （convert_underscores=True時）

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本機能はデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 422 | Unprocessable Entity | 必須ヘッダーが未指定 | ヘッダーを送信する |
| 422 | Unprocessable Entity | バリデーション失敗 | 正しい値をヘッダーに設定 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- ヘッダー抽出は辞書アクセスで高速

## セキュリティ考慮事項

- Authorizationヘッダーは慎重に扱う（ログ出力に注意）
- X-で始まるカスタムヘッダーの命名を推奨
- ヘッダーインジェクション対策として適切なバリデーションを実施

## 備考

- HeaderクラスはParamを継承し、in_=ParamTypes.headerが設定される
- HTTPヘッダーの標準仕様（RFC 7230）に準拠

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Headerクラスの定義と継承関係を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | params.py | `fastapi/params.py` | Headerクラスの定義（304-385行目） |

**読解のコツ**:
- **304-305行目**: HeaderクラスはParamを継承、in_=ParamTypes.header
- **317行目**: convert_underscores: bool = True（デフォルトで変換有効）
- **353行目**: self.convert_underscores = convert_underscores

#### Step 2: 関数インターフェースを理解する

Header()関数の定義を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | param_functions.py | `fastapi/param_functions.py` | Header関数の定義（642-953行目） |

**主要処理フロー**:
1. **702-712行目**: convert_underscoresパラメータの定義
2. **922-953行目**: params.Headerインスタンスの生成と返却

### プログラム呼び出し階層図

```
@app.get("/items")
async def get_items(user_agent: str = Header()):
    │
    ├─ get_dependant() [dependencies/utils.py]
    │      └─ ヘッダーパラメータの依存性として登録
    │
    └─ solve_dependencies() [dependencies/utils.py]
           │
           ├─ request.headers取得
           ├─ convert_underscores適用
           ├─ Pydanticバリデーション
           └─ 関数引数への値設定
```

### データフロー図

```
[入力]                     [処理]                           [出力]

User-Agent: xxx ───▶ headers["user-agent"] ───▶ 変数名変換(user_agent→user-agent)
                                                    │
                                                    ▼
                                               型変換・バリデーション
                                                    │
                                                    ▼
                                         user_agent: str = "xxx" ───▶ 関数引数
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| param_functions.py | `fastapi/param_functions.py` | ソース | Header関数定義 |
| params.py | `fastapi/params.py` | ソース | Headerクラス定義 |
| dependencies/utils.py | `fastapi/dependencies/utils.py` | ソース | 依存性解決でのヘッダー処理 |
