# 機能設計書 7-Cookieパラメータ

## 概要

本ドキュメントは、FastAPIフレームワークにおけるCookieパラメータ機能の設計を記述する。HTTPクッキーから値を受け取るパラメータ定義機能であり、セッション管理等に使用される。

### 本機能の処理概要

Cookieパラメータは、HTTPリクエストのクッキー（例：`session_id=xxx`）から値を抽出し、パスオペレーション関数の引数として渡す機能である。クライアント側に保存された状態情報（セッションID、ユーザー設定等）を取得する際に使用される。

**業務上の目的・背景**：Webアプリケーションにおいて、ステートレスなHTTPプロトコル上でセッション管理やユーザー追跡を実現するためにクッキーが使用される。セッションID、認証トークン、ユーザー設定（言語、テーマ等）などの情報をクッキーから取得する必要がある。本機能により、クッキー値の抽出とバリデーションを宣言的に定義できる。

**機能の利用シーン**：
- セッションIDの取得（`session_id=xxx`）
- 永続的なログイン状態の確認（`remember_token=xxx`）
- ユーザー設定の取得（`theme=dark`、`locale=ja`）
- トラッキング情報の取得

**主要な処理内容**：
1. クッキーからパラメータ値の抽出
2. 型ヒントに基づく型変換
3. バリデーションルールに基づく値検証
4. OpenAPIスキーマへのパラメータ情報追加

**関連システム・外部連携**：Pydantic（FieldInfo基底クラス、バリデーション）、OpenAPI（スキーマ生成）

**権限による制御**：セッションクッキーと組み合わせた認証処理に活用

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに直接の関連なし |

## 機能種別

パラメータ抽出 / バリデーション / 型変換

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| default | Any | No | デフォルト値（Undefinedで必須） | 任意 |
| alias | Optional[str] | No | パラメータの別名 | 文字列 |
| title | Optional[str] | No | 人間可読なタイトル（OpenAPI用） | 文字列 |
| description | Optional[str] | No | パラメータの説明（OpenAPI用） | 文字列 |
| gt | Optional[float] | No | より大きい | 数値のみ |
| ge | Optional[float] | No | 以上 | 数値のみ |
| lt | Optional[float] | No | より小さい | 数値のみ |
| le | Optional[float] | No | 以下 | 数値のみ |
| min_length | Optional[int] | No | 最小文字列長 | 文字列のみ |
| max_length | Optional[int] | No | 最大文字列長 | 文字列のみ |
| pattern | Optional[str] | No | 正規表現パターン | 文字列のみ |
| deprecated | Union[bool, str, None] | No | 非推奨フラグ | ブール値または文字列 |
| include_in_schema | bool | No | OpenAPIスキーマへの含有（デフォルト: True） | ブール値 |

### 入力データソース

- HTTPリクエストのCookieヘッダー
- パスオペレーション定義（関数シグネチャ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 変換後の値 | 型ヒントで指定した型 | 抽出・変換・検証済みのパラメータ値 |

### 出力先

- パスオペレーション関数の引数

## 処理フロー

### 処理シーケンス

```
1. クッキーパース
   └─ Cookieヘッダーから名前=値のペアを抽出
2. 値の存在チェック
   └─ 値がなければデフォルト値を使用、必須なら422エラー
3. 型変換
   └─ 型ヒントに基づく変換
4. バリデーション実行
   └─ Pydanticによるバリデーションルール検証
5. 関数引数への受け渡し
```

### フローチャート

```mermaid
flowchart TD
    A[HTTPリクエスト受信] --> B[Cookieヘッダーパース]
    B --> C{指定クッキーが存在?}
    C -->|Yes| D[型変換]
    C -->|No| E{デフォルト値あり?}
    E -->|Yes| F[デフォルト値使用]
    E -->|No| G[422エラー]
    D --> H{バリデーション}
    F --> H
    H -->|成功| I[関数引数に設定]
    H -->|失敗| G
    I --> J[パスオペレーション実行]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | クッキー名は大文字小文字区別 | クッキー名は大文字小文字を区別する | 常時 |
| BR-002 | 値のURLデコード | クッキー値はURLデコードされる | 常時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本機能はデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 422 | Unprocessable Entity | 必須クッキーが未送信 | クッキーを送信する |
| 422 | Unprocessable Entity | バリデーション失敗 | 正しい値をクッキーに設定 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- クッキーパースは軽量な処理

## セキュリティ考慮事項

- セッションクッキーにはHttpOnly、Secure、SameSite属性を設定
- 機密情報はクッキーに格納しない（またはクライアント側で暗号化）
- クッキーハイジャック対策としてセッション固定化攻撃に注意
- CSRFトークンとの併用を推奨

## 備考

- CookieクラスはParamを継承し、in_=ParamTypes.cookieが設定される
- Swagger UIではクッキーのテストサポートが限定的

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Cookieクラスの定義と継承関係を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | params.py | `fastapi/params.py` | Cookieクラスの定義（388-467行目） |

**読解のコツ**:
- **388-389行目**: CookieクラスはParamを継承、in_=ParamTypes.cookie
- **393行目**: default: Any = Undefined（Queryと同様デフォルト値設定可能）
- Headerと異なりconvert_underscoresは存在しない

#### Step 2: 関数インターフェースを理解する

Cookie()関数の定義を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | param_functions.py | `fastapi/param_functions.py` | Cookie関数の定義（956-1255行目） |

**主要処理フロー**:
1. **956-964行目**: defaultパラメータ定義
2. **1225-1255行目**: params.Cookieインスタンスの生成と返却

### プログラム呼び出し階層図

```
@app.get("/items")
async def get_items(session_id: str = Cookie()):
    │
    ├─ get_dependant() [dependencies/utils.py]
    │      └─ クッキーパラメータの依存性として登録
    │
    └─ solve_dependencies() [dependencies/utils.py]
           │
           ├─ request.cookies取得
           ├─ Pydanticバリデーション
           └─ 関数引数への値設定
```

### データフロー図

```
[入力]                     [処理]                           [出力]

Cookie: session_id=abc ───▶ cookies["session_id"] ───▶ 型変換・バリデーション
                                                              │
                                                              ▼
                                           session_id: str = "abc" ───▶ 関数引数
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| param_functions.py | `fastapi/param_functions.py` | ソース | Cookie関数定義 |
| params.py | `fastapi/params.py` | ソース | Cookieクラス定義 |
| dependencies/utils.py | `fastapi/dependencies/utils.py` | ソース | 依存性解決でのクッキー処理 |
