# 機能設計書 9-Formパラメータ

## 概要

本ドキュメントは、FastAPIフレームワークにおけるFormパラメータ機能の設計を記述する。HTMLフォームから送信されるデータ（application/x-www-form-urlencoded形式）を受け取るパラメータ定義機能である。

### 本機能の処理概要

Formパラメータは、HTMLフォームから送信されるリクエストボディ（application/x-www-form-urlencoded形式）からデータを抽出し、パスオペレーション関数の引数として渡す機能である。Bodyパラメータの特殊形態として、フォーム送信データの処理に特化している。

**業務上の目的・背景**：従来型のWebアプリケーションでは、HTMLフォームによるデータ送信が一般的である。ログインフォーム、検索フォーム、問い合わせフォーム等、ユーザーインターフェースからのデータ入力を受け取る必要がある。本機能により、フォームデータのパースとバリデーションを宣言的に定義でき、従来型WebアプリケーションとAPIの共存を容易にする。

**機能の利用シーン**：
- ログインフォーム（username、password）
- OAuth2トークン取得（grant_type、username、password）
- 検索フォーム
- 問い合わせフォーム

**主要な処理内容**：
1. リクエストボディの読み取り
2. application/x-www-form-urlencoded形式のパース
3. 型ヒントに基づく型変換とバリデーション
4. OpenAPIスキーマへのフォームパラメータ情報追加

**関連システム・外部連携**：Pydantic（バリデーション）、OpenAPI（スキーマ生成）、HTMLフォーム、OAuth2

**権限による制御**：OAuth2フォームログインで使用

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面機能マッピングに直接の関連なし |

## 機能種別

パラメータ抽出 / バリデーション / フォームデータ処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| default | Any | No | デフォルト値（Undefinedで必須） | 任意 |
| media_type | str | No | メディアタイプ（デフォルト: "application/x-www-form-urlencoded"） | MIMEタイプ |
| alias | Optional[str] | No | パラメータの別名 | 文字列 |
| title | Optional[str] | No | 人間可読なタイトル（OpenAPI用） | 文字列 |
| description | Optional[str] | No | パラメータの説明（OpenAPI用） | 文字列 |
| gt | Optional[float] | No | より大きい | 数値のみ |
| ge | Optional[float] | No | 以上 | 数値のみ |
| lt | Optional[float] | No | より小さい | 数値のみ |
| le | Optional[float] | No | 以下 | 数値のみ |
| min_length | Optional[int] | No | 最小文字列長 | 文字列のみ |
| max_length | Optional[int] | No | 最大文字列長 | 文字列のみ |
| pattern | Optional[str] | No | 正規表現パターン | 文字列のみ |
| deprecated | Union[bool, str, None] | No | 非推奨フラグ | ブール値または文字列 |
| include_in_schema | bool | No | OpenAPIスキーマへの含有（デフォルト: True） | ブール値 |

### 入力データソース

- HTTPリクエストボディ（application/x-www-form-urlencoded形式）
- パスオペレーション定義（関数シグネチャ）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 変換後の値 | 型ヒントで指定した型 | パース・変換・検証済みのフォームデータ |

### 出力先

- パスオペレーション関数の引数

## 処理フロー

### 処理シーケンス

```
1. リクエストボディ読み取り
   └─ await request.form()でフォームデータ取得
2. フォームデータパース
   └─ キー=値のペアを辞書に変換
3. 型変換
   └─ 型ヒントに基づく変換
4. バリデーション実行
   └─ Pydanticによるバリデーションルール検証
5. 関数引数への受け渡し
```

### フローチャート

```mermaid
flowchart TD
    A[HTTPリクエスト受信] --> B[Content-Typeチェック]
    B --> C{form-urlencoded?}
    C -->|Yes| D[request.form取得]
    C -->|No| E[エラー]
    D --> F[キー=値パース]
    F --> G[型変換]
    G --> H{バリデーション}
    H -->|成功| I[関数引数に設定]
    H -->|失敗| J[422エラー]
    I --> K[パスオペレーション実行]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | Form/File排他 | FormとBodyは同時に使用不可 | Form使用時 |
| BR-002 | python-multipart必須 | Form処理にはpython-multipartパッケージが必要 | Form使用時 |
| BR-003 | URLエンコード | フォーム値はURLデコードされる | 常時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（本機能はデータベース操作を行わない）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 422 | Unprocessable Entity | 必須フィールドが未送信 | フィールドを送信する |
| 422 | Unprocessable Entity | バリデーション失敗 | 正しい値を送信 |
| 400 | Bad Request | フォームデータパースエラー | 正しい形式で送信 |

### リトライ仕様

該当なし

## トランザクション仕様

該当なし

## パフォーマンス要件

- フォームデータパースは軽量な処理

## セキュリティ考慮事項

- CSRF対策としてCSRFトークンの使用を推奨
- パスワードフィールドはHTTPS経由で送信
- フォームデータはログに記録しない（特に認証情報）

## 備考

- FormクラスはBodyを継承
- OAuth2PasswordRequestFormはFormの一般的なユースケース

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Formクラスの定義を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | params.py | `fastapi/params.py` | Formクラスの定義（582-661行目） |

**読解のコツ**:
- **582行目**: FormクラスはBodyを継承（`class Form(Body)`）
- **589行目**: media_type: str = "application/x-www-form-urlencoded"（Bodyと異なる）
- BodyのembedはFormには継承されない（フォームデータは単純なキー=値）

#### Step 2: 関数インターフェースを理解する

Form()関数の定義を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | param_functions.py | `fastapi/param_functions.py` | Form関数の定義（1585-1877行目） |

**主要処理フロー**:
1. **1606-1614行目**: media_typeパラメータ（デフォルト: application/x-www-form-urlencoded）
2. **1845-1877行目**: params.Formインスタンスの生成と返却

### プログラム呼び出し階層図

```
@app.post("/login")
async def login(username: str = Form(), password: str = Form()):
    │
    ├─ get_dependant() [dependencies/utils.py]
    │      └─ Formパラメータとして登録
    │
    └─ solve_dependencies() [dependencies/utils.py]
           │
           ├─ await request.form()
           ├─ FormData辞書から値抽出
           ├─ Pydanticバリデーション
           └─ 関数引数への値設定
```

### データフロー図

```
[入力]                     [処理]                           [出力]

POST /login
Content-Type: application/x-www-form-urlencoded
username=user&password=pass
         │
         ▼
    request.form() ───▶ {"username": "user", "password": "pass"}
                               │
                               ▼
                        型変換・バリデーション
                               │
                               ▼
                        username: str, password: str ───▶ 関数引数
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| param_functions.py | `fastapi/param_functions.py` | ソース | Form関数定義 |
| params.py | `fastapi/params.py` | ソース | Formクラス定義 |
| dependencies/utils.py | `fastapi/dependencies/utils.py` | ソース | フォームデータ処理 |
| security/oauth2.py | `fastapi/security/oauth2.py` | ソース | OAuth2PasswordRequestForm |
