---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-FastAPIアプリケーション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件（数ミリ秒）**：実測値による根拠なし
  2. **Pydantic v2完全互換**：互換性テストの詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `fastapi/applications.py` - FastAPIクラス定義（48-700行目）
- E-02: `fastapi/routing.py` - APIRouter、APIRouteクラス定義
- E-03: `fastapi/datastructures.py` - Default、DefaultPlaceholder定義
- E-04: `fastapi/param_functions.py` - パラメータ関数定義
- E-05: `fastapi/responses.py` - レスポンスクラス定義
- E-06: `fastapi/requests.py` - Requestクラス再エクスポート
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FastAPIはStarletteを継承している | E-01（48行目: `class FastAPI(Starlette)`） | ○ |
| C-02 | debugパラメータのデフォルト値はFalse | E-01（67-78行目） | ○ |
| C-03 | titleパラメータのデフォルト値は"FastAPI" | E-01（101-121行目） | ○ |
| C-04 | versionパラメータのデフォルト値は"0.1.0" | E-01（181-204行目） | ○ |
| C-05 | openapi_urlパラメータのデフォルト値は"/openapi.json" | E-01（205-227行目） | ○ |
| C-06 | docs_urlパラメータのデフォルト値は"/docs" | E-01（404-427行目） | ○ |
| C-07 | redoc_urlパラメータのデフォルト値は"/redoc" | E-01（428-451行目） | ○ |
| C-08 | default_response_classのデフォルトはJSONResponse | E-01（359-378行目） | ○ |
| C-09 | グローバル依存性はdependencies引数で設定 | E-01（337-358行目） | ○ |
| C-10 | OpenAPI設定の各パラメータが存在する | E-01（228-336行目） | ○ |
| C-11 | lifespanパラメータでライフサイクル管理可能 | E-01（534-545行目） | ○ |
| C-12 | APIRouterクラスが存在しルーティング管理を行う | E-02（664-690行目） | ○ |
| C-13 | APIRouteクラスがパスオペレーションを管理する | E-02（485-662行目） | ○ |
| C-14 | DefaultPlaceholderは値設定判定用ラッパー | E-03（155-170行目） | ○ |
| C-15 | レスポンスクラスにJSONResponse等が含まれる | E-05（全体） | ○ |
| C-16 | Swagger UIの設定がアプリケーション設定に依存 | E-08（行1-6） | ○ |
| C-17 | ReDocの設定がアプリケーション設定に依存 | E-08（行8-10） | ○ |
| C-18 | OpenAPI JSONがアプリケーション設定を使用 | E-08（行18-21） | ○ |
| C-19 | 機能カテゴリは「コア」に分類される | E-07（行2） | ○ |
| C-20 | root_path設定でプロキシ対応可能 | E-01（647-666行目） | ○ |
| C-21 | middleware引数でミドルウェア設定可能 | E-01（476-489行目） | ○ |
| C-22 | exception_handlers引数で例外ハンドラ設定可能 | E-01（490-508行目） | ○ |
| C-23 | AsyncExitStackMiddlewareが使用される | E-01（22行目のimport） | ○ |
| C-24 | インスタンス生成は数ミリ秒以内 | **根拠なし** | △ |
| C-25 | Pydantic v2との互換性が完全サポート | **明示的テスト結果なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の実測データが存在しない
  - 候補：ベンチマークテスト / 負荷テスト結果 / プロファイリングデータ
- Pydantic v2互換性の詳細なテスト結果
  - 候補：互換性テストスイート / マイグレーションガイド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要機能の根拠は全て確認済み
- 1: 中リスク - パフォーマンス要件は実測が必要

## 6) レビュアーチェックリスト（最小）
- [ ] FastAPIクラスのコンストラクタ引数が正確に記載されているか確認
- [ ] OpenAPI設定の連携が画面機能マッピングと整合しているか確認
- [ ] パフォーマンス要件の実測値を補完する必要があるか判断
- [ ] セキュリティ考慮事項が本番運用に十分か確認
