---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：11-Depends

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：定量的な数値根拠なし
  2. **トランザクション仕様**：ドキュメントベースの推論
  3. **ビジネスルールBR-11-02**：コード確認済みだが複雑な条件

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `fastapi/param_functions.py` Depends関数定義（2209-2286行目）
- E-02: `fastapi/params.py` Dependsデータクラス定義（746-756行目）
- E-03: `fastapi/dependencies/utils.py` analyze_param関数（357-524行目）
- E-04: `fastapi/dependencies/utils.py` get_dependant関数（251-323行目）
- E-05: `fastapi/dependencies/utils.py` solve_dependencies関数（563-700行目）
- E-06: `fastapi/dependencies/utils.py` _solve_generator関数（543-551行目）
- E-07: `fastapi/dependencies/utils.py` add_non_field_param_to_dependency関数（326-347行目）
- E-08: `fastapi/exceptions.py` DependencyScopeError例外クラス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Dependsはdependency, use_cache, scopeの3パラメータを持つ | E-01, E-02 | ○ |
| C-02 | use_cacheのデフォルト値はTrue | E-01（2222-2234行目） | ○ |
| C-03 | scopeは"function"または"request"のいずれか | E-02（750行目） | ○ |
| C-04 | dependency=Noneの場合は型アノテーションから推論される | E-03（441-444行目） | ○ |
| C-05 | 同一リクエスト内でキャッシュが再利用される | E-05（629-630行目） | ○ |
| C-06 | ジェネレータ依存関係はAsyncExitStackで管理される | E-06（548-551行目） | ○ |
| C-07 | 同期関数はrun_in_threadpoolで実行される | E-05（645行目） | ○ |
| C-08 | Dependsとデフォルト値の同時指定でAssertionError | E-03（420-428行目） | ○ |
| C-09 | scope="request"がscope="function"に依存するとエラー | E-04（284-293行目） | ○ |
| C-10 | SecurityScopesパラメータに自動的にスコープが注入される | E-05（690-693行目） | ○ |
| C-11 | Annotatedから依存関係が抽出される | E-03（372-378行目） | ○ |
| C-12 | params.Dependsはfrozenなdataclass | E-02（746行目） | ○ |
| C-13 | 依存関数の戻り値がパスオペレーション関数に注入される | E-05（646-647行目） | ○ |
| C-14 | キャッシュキーはcache_keyプロパティで管理 | E-05（629行目） | ○ |
| C-15 | 非同期関数はawaitで直接実行される | E-05（643行目） | ○ |
| C-16 | Securityクラスはscopesパラメータを追加で持つ | E-02（753-756行目） | ○ |
| C-17 | 依存関係の解決は再帰的に行われる | E-05（614-624行目） | ○ |
| C-18 | パフォーマンス要件として重複呼び出し防止がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の定量的な数値（レスポンス時間、スループット等）
  - 候補：ベンチマークテスト結果 / パフォーマンステスト仕様書 / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 入力パラメータ仕様、出力仕様
- 0: 低リスク - エラー処理仕様
- 1: 中リスク - ビジネスルールBR-11-02のスコープ制約（複雑な条件）
- 1: 中リスク - ジェネレータ依存関係のライフサイクル管理

## 6) レビュアーチェックリスト（最小）
- [ ] Dependsのパラメータ定義がコードと一致しているか確認
- [ ] use_cacheのデフォルト値がTrueであることを確認
- [ ] scopeパラメータの制約条件が正しく記載されているか確認
- [ ] DependencyScopeErrorの発生条件が正確か確認
- [ ] ジェネレータ依存関係のクリーンアップタイミングを確認
