---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-Security

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. **スコープの実際の検証**：依存関数内での実装が必要な点の確認
  2. **OpenAPI反映の正確性**：生成されるスキーマ形式の確認
  3. **Depends継承関係**：scopeパラメータの継承有無

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/param_functions.py` Security関数定義（2289-2369行目）
- E-02: `fastapi/params.py` Securityデータクラス定義（753-756行目）
- E-03: `fastapi/params.py` Dependsデータクラス定義（746-750行目）
- E-04: `fastapi/dependencies/utils.py` get_parameterless_sub_dependant関数（112-124行目）
- E-05: `fastapi/dependencies/utils.py` get_dependant関数（294-297行目）
- E-06: `fastapi/openapi/utils.py` get_openapi_security_definitions関数（78-101行目）
- E-07: `fastapi/dependencies/utils.py` solve_dependencies関数（690-693行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SecurityはDependsを継承している | E-02, E-03 | ○ |
| C-02 | scopesパラメータはSequence[str]型 | E-01（2302-2317行目） | ○ |
| C-03 | use_cacheのデフォルト値はTrue | E-01（2319-2332行目） | ○ |
| C-04 | params.Securityインスタンスを返す | E-01（2369行目） | ○ |
| C-05 | params.Securityの場合にスコープを抽出 | E-04（116-118行目） | ○ |
| C-06 | own_oauth_scopesにスコープを設定 | E-05（294-297行目） | ○ |
| C-07 | 同一スキームのスコープがマージされる | E-06（92-97行目） | ○ |
| C-08 | OpenAPI security要件として出力される | E-06（98-100行目） | ○ |
| C-09 | SecurityScopesにスコープ情報が注入される | E-07（690-693行目） | ○ |
| C-10 | scopesはOpenAPIのsecurity要件に反映される | E-06 | ○ |
| C-11 | dependencyパラメータは省略可能 | E-01（2289-2299行目） | ○ |
| C-12 | キャッシュ機能はDependsと同様 | E-02, E-03 | ○ |
| C-13 | スコープは親から子に伝播される | E-04, E-05 | ○ |
| C-14 | security_dependenciesからスキーム定義を抽出 | E-06（84-91行目） | ○ |
| C-15 | スコープ検証は依存関数内で実装が必要 | E-01（docstring） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張に根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 入力パラメータ仕様、Depends継承関係
- 0: 低リスク - OpenAPI反映仕様
- 1: 中リスク - スコープの伝播ロジック（複雑な依存関係の場合）

## 6) レビュアーチェックリスト（最小）
- [ ] SecurityがDependsを継承していることを確認
- [ ] scopesパラメータの型がSequence[str]であることを確認
- [ ] OpenAPIスキーマへのセキュリティ要件反映を確認
- [ ] スコープのマージロジックが正しいか確認
- [ ] SecurityScopesへのスコープ注入を確認
