---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-OAuth2認証

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **WWW-Authenticateヘッダー**：エラーレスポンスの形式確認
  2. **スコープ分割ロジック**：OAuth2PasswordRequestFormの動作確認
  3. **auto_errorのデフォルト値**：各クラスでの一貫性確認

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/security/oauth2.py` OAuth2クラス定義（306-406行目）
- E-02: `fastapi/security/oauth2.py` OAuth2PasswordBearerクラス定義（409-514行目）
- E-03: `fastapi/security/oauth2.py` OAuth2AuthorizationCodeBearerクラス定義（517-620行目）
- E-04: `fastapi/security/oauth2.py` OAuth2PasswordRequestFormクラス定義（14-148行目）
- E-05: `fastapi/security/oauth2.py` OAuth2PasswordRequestFormStrictクラス定義（150-303行目）
- E-06: `fastapi/openapi/models.py` OAuth2モデル定義（387-389行目）
- E-07: `fastapi/openapi/models.py` OAuthFlowsモデル定義（380-385行目）
- E-08: `fastapi/security/base.py` SecurityBaseクラス定義（1-7行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OAuth2PasswordBearerはtokenUrlが必須 | E-02（420-428行目） | ○ |
| C-02 | auto_errorのデフォルト値はTrue | E-02（458-477行目） | ○ |
| C-03 | scopesのデフォルト値は空辞書 | E-02（487-488行目） | ○ |
| C-04 | Authorizationヘッダーからトークンを取得 | E-02（507-508行目） | ○ |
| C-05 | スキームはbearerでなければならない | E-02（509行目） | ○ |
| C-06 | 認証失敗時にHTTPException 401を発生 | E-02（510-511行目） | ○ |
| C-07 | make_not_authenticated_errorでエラー生成 | E-01（377-397行目） | ○ |
| C-08 | WWW-Authenticate: Bearerヘッダーを含める | E-01（396行目） | ○ |
| C-09 | OAuth2PasswordRequestFormのusernameは必須 | E-04（74-83行目） | ○ |
| C-10 | OAuth2PasswordRequestFormのpasswordは必須 | E-04（84-93行目） | ○ |
| C-11 | scopeはスペースで分割してリストに変換 | E-04（145行目） | ○ |
| C-12 | grant_typeのパターンは^password$ | E-04（62-73行目） | ○ |
| C-13 | OAuth2クラスはSecurityBaseを継承 | E-01（306行目） | ○ |
| C-14 | OAuth2ModelをモデルとしてもつOAuth2モデル生成 | E-01（371-373行目） | ○ |
| C-15 | OAuth2AuthorizationCodeBearerはauthorizationUrlが必須 | E-03（525行目） | ○ |
| C-16 | refreshUrlパラメータでトークン更新URLを指定可能 | E-02（478-485行目） | ○ |
| C-17 | OAuthFlowsModel.passwordでパスワードフローを設定 | E-02（489-498行目） | ○ |
| C-18 | auto_error=Falseの場合はNoneを返す | E-02（512-513行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張に根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 入力パラメータ仕様
- 0: 低リスク - エラー処理仕様
- 1: 中リスク - 実際のトークン検証はユーザー実装が必要な点

## 6) レビュアーチェックリスト（最小）
- [ ] OAuth2PasswordBearerのtokenUrlパラメータが正しく設定されるか確認
- [ ] Bearerスキームの検証が大文字小文字を区別しないか確認
- [ ] HTTPException 401のレスポンス形式を確認
- [ ] OAuth2PasswordRequestFormのスコープ分割が正しいか確認
- [ ] OpenAPIスキーマへの反映を確認
