---
generated_at: 2026-01-22 20:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-OpenID Connect

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/security/open_id_connect_url.py` OpenIdConnectクラス定義（11-94行目）
- E-02: `fastapi/openapi/models.py` OpenIdConnectモデル（392-397行目）
- E-03: `fastapi/security/base.py` SecurityBaseクラス（1-7行目）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 機能No.18の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OpenIdConnectはスタブ実装である | E-01（12-20行目、docstring） | ○ |
| C-02 | openIdConnectUrlパラメータでOpenID Connect URLを指定 | E-01（25-32行目） | ○ |
| C-03 | scheme_nameパラメータでセキュリティスキーム名を指定 | E-01（33-42行目） | ○ |
| C-04 | auto_error=Trueで認証失敗時に例外発生 | E-01（53-72行目） | ○ |
| C-05 | Authorizationヘッダーをそのまま返却 | E-01（87-94行目） | ○ |
| C-06 | WWW-Authenticate: Bearerヘッダーを返却 | E-01（80-85行目） | ○ |
| C-07 | HTTP 401を返却 | E-01（81-84行目） | ○ |
| C-08 | SecurityBaseを継承 | E-01、E-03 | ○ |
| C-09 | OpenIdConnectModelを生成 | E-01（74-76行目）、E-02 | ○ |
| C-10 | 行番号11-94がOpenIdConnectクラス定義 | E-01 | ○ |
| C-11 | 行番号87-94が__call__メソッド | E-01 | ○ |
| C-12 | 行番号80-85がmake_not_authenticated_error | E-01 | ○ |
| C-13 | 完全なOpenID Connectフローは実装されていない | E-01（12-20行目、警告） | ○ |
| C-14 | 機能種別はセキュリティ/認証 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能
- 1: 中リスク - スタブ実装である旨の注意が必要（実際の認証ロジックは開発者が実装）

## 6) レビュアーチェックリスト（最小）
- [ ] OpenIdConnectがスタブ実装である旨が明記されているか確認
- [ ] openIdConnectUrlの用途が正確か確認
- [ ] Authorizationヘッダーの処理が正確か確認
- [ ] コードリーディングガイドの行番号が最新ソースコードと一致するか確認
