---
generated_at: 2026-01-22 20:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-SecurityScopes

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/security/oauth2.py` SecurityScopesクラス定義（623-663行目）
- E-02: `fastapi/dependencies/utils.py` get_flat_dependant関数（127-178行目）
- E-03: `fastapi/dependencies/utils.py` get_dependant関数（251-300行目）
- E-04: `fastapi/dependencies/utils.py` スコープ処理（294-297行目）
- E-05: `fastapi/params.py` Securityクラス（753-755行目）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` 機能No.19の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SecurityScopesはscopesとscope_strを持つ | E-01（647-663行目） | ○ |
| C-02 | scopesはスコープのリスト | E-01（647-654行目） | ○ |
| C-03 | scope_strはスペース区切りの文字列 | E-01（655-663行目、join使用） | ○ |
| C-04 | 依存関係チェーンのスコープが集約される | E-02（137-139行目） | ○ |
| C-05 | parent_oauth_scopesとown_oauth_scopesを結合 | E-02（137-139行目） | ○ |
| C-06 | SecurityScopesはFastAPIが自動注入 | E-01（623-634行目、docstring） | ○ |
| C-07 | Security依存関係のscopesから抽出 | E-04、E-05 | ○ |
| C-08 | 行番号623-663がSecurityScopesクラス定義 | E-01 | ○ |
| C-09 | 行番号127-178がget_flat_dependant関数 | E-02 | ○ |
| C-10 | 行番号137-139がスコープ結合処理 | E-02 | ○ |
| C-11 | スコープはOAuth2仕様に従いスペース区切り | E-01（655-663行目） | ○ |
| C-12 | scopesパラメータはNoneでも可 | E-01（638-646行目） | ○ |
| C-13 | sub_own_oauth_scopesに設定される | E-03（294-297行目） | ○ |
| C-14 | 機能種別はセキュリティ/認可 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] SecurityScopesのプロパティが正確か確認
- [ ] スコープ集約のロジックが正確か確認
- [ ] スペース区切り処理が正確か確認
- [ ] コードリーディングガイドの行番号が最新ソースコードと一致するか確認
