---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-APIRouter

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり、重点レビュー不要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `fastapi/routing.py` - APIRouterクラス定義（664-1100行目）
- E-02: `fastapi/params.py` - Dependsクラス定義（746-756行目）
- E-03: `fastapi/applications.py` - FastAPIクラスとinclude_router
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIRouterはStarletteのRouterを継承 | E-01（664行目: `class APIRouter(routing.Router)`） | ○ |
| C-02 | prefixパラメータが存在する | E-01（694行目） | ○ |
| C-03 | prefixは"/"で始まる必要がある | E-01（914-915行目: assert文） | ○ |
| C-04 | prefixは"/"で終わってはいけない | E-01（916-918行目: assert文） | ○ |
| C-05 | tagsパラメータでOpenAPIタグを設定可能 | E-01（695-708行目） | ○ |
| C-06 | dependenciesパラメータで共通依存性を設定可能 | E-01（709-720行目） | ○ |
| C-07 | default_response_classのデフォルトはJSONResponse | E-01（721-731行目） | ○ |
| C-08 | responsesパラメータでOpenAPIレスポンス定義可能 | E-01（732-747行目） | ○ |
| C-09 | callbacksパラメータでOpenAPIコールバック定義可能 | E-01（748-761行目） | ○ |
| C-10 | route_classパラメータでカスタムルートクラス指定可能 | E-01（813-823行目） | ○ |
| C-11 | deprecatedパラメータで非推奨マーク可能 | E-01（863-875行目） | ○ |
| C-12 | include_in_schemaでOpenAPI含有制御可能 | E-01（876-889行目） | ○ |
| C-13 | generate_unique_id_functionでID生成カスタマイズ可能 | E-01（890-904行目） | ○ |
| C-14 | add_api_route()でルート追加 | E-01（950-1030行目） | ○ |
| C-15 | api_route()がデコレータを返す | E-01（1032-1092行目） | ○ |
| C-16 | タグがルーターとエンドポイントで結合される | E-01（990-992行目） | ○ |
| C-17 | 依存性がルーターとエンドポイントで結合される | E-01（993-995行目） | ○ |
| C-18 | レスポンスがマージされる | E-01（985-986行目） | ○ |
| C-19 | パスがprefixと結合される | E-01（1003行目） | ○ |
| C-20 | deprecatedが継承される | E-01（1013行目） | ○ |
| C-21 | 機能カテゴリは「コア」に分類される | E-04（行3） | ○ |
| C-22 | OpenAPI JSONに登録ルート情報が反映される | E-05（行20） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] APIRouterのコンストラクタ引数が正確に記載されているか確認
- [ ] パス結合・タグ結合のロジックが実装と一致しているか確認
- [ ] ネストされたルーター構成のユースケースが網羅されているか確認
