---
generated_at: 2026-01-22 20:20:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-OpenAPIスキーマ生成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/openapi/utils.py` get_openapi関数（476-567行目）
- E-02: `fastapi/openapi/utils.py` get_openapi_path関数（259-442行目）
- E-03: `fastapi/openapi/utils.py` get_openapi_security_definitions関数（78-101行目）
- E-04: `fastapi/openapi/utils.py` _get_openapi_operation_parameters関数（104-174行目）
- E-05: `fastapi/openapi/utils.py` get_openapi_operation_request_body関数（177-209行目）
- E-06: `fastapi/openapi/utils.py` get_openapi_operation_metadata関数（233-256行目）
- E-07: `fastapi/openapi/utils.py` validation_error_definition（41-66行目）
- E-08: `fastapi/openapi/models.py` OpenAPIモデル（422-433行目）
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` 機能No.20の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OpenAPI 3.1.0準拠のスキーマを生成 | E-01（480行目、デフォルト値） | ○ |
| C-02 | get_openapi関数がメインエントリーポイント | E-01 | ○ |
| C-03 | title, versionパラメータは必須 | E-01（478-479行目） | ○ |
| C-04 | routesパラメータでルート定義を渡す | E-01（483行目） | ○ |
| C-05 | webhooksパラメータでWebhookを定義 | E-01（484行目） | ○ |
| C-06 | get_openapi_pathで各ルートのOpenAPI定義を生成 | E-02 | ○ |
| C-07 | get_openapi_security_definitionsでセキュリティ定義を生成 | E-03 | ○ |
| C-08 | operationIdの一意性を検証 | E-06（243-252行目） | ○ |
| C-09 | 422エラーレスポンスを自動追加 | E-02（418-438行目）、E-07 | ○ |
| C-10 | components/schemasはアルファベット順にソート | E-01（557行目、sorted使用） | ○ |
| C-11 | ヘッダーパラメータのアンダースコアをハイフンに変換 | E-04（150-155行目） | ○ |
| C-12 | include_in_schema=Falseは除外 | E-04（136-137行目） | ○ |
| C-13 | 行番号476-567がget_openapi関数 | E-01 | ○ |
| C-14 | 行番号259-442がget_openapi_path関数 | E-02 | ○ |
| C-15 | 行番号78-101がget_openapi_security_definitions関数 | E-03 | ○ |
| C-16 | jsonable_encoderで最終出力をJSON化 | E-01（567行目） | ○ |
| C-17 | OpenAPIモデルのインスタンスを生成 | E-01（567行目）、E-08 | ○ |
| C-18 | separate_input_output_schemas=Trueがデフォルト | E-01（490行目） | ○ |
| C-19 | スキーマはキャッシュされる | E-01（アプリケーション側でキャッシュ） | ○ |
| C-20 | 機能種別はドキュメント生成/API仕様定義 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] get_openapi関数のパラメータが正確か確認
- [ ] OpenAPI出力構造が正確か確認
- [ ] セキュリティ定義生成が正確か確認
- [ ] 422エラー自動追加のロジックが正確か確認
- [ ] コードリーディングガイドの行番号が最新ソースコードと一致するか確認
