---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-Swagger_UI.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **本番環境での無効化推奨**：公式ドキュメントの確認が必要
  2. **N/A**
  3. **N/A**

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/openapi/docs.py` 8-23行目 - swagger_ui_default_parameters定義
- E-02: `fastapi/openapi/docs.py` 26-158行目 - get_swagger_ui_html関数
- E-03: `fastapi/openapi/docs.py` 56行目 - swagger_js_urlデフォルト値
- E-04: `fastapi/openapi/docs.py` 66行目 - swagger_css_urlデフォルト値
- E-05: `fastapi/openapi/docs.py` 74行目 - swagger_favicon_urlデフォルト値
- E-06: `fastapi/applications.py` 404-427行目 - docs_urlパラメータ定義
- E-07: `fastapi/applications.py` 205-227行目 - openapi_urlパラメータ定義
- E-08: `fastapi/applications.py` 1079-1130行目 - setup()メソッド
- E-09: `fastapi/applications.py` 1093-1109行目 - swagger_ui_htmlルート登録
- E-10: `fastapi/applications.py` 906-908行目 - title/version必須チェック
- E-11: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能関連情報
- E-12: `fastapi/openapi/docs.py` 135-136行目 - JSONエンコード処理

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトエンドポイントは/docs | E-06 | ○ |
| C-02 | OpenAPIスキーマURLのデフォルトは/openapi.json | E-07 | ○ |
| C-03 | CDNからSwagger UIアセットを取得 | E-03, E-04 | ○ |
| C-04 | swagger_ui_default_parametersが存在する | E-01 | ○ |
| C-05 | get_swagger_ui_html関数がHTML生成を担当 | E-02 | ○ |
| C-06 | setup()メソッドでルート登録 | E-08, E-09 | ○ |
| C-07 | openapi_url設定時はtitle必須 | E-10 | ○ |
| C-08 | openapi_url設定時はversion必須 | E-10 | ○ |
| C-09 | docs_url=Noneで無効化可能 | E-06, E-09 | ○ |
| C-10 | OAuth2リダイレクトURLのサポート | E-02 (75-82行目, 138-139行目) | ○ |
| C-11 | init_oauthによるOAuth2初期化設定 | E-02 (83-90行目, 148-151行目) | ○ |
| C-12 | swagger_ui_parametersでカスタマイズ可能 | E-02 (91-100行目, 113-115行目) | ○ |
| C-13 | パラメータはJSONエンコードされる | E-12 | ○ |
| C-14 | HTMLResponseで返却 | E-02 (158行目) | ○ |
| C-15 | root_pathを取得してURL構築 | E-09 (1096-1097行目) | ○ |
| C-16 | 画面No.1としてSwagger UIが登録されている | E-11 | ○ |
| C-17 | デフォルトファビコンはFastAPI公式URL | E-05 | ○ |
| C-18 | 本番環境での無効化推奨 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18「本番環境での無効化推奨」について：コード上の制約ではなく、一般的なセキュリティプラクティスに基づく記述
  - 候補：FastAPI公式ドキュメント / セキュリティガイドライン / ベストプラクティス文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本機能はドキュメント表示機能であり、データ変更を伴わない

## 6) レビュアーチェックリスト（最小）
- [ ] swagger_ui_default_parametersの各設定項目の意味を確認
- [ ] OAuth2関連の設定が実際のプロジェクトで必要か確認
- [ ] 本番環境でのdocs_url無効化方針を確認
