---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-ReDoc.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **N/A** - すべての主張に根拠あり
  2. **N/A**
  3. **N/A**

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/openapi/docs.py` 161-253行目 - get_redoc_html関数
- E-02: `fastapi/openapi/docs.py` 182-191行目 - redoc_js_urlデフォルト値
- E-03: `fastapi/openapi/docs.py` 192-199行目 - redoc_favicon_urlデフォルト値
- E-04: `fastapi/openapi/docs.py` 200-207行目 - with_google_fontsデフォルト値
- E-05: `fastapi/openapi/docs.py` 228-231行目 - Google Fontsリンク追加処理
- E-06: `fastapi/openapi/docs.py` 245-248行目 - noscriptメッセージとredocカスタム要素
- E-07: `fastapi/applications.py` 428-451行目 - redoc_urlパラメータ定義
- E-08: `fastapi/applications.py` 1121-1130行目 - setup()でのReDocルート登録
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能関連情報

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトエンドポイントは/redoc | E-07 | ○ |
| C-02 | get_redoc_html関数がHTML生成を担当 | E-01 | ○ |
| C-03 | CDNからReDocアセットを取得 | E-02 | ○ |
| C-04 | デフォルトファビコンはFastAPI公式URL | E-03 | ○ |
| C-05 | with_google_fontsはデフォルトTrue | E-04 | ○ |
| C-06 | Google Fontsリンクが条件付きで追加される | E-05 | ○ |
| C-07 | redoc_url=Noneで無効化可能 | E-07, E-08 | ○ |
| C-08 | setup()メソッドでルート登録 | E-08 | ○ |
| C-09 | redocカスタム要素を使用してOpenAPIスキーマを参照 | E-06 | ○ |
| C-10 | noscriptメッセージが含まれる | E-06 | ○ |
| C-11 | HTMLResponseで返却 | E-01 (253行目) | ○ |
| C-12 | root_pathを取得してURL構築 | E-08 (1124-1125行目) | ○ |
| C-13 | 画面No.2としてReDocが登録されている | E-09 | ○ |
| C-14 | Montserrat/Robotoフォントがロードされる | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本機能はドキュメント表示機能であり、データ変更を伴わない

## 6) レビュアーチェックリスト（最小）
- [ ] with_google_fontsをFalseに設定する必要があるか（プライバシー/ネットワーク制限観点）
- [ ] ReDocバージョン（v2）が最新か確認
- [ ] 本番環境でのredoc_url有効化方針を確認
