---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-OAuth2リダイレクト.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **N/A** - すべての主張に根拠あり
  2. **N/A**
  3. **N/A**

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/openapi/docs.py` 256-344行目 - get_swagger_ui_oauth2_redirect_html関数
- E-02: `fastapi/openapi/docs.py` 262-263行目 - Swagger UI公式コードベースのコメント
- E-03: `fastapi/openapi/docs.py` 278-281行目 - URLフラグメント/クエリパラメータ解析
- E-04: `fastapi/openapi/docs.py` 292行目 - ステート検証
- E-05: `fastapi/openapi/docs.py` 294-298行目 - Authorization Code Flow判定条件
- E-06: `fastapi/openapi/docs.py` 299-306行目 - ステート不一致時の警告
- E-07: `fastapi/openapi/docs.py` 308-326行目 - code/error処理
- E-08: `fastapi/openapi/docs.py` 327-328行目 - Implicit/その他フロー処理
- E-09: `fastapi/openapi/docs.py` 330行目 - window.close()
- E-10: `fastapi/applications.py` 452-466行目 - swagger_ui_oauth2_redirect_urlパラメータ定義
- E-11: `fastapi/applications.py` 1111-1120行目 - setup()でのルート登録
- E-12: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能関連情報

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトエンドポイントは/docs/oauth2-redirect | E-10 | ○ |
| C-02 | get_swagger_ui_oauth2_redirect_html関数がHTML生成を担当 | E-01 | ○ |
| C-03 | Swagger UI公式のoauth2-redirect.htmlベース | E-02 | ○ |
| C-04 | URLフラグメントまたはクエリパラメータから解析 | E-03 | ○ |
| C-05 | stateパラメータによる検証を実施 | E-04 | ○ |
| C-06 | Authorization Code Flow判定条件（accessCode/authorizationCode/authorization_code） | E-05 | ○ |
| C-07 | ステート不一致時に警告コールバック | E-06 | ○ |
| C-08 | codeがある場合はauth.codeに設定 | E-07 (308-311行目) | ○ |
| C-09 | errorがある場合はエラーメッセージ構築 | E-07 (314-318行目) | ○ |
| C-10 | codeもerrorもない場合は汎用エラー | E-07 (320-325行目) | ○ |
| C-11 | Implicit/その他フローはtokenで処理 | E-08 | ○ |
| C-12 | 処理完了後にwindow.close() | E-09 | ○ |
| C-13 | setup()メソッドでルート登録 | E-11 | ○ |
| C-14 | swagger_ui_oauth2_redirect_url=Noneで無効化可能 | E-10, E-11 | ○ |
| C-15 | 画面No.3としてOAuth2リダイレクトが登録されている | E-12 | ○ |
| C-16 | 親ウィンドウのswaggerUIRedirectOauth2オブジェクトを参照 | E-01 (273行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本機能は認証フローの中継処理であり、直接的なデータ操作は行わない

## 6) レビュアーチェックリスト（最小）
- [ ] OAuth2フロー（Authorization Code / Implicit）の理解確認
- [ ] stateパラメータによるCSRF対策の有効性確認
- [ ] Swagger UIバージョンとの互換性確認
