---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-WebSocketException.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **N/A** - すべての主張に根拠あり
  2. **N/A**
  3. **N/A**

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/exceptions.py` 76-144行目 - WebSocketExceptionクラス定義
- E-02: `fastapi/exceptions.py` 7行目 - StarletteWebSocketExceptionのインポート
- E-03: `fastapi/exceptions.py` 118-144行目 - __init__メソッド（パラメータ定義）
- E-04: `fastapi/exceptions.py` 77-116行目 - クラスドキュメントと使用例
- E-05: `fastapi/exceptions.py` 120-128行目 - codeパラメータとRFC 6455参照
- E-06: `fastapi/exceptions.py` 129-142行目 - reasonパラメータ
- E-07: `fastapi/websockets.py` 1-3行目 - StarletteからのWebSocket関連インポート

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebSocketExceptionはStarletteWebSocketExceptionを継承 | E-01, E-02 | ○ |
| C-02 | codeパラメータは必須 | E-03, E-05 | ○ |
| C-03 | reasonパラメータはデフォルトNone | E-03, E-06 | ○ |
| C-04 | codeはRFC 6455準拠のクローズコード | E-05 | ○ |
| C-05 | reasonはUTF-8エンコード文字列 | E-06 | ○ |
| C-06 | クラスドキュメントに使用例がある | E-04 | ○ |
| C-07 | 使用例でstatus.WS_1008_POLICY_VIOLATIONを使用 | E-04 | ○ |
| C-08 | WebSocket接続でのエラー通知用途 | E-04 | ○ |
| C-09 | クライアントエラー用途を想定（認証失敗等） | E-04 | ○ |
| C-10 | FastAPIのWebSocket機能はStarletteに委譲 | E-07 | ○ |
| C-11 | WebSocketクラスはStarletteからインポート | E-07 | ○ |
| C-12 | WebSocketStateはStarletteからインポート | E-07 | ○ |
| C-13 | reasonの解釈はアプリケーション依存 | E-06 | ○ |
| C-14 | reasonは人間可読またはクライアントコード解釈用 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 例外クラス定義であり、WebSocketエラーハンドリングのための基盤機能

## 6) レビュアーチェックリスト（最小）
- [ ] reasonに機密情報を含めていないか確認
- [ ] 適切なクローズコード（RFC 6455）を使用しているか確認
- [ ] WebSocket接続のクリーンアップが適切に行われているか確認
