---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-RequestValidationError.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **N/A** - すべての主張に根拠あり
  2. **N/A**
  3. **N/A**

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/exceptions.py` 10-15行目 - EndpointContext TypedDict定義
- E-02: `fastapi/exceptions.py` 164-200行目 - ValidationException基底クラス
- E-03: `fastapi/exceptions.py` 202-211行目 - RequestValidationErrorクラス定義
- E-04: `fastapi/exceptions.py` 203-211行目 - __init__メソッド（errors、body、endpoint_ctx）
- E-05: `fastapi/exceptions.py` 180-181行目 - errors()メソッド
- E-06: `fastapi/exceptions.py` 183-199行目 - __str__メソッド（エラーメッセージフォーマット）
- E-07: `fastapi/exception_handlers.py` 20-26行目 - request_validation_exception_handler関数
- E-08: `fastapi/exception_handlers.py` 24行目 - status_code=422
- E-09: `fastapi/applications.py` 983-984行目 - デフォルト例外ハンドラ登録

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RequestValidationErrorはValidationExceptionを継承 | E-03 | ○ |
| C-02 | errorsパラメータはSequence[Any]型で必須 | E-02, E-04 | ○ |
| C-03 | bodyパラメータはデフォルトNone | E-04 | ○ |
| C-04 | endpoint_ctxパラメータはOptional | E-04 | ○ |
| C-05 | EndpointContextにfunction、path、file、lineを含む | E-01 | ○ |
| C-06 | errors()メソッドでエラーリストを取得可能 | E-05 | ○ |
| C-07 | __str__でエラーメッセージをフォーマット | E-06 | ○ |
| C-08 | request_validation_exception_handlerがデフォルトハンドラ | E-07, E-09 | ○ |
| C-09 | レスポンスのstatus_codeは422 | E-08 | ○ |
| C-10 | detailにjsonable_encoder(exc.errors())を設定 | E-07 (25行目) | ○ |
| C-11 | FastAPI初期化時にデフォルトハンドラ登録 | E-09 | ○ |
| C-12 | body属性でリクエストボディへの参照を保持 | E-04 (211行目) | ○ |
| C-13 | endpoint_function属性でエンドポイント関数名を保持 | E-02 (175行目) | ○ |
| C-14 | endpoint_path属性でエンドポイントパスを保持 | E-02 (176行目) | ○ |
| C-15 | endpoint_file属性でファイルパスを保持 | E-02 (177行目) | ○ |
| C-16 | endpoint_line属性で行番号を保持 | E-02 (178行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 例外クラス定義であり、バリデーションエラーハンドリングのための基盤機能

## 6) レビュアーチェックリスト（最小）
- [ ] エラー詳細に機密情報が含まれていないか確認
- [ ] カスタム例外ハンドラが必要な場合の実装方針を確認
- [ ] エラーメッセージの国際化対応が必要か確認
