---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-例外ハンドラ.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **N/A** - すべての主張に根拠あり
  2. **N/A**
  3. **N/A**

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/exception_handlers.py` 1-35行目 - exception_handlers.pyファイル全体
- E-02: `fastapi/exception_handlers.py` 11-17行目 - http_exception_handler関数
- E-03: `fastapi/exception_handlers.py` 20-26行目 - request_validation_exception_handler関数
- E-04: `fastapi/exception_handlers.py` 29-34行目 - websocket_request_validation_exception_handler関数
- E-05: `fastapi/exception_handlers.py` 13-14行目 - ボディ許可チェック
- E-06: `fastapi/exception_handlers.py` 24行目 - status_code=422
- E-07: `fastapi/exception_handlers.py` 32-33行目 - WS_1008_POLICY_VIOLATIONでクローズ
- E-08: `fastapi/applications.py` 15-18行目 - デフォルト例外ハンドラのインポート
- E-09: `fastapi/applications.py` 979-990行目 - デフォルトハンドラ登録
- E-10: `fastapi/applications.py` 982行目 - HTTPException用ハンドラsetdefault
- E-11: `fastapi/applications.py` 983-984行目 - RequestValidationError用ハンドラsetdefault
- E-12: `fastapi/applications.py` 986-989行目 - WebSocketRequestValidationError用ハンドラsetdefault
- E-13: `fastapi/applications.py` 1003-1016行目 - ミドルウェアスタック構築

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | http_exception_handlerが定義されている | E-02 | ○ |
| C-02 | request_validation_exception_handlerが定義されている | E-03 | ○ |
| C-03 | websocket_request_validation_exception_handlerが定義されている | E-04 | ○ |
| C-04 | http_exception_handlerはボディ許可チェックを行う | E-05 | ○ |
| C-05 | ボディ不許可時は空Responseを返す | E-05 | ○ |
| C-06 | ボディ許可時はJSONResponseを返す | E-02 (15-17行目) | ○ |
| C-07 | request_validation_exception_handlerは422を返す | E-06 | ○ |
| C-08 | websocket_request_validation_exception_handlerはWS_1008_POLICY_VIOLATIONで接続クローズ | E-07 | ○ |
| C-09 | FastAPI初期化時に3つのデフォルトハンドラが登録される | E-09, E-10, E-11, E-12 | ○ |
| C-10 | デフォルト例外ハンドラがアプリケーションにインポートされている | E-08 | ○ |
| C-11 | setdefaultで登録されるためカスタムハンドラが優先される | E-10, E-11, E-12 | ○ |
| C-12 | ExceptionMiddlewareでハンドラが使用される | E-13 | ○ |
| C-13 | http_exception_handlerはheadersを例外から取得 | E-02 (12行目) | ○ |
| C-14 | request_validation_exception_handlerはjsonable_encoderを使用 | E-03 (25行目) | ○ |
| C-15 | websocket_request_validation_exception_handlerはreasonにエラーを設定 | E-04 (33行目) | ○ |
| C-16 | すべてのハンドラは非同期関数 | E-02, E-03, E-04 (async def) | ○ |
| C-17 | http_exception_handlerはRequest型の引数を取る | E-02 (11行目) | ○ |
| C-18 | websocket_request_validation_exception_handlerはWebSocket型の引数を取る | E-04 (30行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 例外ハンドラ機能であり、適切なエラーレスポンス生成のための基盤機能

## 6) レビュアーチェックリスト（最小）
- [ ] カスタム例外ハンドラが必要な場合の実装方針を確認
- [ ] エラーレスポンスの形式がAPIクライアントの要件を満たしているか確認
- [ ] 本番環境でのエラー情報公開ポリシーを確認
