---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-WebSocket接続.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **N/A** - すべての主張に根拠あり
  2. **N/A**
  3. **N/A**

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/websockets.py` 1-3行目 - WebSocket関連クラスのインポート
- E-02: `fastapi/routing.py` 122-145行目 - websocket_session関数
- E-03: `fastapi/routing.py` 406-440行目 - get_websocket_app関数
- E-04: `fastapi/routing.py` 443-476行目 - APIWebSocketRouteクラス
- E-05: `fastapi/routing.py` 1115-1180行目 - websocketデコレータ
- E-06: `fastapi/routing.py` 1094-1113行目 - add_api_websocket_route関数
- E-07: `fastapi/routing.py` 130-131行目 - WebSocketインスタンス生成
- E-08: `fastapi/routing.py` 432-436行目 - バリデーションエラー時のWebSocketRequestValidationError
- E-09: `fastapi/routing.py` 470-476行目 - websocket_sessionでアプリ構築

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebSocketクラスはStarletteから再エクスポート | E-01 | ○ |
| C-02 | WebSocketDisconnectはStarletteから再エクスポート | E-01 | ○ |
| C-03 | WebSocketStateはStarletteから再エクスポート | E-01 | ○ |
| C-04 | websocket_session関数が存在する | E-02 | ○ |
| C-05 | websocket_sessionはASGIアプリケーションを生成 | E-02 | ○ |
| C-06 | get_websocket_app関数が依存性解決を行う | E-03 | ○ |
| C-07 | バリデーションエラー時はWebSocketRequestValidationErrorを発生 | E-08 | ○ |
| C-08 | APIWebSocketRouteクラスが存在する | E-04 | ○ |
| C-09 | APIWebSocketRouteはwebsocket_sessionを使用 | E-09 | ○ |
| C-10 | @app.websocketデコレータが存在する | E-05 | ○ |
| C-11 | websocketデコレータはadd_api_websocket_routeを呼び出す | E-05 (1175行目) | ○ |
| C-12 | add_api_websocket_route関数が存在する | E-06 | ○ |
| C-13 | add_api_websocket_routeはAPIWebSocketRouteを生成 | E-06 (1106行目) | ○ |
| C-14 | WebSocketインスタンスはscope、receive、sendから生成 | E-07 | ○ |
| C-15 | AsyncExitStackでリソース管理を行う | E-02 (133-141行目) | ○ |
| C-16 | 依存性注入が利用可能 | E-03, E-04 | ○ |
| C-17 | バリデーションエラー時は接続がクローズされる | E-08 | ○ |
| C-18 | エンドポイント関数はdependant.callで呼び出される | E-03 (438行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - WebSocket通信機能であり、適切な認証・認可の実装が必要

## 6) レビュアーチェックリスト（最小）
- [ ] WebSocket接続時の認証・認可が実装されているか確認
- [ ] 接続タイムアウトの設定が適切か確認
- [ ] wss://（WebSocket Secure）が使用されているか確認
