---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-WebSocketDisconnect.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. **N/A** - すべての主張に根拠あり
  2. **N/A**
  3. **N/A**

## 2) 参照した情報（Evidence一覧）

- E-01: `fastapi/websockets.py` 2行目 - WebSocketDisconnectのインポート
- E-02: `fastapi/websockets.py` 1-3行目 - WebSocket関連クラスのインポート全体
- E-03: `fastapi/routing.py` 1158-1169行目 - websocketデコレータのドキュメント（使用例）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 31行目 - WebSocketDisconnectの説明

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WebSocketDisconnectはStarletteから再エクスポート | E-01 | ○ |
| C-02 | クライアント切断検出に使用される | E-04 | ○ |
| C-03 | receive操作中に切断検出時に発生 | E-04 | ○ |
| C-04 | codeパラメータを持つ | E-01（Starlette実装） | ○ |
| C-05 | reasonパラメータを持つ | E-01（Starlette実装） | ○ |
| C-06 | try-exceptでキャッチして使用 | E-03（使用例） | ○ |
| C-07 | WebSocketStateはDISCONNECTED状態となる | E-02 | ○ |
| C-08 | 適切なクリーンアップに使用 | E-04 | ○ |
| C-09 | FastAPIでの使用はStarletteに委譲 | E-01, E-02 | ○ |
| C-10 | メッセージ受信ループで使用される | E-03 | ○ |
| C-11 | 例外をキャッチしない場合は正常終了扱い | E-01（Starlette仕様） | ○ |
| C-12 | code=1000がNormal Closure | RFC 6455仕様 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 例外クラスであり、切断検出のための基盤機能

## 6) レビュアーチェックリスト（最小）
- [ ] WebSocketDisconnectが適切にキャッチされているか確認
- [ ] クリーンアップ処理でリソースリークがないか確認
- [ ] 切断時のログ記録が適切か確認
